package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class DateTimeDelegate extends Delegate<DateTime, IToolkit_DateOrTimeEditor> {
  private DateTimeFormatter formatter;
  private String format;
  private DateTime oldDateTime;
  private boolean timeOnly;


  public DateTimeDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option... pickerOption) {
    super(factory, langIdx);

    boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);
    timeOnly = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.DATETIME_TIMEONLY, pickerOption);

    // space in between is necessary...   dd.MM.yy SPACE HH:mm
    format = factory.getTransProvider().getDefaultDelegateDateTimeEditorFormat();
    formatter = factory.getTransProvider().getDelegateDateTimeEditorFormatter(langIdx, null);
    toolkitEditor = factory.createDateAndTimeEditor(needsPicker, timeOnly);
    toolkitEditor.setDelegate(this);
    toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);
    toolkitEditor.setEditorPrompt(convertFormatToPromptString(format));
    oldDateTime = null;
  }

  public DateTime getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }

    try {
      DateTime returnDateTime = formatter.parseDateTime(toolkitEditor.getText());

      if (oldDateTime != null) {
        // changed ?
        if (returnDateTime.equals(oldDateTime.withSecondOfMinute(0))) {
          returnDateTime = returnDateTime.withSecondOfMinute(oldDateTime.getSecondOfMinute());
        }
      }

      return returnDateTime;

    } catch (Exception ex) {
      throw new RuntimeException(ex);

    }
  }
  public void setValue(DateTime value) {
    if (value != null) {
      oldDateTime = value;
      toolkitEditor.setText(formatter.print(value));

    } else {
      toolkitEditor.setText("");

    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");
    try {
      if (this.isCurrentlyInOptionalState()) {
        return null;
      }
      formatter.parseDateTime(toolkitEditor.getText());

    } catch (Exception ex) {
      String errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DATETIME_VALIDATION_ERR), format);
      toolkitEditor.setValidationErrorText(errText);
      return errText;

    }

    return null;
  }



  @Override
  public void setFormat(String frmt) {
    // overwrite that .. if necessary ??..
    if (frmt == null || "".equals(frmt.trim())) {
      // nothing .. skip it ..

    } else {
      if (frmt.lastIndexOf(" ") < 0) {
        throw new RuntimeException("Format has to contain one space to divide date from time format. Eg. dd.MM.yy[SPACE]HH:mm");
      }
      format = frmt;
      formatter = uiFactory.getTransProvider().getDelegateDateTimeEditorFormatter(langIndex, format);
      toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);
      toolkitEditor.setEditorPrompt(convertFormatToPromptString(format));

      setEnabled(false);
    }
  }


  public static String convertFormatToPromptString(String frmt) {
    String s = "";
    for (int i = 0; i < frmt.length(); i++) {
      char c = frmt.charAt(i);
      if (c == '.' || c == '/' || c == ':' || c == '\\') {
        s = s + c;
      } else {
        s = s + '_';
      }
    }
    return s;
  }

  private static boolean isSeperator(char c) {
    return c == '.' || c == ':' || c == ' ' || c == '/' || c == ',';
  }

  private static int toNextSeperator(String txt, int idx, String sep, StringBuilder res) {
    if (idx >= txt.length()) {
      return idx;
    }

    if (Character.isDigit(txt.charAt(idx))) {
      res.append(txt.charAt(idx));
      idx++;
    }

    if (idx < txt.length() && Character.isDigit(txt.charAt(idx))) {
      res.append(txt.charAt(idx));
      idx++;
    }

    if (idx < txt.length() && isSeperator(txt.charAt(idx))) {
      idx++;
    }

    res.append(sep);
    return idx;
  }

  public static String adjusDateTimeDotInputText(String txt) {
    // not taking into account the format, just something like aabbcchhmm 
    StringBuilder result = new StringBuilder();

    // 2701.80 14:00 2701801400 or 27.1.80 14:00 or 27.1.80 9.00 or 27.1.809:00
    // hardcoding the sperators is not THE general solution .. 

    int cur = toNextSeperator(txt, 0, ".", result);
    cur = toNextSeperator(txt, cur, ".", result);
    cur = toNextSeperator(txt, cur, " ", result);
    cur = toNextSeperator(txt, cur, ":", result);
    cur = toNextSeperator(txt, cur, "", result);
    result.append(txt.substring(cur));
    return result.toString();
  }

  public static void main(String[] args) {
    System.err.println(adjusDateTimeDotInputText("270180 1400"));
    System.err.println(adjusDateTimeDotInputText("2701801400"));
    System.err.println(adjusDateTimeDotInputText("27.01.80 14:00"));
    System.err.println(adjusDateTimeDotInputText("27.1.80 1 1"));
    System.err.println(adjusDateTimeDotInputText("27.1.80 1 1 dan"));
    System.err.println(adjusDateTimeDotInputText("2718011"));
    System.err.println(adjusDateTimeDotInputText("270180 9.00"));
    System.err.println(adjusDateTimeDotInputText("270180 9."));
    System.err.println(adjusDateTimeDotInputText("270180 9"));

    System.err.println(adjusDateTimeDotInputText("271.801.1"));

  }
}
