package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import java.math.BigDecimal;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import java.text.DecimalFormat;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import java.text.ParseException;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;
import java.text.ParsePosition;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import java.math.RoundingMode;

public class DecimalDelegate extends Delegate<BigDecimal, IToolkit_TextEditor> {
  protected DecimalFormat formatter;
  protected String format;

  protected MetaInfoLocalVar<BigDecimal> minimum = new MetaInfoLocalVar<BigDecimal>(null);
  protected MetaInfoLocalVar<BigDecimal> maximum = new MetaInfoLocalVar<BigDecimal>(null);
  protected MetaInfoLocalVar<Integer> scale = new MetaInfoLocalVar<Integer>(null);
  protected BigDecimal multiplier = new BigDecimal("1");

  public DecimalDelegate(IToolkit_UiFactory factory, int langIdx) {
    super(factory, langIdx);
    format = factory.getTransProvider().getDefaultDecimalFormat();
    formatter = factory.getTransProvider().getDecimalFormatter(langIdx, null);
    formatter.setParseBigDecimal(true);
    toolkitEditor = factory.createTextEditor();
    toolkitEditor.setDelegate(this);
  }

  public BigDecimal getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }
    try {
      return ((BigDecimal) formatter.parse(toolkitEditor.getText())).divide(multiplier);
    } catch (ParseException ex) {
      throw new RuntimeException(ex);
    }
  }
  public void setValue(BigDecimal value) {
    if (value != null) {
      toolkitEditor.setText(formatter.format(value.multiply(multiplier)));
    } else {
      toolkitEditor.setText("");
    }
  }

  @Override
  public void load(Object obj) {
    super.load(obj);
    if (metaInfo != null) {
      IOFXMetaRangeScale<BigDecimal> m = ((IOFXMetaRangeScale<BigDecimal>) metaInfo);
      minimum.setValue(m.getMin());
      maximum.setValue(m.getMax());
      scale.setValue(m.getScale());

      String frmt = m.getFormat();
      if (frmt != null) {
        setFormat(frmt);
      }
    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }

    BigDecimal deci;
    String errText = null;
    String text = "";
    try {
      toolkitEditor.setValidationErrorText("");

      if (isCurrentlyInOptionalState()) {
        // ok this is  an optional integer value, if user enters nothing, return 0
        return null;
      }

      text = toolkitEditor.getText();
      ParsePosition pp = new ParsePosition(0);
      deci = (BigDecimal) formatter.parse(text, pp);
      if (pp.getIndex() != text.length()) {
        throw new Exception("Parselength and stringlength do not match.");
      }

      deci = deci.divide(multiplier);

    } catch (Exception ex) {
      if (isCurrentlyInOptionalState()) {
        return null;
      }

      errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_VALIDATION_ERR), formatter.toLocalizedPattern(), text);
      toolkitEditor.setValidationErrorText(errText);
      return errText;

    }


    if (minimum.isValueSet() && maximum.isValueSet()) {
      if (deci.compareTo(minimum.getValue()) < 0 || deci.compareTo(maximum.getValue()) > 0) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_BETWEEN_ERR), minimum.getValue().multiply(multiplier).toString(), maximum.getValue().multiply(multiplier).toString());
      }
    } else if (minimum.isValueSet()) {
      if (deci.compareTo(minimum.getValue()) < 0) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_MINIMUM_ERR), minimum.getValue().multiply(multiplier).toString());
      }
    } else if (maximum.isValueSet()) {
      if (deci.compareTo(maximum.getValue()) > 0) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_MAXIMUM_ERR), maximum.getValue().multiply(multiplier).toString());
      }
    }

    // check scale if meta given and no other err.
    if (errText == null && scale.isValueSet()) {
      // is value after cutting to scale the same ?
      if (deci.setScale(scale.getValue(), RoundingMode.HALF_DOWN).compareTo(deci) != 0) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_SCALE_ERR), scale.getValue().toString());
      }
    }

    if (errText != null) {
      toolkitEditor.setValidationErrorText(errText);
    }
    return errText;
  }


  public void setMaximum(BigDecimal maxValue) {
    maximum.setValue(maxValue);
    maximum.setReadOnly();
  }

  public void setMinimum(BigDecimal minValue) {
    minimum.setValue(minValue);
    minimum.setReadOnly();
  }

  public void setMultiplicationFactor(BigDecimal factor) {
    multiplier = factor;
  }

  @Override
  public void setFormat(String frmt) {
    // we have to use formatString, since that particular string is used
    // in error reporting ..
    format = frmt.toLowerCase().replace("no0", "");
    formatter = uiFactory.getTransProvider().getDecimalFormatter(langIndex, format);
  }

}
