package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxElementHook;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegateHook;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.core.DelegateChange;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;
import java.text.ParseException;

public abstract class Delegate<T, Editor extends IToolkit_TextEditor> implements IDataUxDelegate<T> {
  protected MetaInfoLocalVar<Boolean> enabled = new MetaInfoLocalVar<Boolean>(true);
  protected MetaInfoLocalVar<Boolean> optional = new MetaInfoLocalVar<Boolean>(false);
  protected MetaInfoLocalVar<Boolean> requestFocus = new MetaInfoLocalVar<Boolean>(false);

  protected IOFXMetaBasis metaInfo;

  protected String propertyName;
  protected boolean objEnabledState;
  protected boolean issuesUpdate;
  protected int langIndex;
  protected int oldHash;


  protected Editor toolkitEditor;
  protected IToolkit_UiFactory uiFactory;
  private IDataUxElementHook dataUxElementHook;
  protected IUpdateConclusionReceiver updateConclusionResolver;
  protected IDataUxDelegateHook<T> delegateHook;

  protected T initialDelegateValue;

  public Delegate(IToolkit_UiFactory factory, int langIdx) {
    uiFactory = factory;
    issuesUpdate = false;
    langIndex = langIdx;
    oldHash = -1;
  }

  public abstract T getValue();
  public abstract void setValue(T val);
  public abstract String isInputValid();

  public void load(Object obj) {
    if (propertyName != null) {
      if (obj != null) {
        if (obj.hashCode() != oldHash) {
          toolkitEditor.newObjectBound();
        }
        oldHash = obj.hashCode();

      } else {
        toolkitEditor.newObjectBound();
      }

      objEnabledState = true;
      metaInfo = MoJSON.get(obj, getMetaDataAccessorToPath(propertyName));

      // check object s meta info ..
      if (obj instanceof IOFXEntity) {
        objEnabledState = ((IOFXEntity) obj).getEnabled();
      }

      // check optional and enabled ..
      if (metaInfo != null) {
        optional.setValue(metaInfo.getOptional());
        // both states have to be positive to get the editor enabled ..
        enabled.setValue(metaInfo.getEnabled() && objEnabledState);

        if (metaInfo.getLabel() != null) {
          String label = metaInfo.getLabel();
          toolkitEditor.setLabel(label);
        }
        String errorText = metaInfo.getValidationError();
        if (errorText != null && !(errorText.trim().equals(""))) {
          toolkitEditor.setValidationErrorText(errorText);
        }

      } else {
        enabled.setValue(objEnabledState);

      }

      // set Value
      initialDelegateValue = ((T) MoJSON.get(obj, propertyName));
      setValue(initialDelegateValue);

      // update user interface ..
      toolkitEditor.setEnabled(enabled.getValue());

      // check focus handling. compatible with leagacy forms3 focus handling
      if (enabled.getValue() && metaInfo != null) {
        if (metaInfo.getFocusAndClearIt()) {
          setRequestFocus(true);
        }
      }
    }
  }
  public final IDelegateChange store(Object obj) {
    IDelegateChange change = null;

    if (propertyName != null && enabled.getValue()) {
      T newValue = getValue();
      boolean changedValue = !(SaveObjectComperator.equals(initialDelegateValue, newValue));

      if (this instanceof DecimalDelegate) {
        changedValue = !(SaveObjectComperator.equalsBigDecimal(((BigDecimal) initialDelegateValue), ((BigDecimal) newValue)));

      } else if (this instanceof DateTimeDateDelegate) {
        changedValue = !(SaveObjectComperator.equalsDateOnDateTime(((DateTime) initialDelegateValue), ((DateTime) newValue)));

      } else if (this instanceof DateTimeDelegate) {
        changedValue = !(SaveObjectComperator.equalsDateTimeWithoutSeconds(((DateTime) initialDelegateValue), ((DateTime) newValue)));

      }

      if (changedValue) {
        change = new DelegateChange(obj.getClass().getSimpleName() + "." + propertyName, initialDelegateValue + " -> " + newValue);
      }
      ValueObjectReplacementFacility.put(obj, propertyName, newValue);
    }
    return change;
  }

  public void setProperty(String prop) {
    propertyName = prop;
  }
  public String getPropertyName() {
    return propertyName;
  }
  public void setLabel(String label) {
    toolkitEditor.setLabel(label);
  }
  public void setLabelTooltip(String label) {
    toolkitEditor.setLabelTooltip(label);
  }

  @Override
  public void setOptionalText(String text) {
    throw new RuntimeException("Not implemented for this delegate.");
  }
  public void setOptional(boolean opt) {
    optional.setValue(opt);
    optional.setReadOnly();
  }
  public void setEnabled(boolean enbl) {
    enabled.setValue(enbl);
    enabled.setReadOnly();
    toolkitEditor.setEnabled(enbl);
  }
  public void setDisableFORCE() {
    // used in delegateForm to disabled editors when
    // session is readonly.
    if (!(enabled.getValue()) || !(enabled.isReadOnly())) {
      enabled.setValueFORCE(false);
      enabled.setReadOnly();
      toolkitEditor.setEnabled(false);
    }
  }

  public void setOption(IToolkit_TextEditor.Option... options) {
    if (options.length > 0) {
      toolkitEditor.setOption(options);
    }
  }

  public void setRequestFocus(boolean val) {
    requestFocus.setValue(val);
  }
  public IToolkit_TextEditor getDelegateUiImpl() {
    return toolkitEditor;
  }

  public boolean isEnabled() {
    return enabled.getValue();
  }
  public boolean isRequestFocus() {
    return requestFocus.getValue();
  }
  public boolean isCurrentlyInOptionalState() {
    // a more complicated editor could also return null instead of getText ..
    return optional.getValue() == true && ("".equals(toolkitEditor.getText()) || toolkitEditor.getText() == null);
  }
  public void keyReleasedEvent() {
    try {
      if (dataUxElementHook != null && this.enabled.getValue()) {
        dataUxElementHook.delegateFormDataChanged(this);
      }
    } catch (RuntimeException ex) {
      if (ex.getCause() instanceof ParseException) {
        // BigDecimal ParseException when user enters empty values ...

      } else {
        throw ex;
      }
    }
  }
  public void setDelegateDataUxElementHook(IDataUxElementHook hook) {
    if (issuesUpdate) {
      throw new RuntimeException("Issue update conclusion and an elementHook are not supported at the same time for delegate " + propertyName);
    }

    dataUxElementHook = hook;
    toolkitEditor.enableKeyReleaseEvents();
  }
  @Override
  public void setDelegateHook(IDataUxDelegateHook<T> hook) {
    delegateHook = hook;
  }
  public boolean hasDelegateHook() {
    return delegateHook != null;
  }

  public void setFormat(String frmt) {
    // overwrite that .. if necessary ??..
    if (frmt == null || "".equals(frmt.trim())) {
      // nothing .. skip it ..
    } else {
      System.err.println("" + this.getClass().getName() + " does not implement setFormat()!");
    }
  }

  public void setIssuesUpdateConclusion(IUpdateConclusionReceiver rec) {
    if (dataUxElementHook != null) {
      throw new RuntimeException("Issue update conclusion and an elementHook are not supported at the same time for delegate " + propertyName);
    }

    updateConclusionResolver = rec;
    issuesUpdate = true;
    toolkitEditor.setIssuesUpdateConclusion();
  }
  public boolean issuesUpdate() {
    return issuesUpdate;
  }
  public void issueUpdateConclusionAfterContentChange() {
    updateConclusionResolver.issueUpdateConclusion(this);
  }

  @Override
  public String toString() {
    return "DLGT " + propertyName;
  }
  public void gcClear() {
    updateConclusionResolver = null;
    toolkitEditor.gcClear();
    uiFactory = null;
  }
  public void preDelayedAfterFullUiInitialized() {
    throw new RuntimeException("Not implemented.");
  }
  public static String getMetaDataAccessorToPath(String propPath) {
    return propPath + "_META";
  }
}
