package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ImageEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;

public class ImageDelegate extends Delegate<String, IToolkit_ImageEditor> {
  private String path;
  private String value;


  public ImageDelegate(IToolkit_UiFactory factory, int langIdx) {
    super(factory, langIdx);
    toolkitEditor = factory.createImageEditor();
    toolkitEditor.setDelegate(this);
  }



  @Override
  public void setFormat(String frmt) {
    toolkitEditor.setEditorPrompt(frmt);
  }
  public String getValue() {
    return value;
  }
  public void setValue(String val) {
    value = val;
    toolkitEditor.setText(value);
  }
  public String isInputValid() {
    return null;
  }

  public static String adjustPath(String location, String val) {
    if (val == null) {
      return null;
    }

    if (val.startsWith("http://") || val.startsWith("https://")) {
      // explicit request
      return val;
    } else if (location != null && !("".equals(location.trim()))) {
      // retrieve location set.
      return location + val;
    } else {
      // no location but val not null, simply use val for now.
      return val;
    }
  }

}
