package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class LocalDateDelegate extends Delegate<LocalDate, IToolkit_DateOrTimeEditor> {
  private DateTimeFormatter formatter;
  private String format;


  public LocalDateDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option... pickerOption) {
    super(factory, langIdx);
    format = factory.getTransProvider().getDefaultLocalDateFormat();
    formatter = factory.getTransProvider().getLocalDateFormatter(langIdx, null);

    boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);

    toolkitEditor = factory.createDateEditor(needsPicker);
    toolkitEditor.setDelegate(this);

    toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);
    toolkitEditor.setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(format));
  }

  public LocalDate getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }
    try {
      String text = toolkitEditor.getText();
      if (hasDelegateHook()) {
        return delegateHook.getValue(text);
      } else {
        return formatter.parseLocalDate(text);
      }
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
  public void setValue(LocalDate value) {
    if (value != null) {
      toolkitEditor.setText(formatter.print(value));
    } else {
      toolkitEditor.setText("");
    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    if (this.isCurrentlyInOptionalState()) {
      return null;
    }

    String errText;
    try {
      String val = toolkitEditor.getText();

      if (hasDelegateHook()) {
        errText = delegateHook.isInputValid(val);
        if (errText == null) {
          return null;
        }

      } else {

        formatter.parseLocalDate(val);
        return null;

      }


    } catch (Exception ex) {
      // can not convert
      errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DATE_VALIDATION_ERR), format);
    }


    toolkitEditor.setValidationErrorText(errText);
    return errText;
  }

  @Override
  public void setFormat(String frmt) {
    // overwrite that .. if necessary ??..
    if (frmt == null || "".equals(frmt.trim())) {
      // nothing .. skip it ..

    } else {
      format = frmt;
      formatter = uiFactory.getTransProvider().getLocalDateFormatter(langIndex, format);
      toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);

      toolkitEditor.setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(format));

      setEnabled(false);
    }
  }


  public static String adjusDateDotInputText(String txt) {
    // not taking into account the format exactly, just something like XX.XX.XX 
    if (txt.length() == 6) {
      boolean onlyDigits = true;
      for (int i = 0; i < txt.length(); i++) {
        if (!(Character.isDigit(txt.charAt(i)))) {
          onlyDigits = false;
          break;
        }
      }
      if (onlyDigits) {
        String stNew = txt.substring(0, 2) + "." + txt.substring(2, 4) + "." + txt.substring(4);
        return stNew;
      }
    }
    return txt;
  }

}
