package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaReferences;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import java.util.ArrayList;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class ReferenceDelegate<T> extends Delegate<T, IToolkit_ReferenceEditor> {
  public static final String GENERAL_OPTIONAL_ITEM_TEXT = "---";
  protected List<T> referenceItems;
  protected List<String> referenceDescriptions;
  protected List<String> suggestionFieldFormat;
  protected IOFXMetaReferences<T> metaInfo;



  public ReferenceDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option... alterOptions) {
    super(factory, langIdx);

    metaInfo = null;
    toolkitEditor = factory.createReferenceEditor(IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, alterOptions));

    toolkitEditor.setDelegate(this);
    toolkitEditor.setEditorPrompt(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.CRTL_SPACE_PRESS));

  }

  public T getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }
    // has to be done via getText() because in a search criteria, a clearKeyStore() can be called,
    // a different object can be loaded again to the form (old session) and scope is already from (new session)
    // take text to adopt to the new one ..
    int i = ListSequence.fromList(referenceDescriptions).indexOf(toolkitEditor.getText());
    if (i < 0) {
      throw new IllegalStateException("No reference found for given text (" + toolkitEditor.getText() + ") while obtaining value. Available are " + referenceDescriptions);
    }
    return ListSequence.fromList(referenceItems).getElement(i);
  }

  private int getIndexReplaceInScope(T origRef) {
    int i = ListSequence.fromList(referenceItems).indexOf(origRef);

    //  simple case
    if (i >= 0) {
      return i;
    }

    //  in search? otherwise, a double checkout would not be possible
    //  replace the item in scope, do not change the value of the delegate!
    if (origRef instanceof IOFXEntity) {
      Object refKey = ((IOFXEntity) origRef).getIM3Key();

      for (int j = 0; j < ListSequence.fromList(referenceItems).count(); j++) {
        boolean replaceAndReturn = false;
        Object ent = ListSequence.fromList(referenceItems).getElement(j);

        if (ent instanceof IOFXEntity) {
          Object candiate = ((IOFXEntity) ent).getIM3Key();
          if (SaveObjectComperator.equals(refKey, candiate)) {
            replaceAndReturn = true;
          }
        } else if (SaveObjectComperator.equals(origRef, ent)) {
          replaceAndReturn = true;
        }

        if (replaceAndReturn) {
          ListSequence.fromList(referenceItems).setElement(j, origRef);
          return j;
        }
      }
    }

    return -1;
  }

  public void setValue(T origRef) {

    if (origRef != null) {
      if (referenceItems == null) {
        // try ... not properly configured, no scope given ...
        // just render that stuff
        String desc = getObjAsString(origRef);
        toolkitEditor.setText(desc);

      } else {
        // dan oct 2024, moware 11 2024.29
        int i = getIndexReplaceInScope(origRef);

        if (i >= 0) {
          toolkitEditor.setText(ListSequence.fromList(referenceDescriptions).getElement(i));

        } else if (enabled.getValue()) {
          // more strict when enabled: not in scope ??
          throw new RuntimeException("Value '" + origRef + "' not in Scope " + referenceItems + " for ReferenceDelegate '" + propertyName + "'");
        }
      }
    } else {
      toolkitEditor.setText(null);
    }
  }

  public void setHintForScope(String val) {
    if (metaInfo != null) {
      MoJSON.put(metaInfo, "hintForScope", val);
    }
  }

  @Override
  public void load(Object obj) {
    setHintForScope("");
    metaInfo = null;
    Object metaObj = null;

    if (this.propertyName != null) {
      metaObj = MoJSON.get(obj, Delegate.getMetaDataAccessorToPath(this.propertyName));
      List<T> refItems = null;

      if (metaObj != null && metaObj instanceof IOFXMetaReferences) {
        IOFXMetaReferences<T> metaInformation = (IOFXMetaReferences<T>) metaObj;
        refItems = metaInformation.getScope();
        metaInfo = metaInformation;
      }

      // (refItems.size > 0 || (refItems.size == 0 && referenceItems.size != 0))
      // MoWare Smr 24 - no idea what the idea behind the condition above was 
      if (refItems != null) {
        setReferenceItems(refItems);
      }

    }
    super.load(obj);

    if (this.propertyName != null) {
      toolkitEditor.setOptionalAfterLoad(optional.getValue());
    }

    // Selection Crtl might load a null obj, metaObj will then be null also
    if (metaObj != null && enabled.getValue() && referenceItems == null) {
      throw new RuntimeException("No Scope [" + referenceItems + "] for ReferenceDelegate '" + propertyName + "' (and delegate not in read only).");

    }


  }

  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    // getText() returns item Text or null - if invalid item ...
    if (isCurrentlyInOptionalState()) {
      return null;
    }

    String errText = null;

    if (toolkitEditor.getText() == null || toolkitEditor.getText().equals("")) {
      errText = uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.REF_VALIDATION_ERR);
      toolkitEditor.setValidationErrorText(errText);
    }
    return errText;
  }


  @Override
  public void setFormat(String frmt) {
    setSuggestionFieldFormat(frmt.split(","));
  }

  public void setReferenceItems(List<T> elements) {
    if (referenceItems == elements || sameContent(referenceItems, elements)) {
      //  check if we can skip all the work : ) scope like previous

    } else {
      // setup popup ...
      referenceItems = elements;
      referenceDescriptions = ListSequence.fromList(new ArrayList<String>());
      for (int i = 0; i < ListSequence.fromList(elements).count(); i++) {
        ListSequence.fromList(referenceDescriptions).addElement(getObjAsString(ListSequence.fromList(elements).getElement(i)));
      }

      toolkitEditor.setItems(referenceDescriptions);
    }
  }
  public void setInputFieldFormat(String format) {
    throw new RuntimeException("no longer implemented");
  }
  public void setSuggestionFieldFormat(String[] elements) {
    suggestionFieldFormat = ListSequence.fromList(new ArrayList<String>());
    ListSequence.fromList(suggestionFieldFormat).addSequence(Sequence.fromIterable(Sequence.fromArray(elements)).select((it) -> it.trim()));
  }

  public void setSelected(T obj) {
    setValue(obj);
  }
  public Object getSelected() {
    return getValue();
  }

  protected static <T> boolean sameContent(List<T> l1, List<T> l2) {
    if (l1 == null || l2 == null || l1.size() != l2.size()) {
      return false;
    }
    for (int i = 0; i < l1.size(); i++) {

      if (!(SaveObjectComperator.equals(l1.get(i), l2.get(i)))) {
        return false;
      }
    }
    return true;
  }

  private String getObjAsString(final Object obj) {
    final StringBuilder tmp = new StringBuilder();
    ListSequence.fromList(suggestionFieldFormat).visitAll((field) -> {
      tmp.append(MoJSON.get(obj, field) + " ");
      // is that on purpose ? adding two spaces ?
      // obviously ..
    });
    return tmp.toString().trim();
  }


  @Override
  public void gcClear() {
    super.gcClear();
    metaInfo = null;
  }
}
