package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class StringDelegate extends Delegate<String, IToolkit_TextEditor> {

  protected MetaInfoLocalVar<Integer> minimum = new MetaInfoLocalVar<Integer>(null);
  protected MetaInfoLocalVar<Integer> maximum = new MetaInfoLocalVar<Integer>(null);

  public StringDelegate(IToolkit_UiFactory factory, int langIdx, int numOfLines) {
    super(factory, langIdx);
    if (numOfLines == 1) {
      toolkitEditor = factory.createTextEditor();
    } else {
      toolkitEditor = uiFactory.createTextAreaEditor(numOfLines);
    }
    toolkitEditor.setDelegate(this);
  }

  public StringDelegate(IToolkit_UiFactory factory, int langIdx) {
    this(factory, langIdx, 1);
  }

  public String getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }
    return toolkitEditor.getText();
  }
  public void setValue(String value) {
    if (value != null) {
      toolkitEditor.setText(value);
    } else {
      toolkitEditor.setText("");
    }
  }

  @Override
  public void load(Object obj) {
    super.load(obj);
    if (metaInfo != null) {
      IOFXMetaLength<Integer> m = ((IOFXMetaLength<Integer>) metaInfo);
      minimum.setValue(m.getMin());
      maximum.setValue(m.getMax());
    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    if (isCurrentlyInOptionalState()) {
      // ok this is  an optional integer value, if user enters nothing, return 0
      return null;
    }

    String errText = null;
    if (this.maximum.isValueSet() && this.enabled.getValue()) {
      if (this.getValue().length() > this.maximum.getValue()) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.STRING_MAX_ERR), "" + this.maximum.getValue());
      }
    }
    if (this.minimum.isValueSet() && this.enabled.getValue()) {
      if (this.getValue().length() < this.minimum.getValue()) {
        errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.STRING_MIN_ERR), "" + this.minimum.getValue());
      }
    }

    if (errText != null) {
      toolkitEditor.setValidationErrorText(errText);
    }

    return errText;
  }


  public void setMaxLength(int maxValue) {
    maximum.setValue(maxValue);
    maximum.setReadOnly();
  }

  public void setMinLength(int minValue) {
    minimum.setValue(minValue);
    minimum.setReadOnly();
  }


  public void setNumOfLines(int numOfLines) {
    // just skip that  ..
  }

}
