package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import java.text.DecimalFormat;

public class TableCellIntegerConverter implements ITableCellStringConverter<Integer> {
  private DecimalFormat formatter;
  private boolean doNotDisplayZeroValue = false;

  public TableCellIntegerConverter(DecimalFormat frmt, boolean noNullOption) {
    formatter = frmt;
    doNotDisplayZeroValue = noNullOption;
  }

  public String convert(Integer obj) {
    if (obj == null) {
      return "";
    }
    if (doNotDisplayZeroValue && obj.compareTo(0) == 0) {
      return "";
    }
    if (formatter == null) {
      return obj.toString();
    } else {
      return formatter.format(obj);
    }
  }
  public boolean isRightAligned() {
    return true;
  }
  public String getBgColor(Integer i) {
    return null;
  }
  public Integer convertBack(String s) {
    return new Integer(s);
  }
}
