package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UploadEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class UploadDelegate extends Delegate<String, IToolkit_UploadEditor> {

  public UploadDelegate(IToolkit_UiFactory factory, int langIdx) {
    super(factory, langIdx);
    toolkitEditor = factory.createUploadEditor();
    toolkitEditor.setDelegate(this);
  }

  @Override
  public void setValue(String value) {
    toolkitEditor.setText(value);
  }
  @Override
  public String getValue() {
    String value = toolkitEditor.getText();
    if (value != null && value.trim().equals("")) {
      // nothing here
      value = null;
    }
    return value;
  }
  @Override
  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    if (isCurrentlyInOptionalState()) {
      // ok this is  an optional integer value, if user enters nothing, return 0
      return null;
    }
    String errText = null;
    String val = this.getValue();
    if (val == null || val.length() < 2) {
      errText = uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.UPLOAD_CONTENT_ERR);
      toolkitEditor.setValidationErrorText(errText);
    }
    return errText;
  }
}
