package org.modellwerkstatt.dataux.runtime.genspecifications;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.IPagePaneSelCrtl;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.Workarounds2;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import java.util.Arrays;

public abstract class PagePane<T> implements IGenPagePane<T> {
  protected IPagePaneSelCrtl pagePaneController;
  protected IGenSelControlled pagePaneChild;
  protected IToolkit_Form responsibleForHeadingAndFlag;
  protected List<CmdAction> actions;

  protected Class pagePaneType;
  protected boolean pagePaneNeedsFullSizeWindow;
  protected String pagePaneColor = null;

  public PagePane(Class<T> type, boolean needsFullSizeWin) {
    this(type, needsFullSizeWin, null);

  }
  public PagePane(Class<T> type, boolean needsFullSizeWin, String color) {
    pagePaneType = type;
    pagePaneNeedsFullSizeWindow = needsFullSizeWin;
    pagePaneColor = color;
  }
  public Class getPagePaneType() {
    return pagePaneType;
  }
  public String calcUiColor(Object selectedRootObject) {
    return pagePaneColor;
  }
  public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
    // used in conclusions of commands to access selection controller
    return pagePaneController.getSelectionAbsolute(clazz, includingDerived);
  }
  public void pushSelection(IOFXSelection selection) {
    // used in conclusions of commands to access selection controller
    pagePaneController.pushSelectionAbsolute(selection);
  }
  public boolean pageNeedsMaxAvailableSpace() {
    return pagePaneNeedsFullSizeWindow;
  }
  public void setProblems(List<IOFXProblem> listOfProblems) {
    listOfProblems = Workarounds2.limitProblemsTo(8, listOfProblems);


    responsibleForHeadingAndFlag.setProblems(listOfProblems);
  }
  public void setHeading(String text) {
    responsibleForHeadingAndFlag.setTitleText(text);
  }

  public void installWithMenu(IToolkit_UiFactory factory, boolean childCanHandleFlagAndMenu, Menu menu) {
    IToolkit_FormContainer formContainer;

    if (childCanHandleFlagAndMenu) {
      formContainer = ((IToolkit_FormContainer) pagePaneChild.getToolkitImplementation());
    } else {
      formContainer = addContainerWithChild(factory, pagePaneChild);
    }

    pagePaneController.addActionAndInjectDependencies(menu, pagePaneController);
    formContainer.addMenuAndSetButtons(menu);
    responsibleForHeadingAndFlag = formContainer;
  }

  public void installWithoutMenu(IToolkit_UiFactory factory, boolean childCanHandleFlag) {
    if (childCanHandleFlag) {
      responsibleForHeadingAndFlag = pagePaneChild.getToolkitImplementation();
    } else {
      responsibleForHeadingAndFlag = addContainerWithChild(factory, pagePaneChild);
    }
  }

  public static IToolkit_FormContainer addContainerWithChild(IToolkit_UiFactory factory, IGenSelControlled child) {
    IToolkit_FormContainer frmc = factory.createToolkitFormContainer(false);
    frmc.setLayoutConstraints(Arrays.<String>asList("1*"), Arrays.<String>asList("1*"));
    frmc.addChildren(child.getToolkitImplementation());
    return frmc;
  }

  public IToolkit_Form getPagePaneToolkitImpl() {
    return responsibleForHeadingAndFlag;
  }
  public void gcClear() {
    // Actions are gcCleared by pageCrtl
  }
}
