package org.modellwerkstatt.dataux.runtime.httpapi;

/*Generated by MPS */

import java.util.HashMap;

public abstract class ApiDescription implements IApiGen {
  private String shortName;
  private int apiVersion;

  private HashMap<String, ApiOperationBase> operations = new HashMap<String, ApiOperationBase>();

  public ApiDescription(String name, int apiVers) {
    shortName = name;
    apiVersion = apiVers;
  }

  @Override
  public String getApiShortName() {
    return shortName;
  }
  @Override
  public int getApiVersion() {
    return apiVersion;
  }

  private String keyFor(String loc, String method) {
    return method.toLowerCase() + "-" + loc;
  }
  public boolean hasOperation(String loc, String method) {
    String key = keyFor(loc, method);
    return operations.containsKey(key);
  }

  public ApiOperationBase getOperationOrNull(String loc, String method) {
    String key = keyFor(loc, method);
    return operations.get(key);
  }

  public void addOperation(ApiOperationBase op) {
    String key = keyFor(op.getLocation(), op.getMethod());
    operations.put(key, op);
  }

  public String printDebugInfo() {
    String st = "Operations \n";

    for (String key : operations.keySet()) {
      st += "- " + key + " is " + operations.get(key) + "\n";
    }

    return st;
  }
}
