package org.modellwerkstatt.dataux.runtime.httpapi;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.sdservices.JackyGraphSerdes;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.sdservices.JackyParsed;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.BaseSerdes;
import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.sdservices.VList;
import java.util.List;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import java.util.Arrays;
import java.io.IOException;
import java.io.StringWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.JackyFieldSerdes;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class ApiEndpointJSonSerdes implements IApiEndpointSerdes {
  private JackyInfra infra;

  private HashMap<Integer, JackyGraphSerdes> partialSerdes = new HashMap(10);
  private IConvFormatOptions options;
  protected boolean useCompactingArrays;
  protected boolean usingPackagedResponse;

  public ApiEndpointJSonSerdes(boolean packaged, IConvFormatOptions opt) {
    options = opt;
    usingPackagedResponse = packaged;
    useCompactingArrays = options.hasMode(IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);
    infra = new JackyInfra();
  }


  @Override
  public <T> void createPartialSerdes(Class<T> type, boolean array) {
    JackyGraphSerdes<T> serdes = new JackyGraphSerdes<T>(type, options);
    partialSerdes.put(type.hashCode(), serdes);
  }


  @Override
  public IApiEndpointSerdes.Deserialized startPayload(int numFlds, String content) {
    // no content at all.
    if (content.length() == 0) {
      return new IApiEndpointSerdes.Deserialized(numFlds == 1, true, null);
    }

    JackyParsed parser = new JackyParsed();
    VParent rootObject = parser.parse(infra.createParser(content));
    return new IApiEndpointSerdes.Deserialized(numFlds == 1, false, rootObject);

  }
  @Override
  public void checkKnownFieldNames(IApiEndpointSerdes.Deserialized deser, String... flds) {
    if (!(deser.isSinglePayload()) && !(deser.hasNoContent())) {
      Object root = deser.getParsedRoot();
      if (!(root instanceof VObject)) {
        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "The provided payload is not an object containing expected fields (but " + root.getClass().getSimpleName() + ").");
      }

      VObject rootObject = ((VObject) root);
      for (VElement elem : rootObject.fields) {
        if (!(ApiOperationBase.contains(flds, elem.name))) {
          throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "The provided payload field name '" + elem.name + "' is not known to this operation.");
        }
      }
    }
  }

  private Object parseField(IApiEndpointSerdes.Hint hint, Class type, VField fld) {
    if (type == int.class || type == Integer.class) {
      return BaseSerdes.parseInt(fld.value);

    } else if (type == String.class) {
      return fld.value;

    } else if (type == BigDecimal.class) {
      return BaseSerdes.parseBigDecimal(options, fld.value);

    } else if (type == LocalDate.class) {
      return BaseSerdes.parseLocalDate(options, fld.value);

    } else if (type == DateTime.class) {
      return BaseSerdes.parseDateTime(options, fld.value);

    } else if (hint == IApiEndpointSerdes.Hint.STATUS) {
      return BaseSerdes.parseStatus(type, fld.value);

    }
    throw new RuntimeException("This can not happen. Unknown type " + type + " to deserialize as primitive.");
  }

  @Override
  public <T> T deserToVariable(IApiEndpointSerdes.Hint hint, IApiEndpointSerdes.Deserialized deser, Class type, boolean array, String fldName, boolean throwEx, T defaultObj) {

    String at = (deser.isSinglePayload() ? "root" : "'" + fldName + "'");



    if (deser.hasNoContent()) {
      if (!(throwEx)) {
        return defaultObj;
      }

      throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " but no payload provided.");
    }

    // we have content :)
    Object toParse = deser.getParsedRoot();
    if (!(deser.isSinglePayload())) {
      if (!(toParse instanceof VObject)) {
        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " but no json object as root given.");
      }

      VObject root = ((VObject) toParse);
      toParse = null;

      for (VElement jsonFld : root.fields) {
        if (fldName.equals(jsonFld.name)) {
          toParse = jsonFld;
        }
      }

      if (toParse == null) {
        // fld not found :(
        if (throwEx) {
          throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting " + type.getSimpleName() + " at " + at + " but field not provided.");
        } else {
          return defaultObj;
        }
      }
    }


    if (hint == IApiEndpointSerdes.Hint.PRIMITIVE || hint == IApiEndpointSerdes.Hint.STATUS) {
      try {
        if (!(array)) {
          if (!(toParse instanceof VField)) {
            throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " but no field given (hint '" + toParse + "').");
          }

          VField fld = ((VField) toParse);
          return (T) parseField(hint, type, fld);

        } else {
          if (!(toParse instanceof VList)) {
            throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json array for " + type.getSimpleName() + " at " + at + " but no array given (hint '" + toParse + "').");
          }

          VList jsonList = ((VList) toParse);
          List result = new ArrayList();
          for (VObject obj : jsonList.objects) {
            if (obj.fields.size() != 1 || !(obj.fields.get(0) instanceof VField)) {
              throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json array with fields for " + type.getSimpleName() + " at " + at + " but no array with fields given (hint '" + obj + "').");
            }
            VField fld = ((VField) obj.fields.get(0));
            result.add(parseField(hint, type, fld));
          }
          return (T) result;
        }

      } catch (SerdesException ex) {
        // Some add on information
        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " - " + ex.getMessage());
      }

    } else {
      // PARTIAL 
      if (array && !(toParse instanceof VList)) {
        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " but no array given (hint '" + toParse + "').");
      }

      if (!(array) && !(toParse instanceof VObject)) {
        new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + at + " but no object given (hint '" + toParse + "').");

      }

      JackyGraphSerdes partial = partialSerdes.get(type.hashCode());
      Object toCastAndReturn = partial.internalDeser(((VParent) toParse));

      if (array) {
        return ((T) Arrays.asList(((Object[]) toCastAndReturn)));
      }
      return (T) toCastAndReturn;
    }
  }
  @Override
  public IApiEndpointSerdes.ISerialzed startResponse(int numFlds) throws IOException {
    boolean singlePayLoad = numFlds == 1;
    StringWriter sw = new StringWriter();
    JsonGenerator gen = infra.createGenerator(sw, options.hasMode(IConvFormatOptions.Mode.PRETTY));

    if (usingPackagedResponse) {
      singlePayLoad = false;
      gen.writeStartObject();
      gen.writeFieldName("data");
      gen.writeStartObject();

    } else if (!(singlePayLoad)) {
      gen.writeStartObject();
    }
    return new JSonSerialized(gen, sw, singlePayLoad);
  }

  public CField.OFXType resolveType(IApiEndpointSerdes.Hint hnt, Class type) {
    if (type == int.class || type == Integer.class) {
      return CField.OFXType.OFX_INT;

    } else if (type == String.class) {
      return CField.OFXType.OFX_STRING;

    } else if (type == BigDecimal.class) {
      return CField.OFXType.OFX_BIGDECIMAL;

    } else if (type == LocalDate.class) {
      return CField.OFXType.OFX_LOCALDATE;

    } else if (type == DateTime.class) {
      return CField.OFXType.OFX_DATETIME;

    } else if (type == byte[].class) {
      throw new RuntimeException("byte[] not supported yet.");

    } else if (hnt == IApiEndpointSerdes.Hint.STATUS) {
      return CField.OFXType.OFX_STATUS;
    }
    throw new RuntimeException("This can not happen. Unknown type " + type);
  }

  @Override
  public void serVar(IApiEndpointSerdes.Hint hint, IApiEndpointSerdes.ISerialzed serToCast, Class ct, boolean array, String fldName, Object value) throws IOException {

    JSonSerialized ser = ((JSonSerialized) serToCast);

    if (hint == IApiEndpointSerdes.Hint.PRIMITIVE || hint == IApiEndpointSerdes.Hint.STATUS) {
      CField.OFXType type = resolveType(hint, ct);

      if (array && value != null) {
        List listOfPrim = ((List) value);
        if (usingPackagedResponse && !(ser.isSinglePayload())) {
          ser.gen().writeFieldName(fldName);
        }
        ser.gen().writeStartArray();
        for (Object obj : listOfPrim) {
          JackyFieldSerdes.serField(ser.gen(), options, type, "", obj, true);
        }
        ser.gen().writeEndArray();

      } else {
        // list of null value results in null, serField can handle
        JackyFieldSerdes.serField(ser.gen(), options, type, fldName, value, ser.isSinglePayload());
      }

    } else {
      JackyGraphSerdes partial = partialSerdes.get(ct.hashCode());
      if (array) {
        List list = ((List) value);
        value = list.toArray();
      }

      partial.internalSer(ser.gen(), fldName, value, ser.isSinglePayload());

    }

  }

  @Override
  public void writeResponse(HttpServletResponse __response, IApiEndpointSerdes.ISerialzed ser, List<IOFXProblem> warnings) throws IOException {
    JSonSerialized jSonSerialized = ((JSonSerialized) ser);
    JsonGenerator gen = jSonSerialized.gen();

    if (usingPackagedResponse) {
      gen.writeEndObject();

      gen.writeNumberField("status", HttpServletResponse.SC_OK);
      gen.writeStringField("error", "NONE");
      gen.writeStringField("desc", "success, processing completed");

      JSonApiErrorReporter.writeProblems(gen, warnings);
      gen.writeEndObject();

    } else if (!(jSonSerialized.isSinglePayload())) {
      jSonSerialized.gen().writeEndObject();
    }

    // close is needed by gen
    jSonSerialized.gen().close();

    __response.setStatus(HttpServletResponse.SC_OK);
    __response.setContentType("application/json");
    __response.getWriter().write(jSonSerialized.asString());
  }

  @Override
  public void serPrimitive(HttpServletResponse __response, Object value, List<IOFXProblem> warnings) throws IOException {
    __response.setStatus(HttpServletResponse.SC_OK);
    __response.setContentType("text/plain");
    __response.getWriter().print(value);
  }



}
