package org.modellwerkstatt.dataux.runtime.httpapi;

/*Generated by MPS */

import javax.servlet.http.HttpServlet;
import org.modellwerkstatt.dataux.runtime.common.IRemoteIpNginx;
import org.springframework.context.support.AbstractApplicationContext;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import javax.servlet.ServletException;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;

public class ApiLoader extends HttpServlet implements IRemoteIpNginx {
  public static final String INTERNAL_VERSION = "moware 11 api (winter 24)";

  private AbstractApplicationContext springAppContext;
  private IOFXApplicationFactory appFactory;
  private String apiDescFqName;
  private String nameVersion = "-";
  private IApiGen iApiGen;
  private AppJmxRegistration jmxRegistration;
  private String deployedAsVersion = "0";
  private String guessedServerName;
  private IOFXUserEnvironment apiWideUserEnv = null;
  private IApiErrorReporter globalErrorReporter;




  @Override
  public void init() throws ServletException {
    super.init();
    Dux.init("/Users/danielstieger/ApiHardlog.log");

    // okay, wire up everything
    String xmlConfigFile = getInitParameter("xmlConfigFile");
    springAppContext = new ClassPathXmlApplicationContext(xmlConfigFile);
    appFactory = springAppContext.getBean(IOFXApplicationFactory.class);

    String servletPath = this.getServletContext().getContextPath();

    // according to moware spec, server.instancename is the name of the srv.
    guessedServerName = System.getProperty("server.instancename");

    // main app behavior class will be given via servlet confg
    apiDescFqName = getInitParameter("applicationFqName");

    String realPath = this.getServletContext().getRealPath("/");
    int startOfVersion = realPath.indexOf("##");
    if (startOfVersion > 0 && realPath.length() > startOfVersion + 2) {
      deployedAsVersion = realPath.substring(startOfVersion + 2);
      deployedAsVersion = deployedAsVersion.substring(0, deployedAsVersion.length() - 1);
    }

    jmxRegistration = new AppJmxRegistration(apiDescFqName, deployedAsVersion, servletPath, servletPath);

    try {
      ClassLoader classLoader = this.getClass().getClassLoader();
      Class appBehaviorClass = classLoader.loadClass(apiDescFqName);

      iApiGen = ((IApiGen) springAppContext.getAutowireCapableBeanFactory().createBean(appBehaviorClass));

      nameVersion = iApiGen.getApiShortName() + "_" + iApiGen.getApiVersion();

      springAppContext.getBean(IM3DatabaseDescription.class).setSessionInfo(nameVersion + " " + iApiGen.getApiImplVersion() + " " + guessedServerName);


    } catch (ClassNotFoundException e) {
      throw new RuntimeException(e);
    }

    try {
      apiWideUserEnv = springAppContext.getBean(IOFXUserEnvironment.class);
    } catch (NoSuchBeanDefinitionException ex) {
      // bean not found
      apiWideUserEnv = null;
    }

    globalErrorReporter = iApiGen.initApiDescription();

    jmxRegistration.registerAppTelemetrics(appFactory, apiDescFqName, nameVersion, iApiGen.getApiImplVersion(), MoWareTranslations.Key.MOWARE_VERSION.getLangDefault() + " - " + INTERNAL_VERSION, guessedServerName);

    // okay, guess that s it..
  }


  public CoreReporterInfo appCoreReporterInfo(int uId, String uName, String devRemoteAdr, IOFXCoreReporter.LogPriority prio, String cmdOrOp, String desc) {
    CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, apiDescFqName, iApiGen.getApiImplVersion(), IOFXCoreReporter.RT, cmdOrOp, "", prio, uId, uName, "", "", devRemoteAdr, MoVersion.MOWARE_PLUGIN_VERSION, IOFXCoreReporter.MoWarePlatform.MOWARE_API, guessedServerName, desc);
    return info;
  }


  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    long requestMillis = System.currentTimeMillis();

    String urlToMatch = req.getServletPath();
    if (urlToMatch.endsWith("/")) {
      urlToMatch = urlToMatch.substring(0, urlToMatch.length() - 1);
    }

    ApiOperationBase op = iApiGen.getOperationOrNull(urlToMatch, req.getMethod());

    if (op != null) {

      IOFXSession session = null;

      String remoteAddr = getRemoteAddr(req);
      IOFXUserEnvironment userEnv;
      if (apiWideUserEnv != null) {
        userEnv = apiWideUserEnv;

      } else {
        userEnv = new UserEnvironmentInformation();
        userEnv.adjustDeviceId(remoteAddr);
      }

      try {
        ApiUserService userServivce = new ApiUserService(appFactory, apiDescFqName, iApiGen.getApiImplVersion(), userEnv, remoteAddr, guessedServerName);
        session = appFactory.createNewSession(userEnv, userServivce);

        try {
          Dux.hl("executing operation " + op);
          op.executeOp(req, resp, session);

          long diff = System.currentTimeMillis() - requestMillis;
          CoreReporterInfo info = appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "served request successfully");
          info.addParameter(CoreReporterInfo.DIFF, diff);
          appFactory.report(info);

        } catch (OFXShutDownSessionException ex) {
          CoreReporterInfo info = appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.ERROR, op.getLocation(), "Guard");
          info.setSource(IOFXCoreReporter.USER_EX);
          info.setException(ex);
          info.addParameter(CoreReporterInfo.PARAM, ex.getProblem().getSimpleUserText());
          appFactory.report(info);

          globalErrorReporter.reportInternalProblem(resp, null);

        } catch (OFXAbortedException aported) {
          // guards lead to OFXShutDownSessionException, basically this should not happen.
          // however, to not report internal details. 

          List<IOFXProblem> problems = session.getAndclearProblemState();
          IOFXProblem guard = OFXConsoleHelper.containsGuard(problems);

          String desc = OFXConsoleHelper.asSimpleString(problems);
          CoreReporterInfo info = appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Operation aborted due to preconditions.\n" + desc);
          appFactory.report(info);

          if (guard == null) {
            globalErrorReporter.reportOfxProblems(resp, problems);

          } else {
            // Report guard info additionally
            throw new RuntimeException("This should not happen. We have a guard in an OFXAportedException (" + guard.getSimpleUserText(), guard.getForwardedEx());
          }
        }


      } catch (ApiException apiEx) {
        appFactory.report(appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Client request resulted in api problem " + apiEx.getErrorName() + " " + apiEx.getMessage()));

        globalErrorReporter.reportApiExFieldNamesProblem(resp, apiEx);

      } catch (SerdesException ex) {
        appFactory.report(appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.INFO, op.getLocation(), "Client request resulted in api/serdes problem " + ex.getMessage()));

        globalErrorReporter.reportSerdesProblem(resp, ex);

      } catch (Exception ex) {

        jmxRegistration.getAppTelemetrics().incException();

        // Same for RuntimeException 
        // if message is not set, then the message will be <cause class fqName>: <cause message>
        CoreReporterInfo info = appCoreReporterInfo(userEnv.getUserId(), userEnv.getUserName(), remoteAddr, IOFXCoreReporter.LogPriority.ERROR, op.getLocation(), "Tec. exception while processing request.");
        info.setException(ex);
        appFactory.report(info);

        globalErrorReporter.reportInternalProblem(resp, ex);

      } finally {

        if (session != null) {
          session.closeSessionAndfreeGC();
        }
      }

      jmxRegistration.getAppTelemetrics().applicationLog(userEnv.getUserName() + " " + remoteAddr, "processed " + op.getLocation() + " in " + (System.currentTimeMillis() - requestMillis));
      jmxRegistration.getAppTelemetrics().servedRequest("api request " + nameVersion, userEnv.getUserName(), "operation " + op.getLocation(), requestMillis);

    } else {

      CoreReporterInfo info = appCoreReporterInfo(-1, "", getRemoteAddr(req), IOFXCoreReporter.LogPriority.INFO, "", "No operation for '" + urlToMatch + "' in this api description.");
      appFactory.report(info);

      globalErrorReporter.notFound(resp);

    }
  }


  @Override
  public void destroy() {

    jmxRegistration.gcClean();

    String msg = OFXConsoleHelper.closeConnectionPoolExplicitly(springAppContext);
    if (msg != null) {
      super.log(msg);
    }
    springAppContext.close();
    springAppContext = null;

    DeprecatedServerDateProvider.shutdownAndGcClean();
    MMStaticAccessHelper.shutdownAndGcClean();
    OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG = null;

    super.destroy();
  }

  @Override
  protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    doGet(req, resp);
  }
  @Override
  protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    doGet(req, resp);
  }
  @Override
  protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    doGet(req, resp);
  }

}
