package org.modellwerkstatt.dataux.runtime.sdicore;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.ApplicationBasis;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.core.IEventProcessor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import java.util.ArrayList;
import java.util.LinkedList;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import java.util.Collections;

public abstract class ApplicationSDI extends ApplicationBasis {
  protected List<IOFXCmdModule.CmdUrlDefaults> allUrlDefaults;
  protected String availableCmdUrlsDescription;

  private List<TileAction> tileActions;
  private List<LandingPageUrlItem> tileActionsUrlItems;

  private List<CmdAction> menuActions;
  private LandingPageUrlItem rootOfMainMenu;


  private WindowControllerSDI crtlPickingUp;
  private IToolkit_CommandContainerUi uiToPickup;
  private String urlToPickupFrom;

  private boolean potentialStartupCmdExecuted;

  private List<WindowControllerSDI> allWindows;
  private String appLockedByModalName;

  private ISelectionController dummySelCrtl = new ISelectionController() {
    public ISelectionController registerSelControlled(Class interestedInSelectionType, ISelectionController.Binding binding, IGenSelControlled xuElemToRegister) {
      return null;
    }
    public IOFXSelection getSelectionAbsolute(Class cls, boolean includingDerived) {
      return null;
    }
    public void pushSelectionAbsolute(IOFXSelection sel) {
      throw new RuntimeException("DummySelCrtl - not implemented.");
    }
    public void forceNotEditable() {
      throw new RuntimeException("DummySelCrtl - not implemented.");
    }
    public IOFXSelection getLocalSelection() {
      return null;
    }
    public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
      throw new RuntimeException("DummySelCrtl - not implemented.");
    }
  };

  private IEventProcessor appLandingPageProcessor;

  public ApplicationSDI(IToolkit_UiFactory factory, IGenAppUiModule appBehavior, AppJmxRegistration registration, IOFXCoreReporter.MoWarePlatform pltfrm) {
    super(factory, appBehavior, registration, pltfrm);
    appLockedByModalName = null;

  }

  private void initMenuAccordingUrlDefaults(Menu menu, LandingPageUrlItem item) {

    for (AbstractAction action : menu.getAllItems()) {
      if (action instanceof CmdAction) {
        final CmdAction cmdAction = ((CmdAction) action);

        IOFXCmdModule.CmdUrlDefaults urlDefault = ListSequence.fromList(allUrlDefaults).findFirst((urlCmd) -> urlCmd.cmdFqName.equals(cmdAction.commandFqName));

        if (urlDefault != null) {
          ListSequence.fromList(menuActions).addElement(cmdAction);

          cmdAction.configure(uiFactory, appLandingPageProcessor, dummySelCrtl, userEnvironment.getLangIndex());
          item.addToSubMenu(new LandingPageUrlItem(cmdAction.hashCode(), urlDefault.url, cmdAction.labelText, cmdAction.getToolTip(), cmdAction.image, null, cmdAction.hotKey, false));
        }

      } else if (action instanceof Menu) {
        Menu subMenu = ((Menu) action);
        if (subMenu.labelText != null) {
          subMenu.configureLabel(uiFactory.getTransProvider().translateSingle(userEnvironment.getLangIndex(), subMenu.labelText));
        }
        LandingPageUrlItem newItem = new LandingPageUrlItem(subMenu.labelText);
        initMenuAccordingUrlDefaults(subMenu, newItem);
        if (newItem.hasItemsInSubMenu()) {
          item.addToSubMenu(newItem);
        }

      } else {
        // Separator
        if (item.hasItemsInSubMenu()) {
          item.addToSubMenu(new LandingPageUrlItem(0, null, null, null, null, null, null, false));
        }
      }
    }

  }

  protected void initializeApplication(List<IOFXCmdModule.CmdUrlDefaults> defaults, String systemName, IOFXUserEnvironment userEnv, String userConnectionInfo, String startupInfo) {

    potentialStartupCmdExecuted = false;
    allUrlDefaults = defaults;

    availableCmdUrlsDescription = String.join(" , ", ListSequence.fromList(allUrlDefaults).select((it) -> it.urlAndParamDescription));

    // Okay, changing to statefull mode
    userEnvironment = userEnv;
    // set some status information
    userEnvironment.setAppStartupLocalMillis(System.currentTimeMillis());

    this.userLoggedIn(systemName, userEnv, userConnectionInfo, startupInfo, applicationBehaviour.getClass().getName(), applicationBehaviour.getShortAppName(), applicationBehaviour.getApplicationVersion());


    // used to init batchjob environmentents
    applicationBehaviour.userLoggedIn(userEnv, this);

    IOFXSession lpdSession = uiFactory.createNewSession(userEnvironment, this);
    appLandingPageProcessor = new LandingPageDummyProcessor(lpdSession);

    List<TileAction> allTiles = applicationBehaviour.createAppTileActions(uiFactory, userEnvironment);
    ListSequence.fromList(allTiles).visitAll((it) -> it.setupTileAction());
    tileActions = ListSequence.fromList(new ArrayList<TileAction>());
    tileActionsUrlItems = ListSequence.fromList(new ArrayList<LandingPageUrlItem>());

    ListSequence.fromList(allTiles).visitAll((final TileAction it) -> {
      IOFXCmdModule.CmdUrlDefaults urlDefault = ListSequence.fromList(allUrlDefaults).findFirst((urlCmd) -> urlCmd.cmdFqName.equals(it.getAction().commandFqName));

      if (urlDefault != null) {
        ListSequence.fromList(tileActions).addElement(it);
        CmdAction action = it.getAction();
        action.configure(uiFactory, appLandingPageProcessor, dummySelCrtl, userEnvironment.getLangIndex());
        ListSequence.fromList(tileActionsUrlItems).addElement(new LandingPageUrlItem(it.hashCode(), urlDefault.url, action.labelText, action.getToolTip(), action.image, it.getColor(), action.hotKey, false));
      }

    });

    menuActions = ListSequence.fromList(new ArrayList<CmdAction>());
    rootOfMainMenu = new LandingPageUrlItem("Root");
    Menu menu = applicationBehaviour.createStartMenu(userEnvironment);
    initMenuAccordingUrlDefaults(menu, rootOfMainMenu);

    menu = applicationBehaviour.createExtrasMenu(userEnvironment);
    initMenuAccordingUrlDefaults(menu, rootOfMainMenu);

    menu = applicationBehaviour.createHelpMenu(userEnvironment);
    initMenuAccordingUrlDefaults(menu, rootOfMainMenu);

    this.logAppTrace("", "", IOFXCoreReporter.LOGIN, "application startup", getuser_connectionInfoAddOn(), null);
    allWindows = ListSequence.fromList(new LinkedList<WindowControllerSDI>());
  }

  public boolean hasToRunStartupCmdAsModalFirst(OFXUrlParams checkStartupCmd, IToolkit_Window win) {

    if (!(potentialStartupCmdExecuted)) {
      BasisCmdStart cmdStart = applicationBehaviour.createStartupCmd(appLandingPageProcessor.getSession());
      if (cmdStart == null) {
        potentialStartupCmdExecuted = true;

      } else {
        //  do we have to exec cmd or not?
        IOFXCmdModule.CmdUrlDefaults def = null;
        if (checkStartupCmd != null && checkStartupCmd.hasCmdName()) {
          def = getUrlDefaultFor(uiFactory.getAllCmdUrlDefaults(), checkStartupCmd);
        }

        if (def != null && cmdStart.getCommandName().equals(def.cmdFqName)) {
          // same command - do not use startup cmd
          // do not use startup cmd.
          potentialStartupCmdExecuted = true;

        } else {
          if (!(cmdStart.hasParamsSet())) {
            // precondition - cmd enabled 
            IOFXCmdModule mod = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cmdStart.getCommandName()));
            cmdStart = cmdStart.cloneWithParams(mod.getCommandDefaultParams(cmdStart.getCommandName(), null, false));
          }

          potentialStartupCmdExecuted = true;
          intenal_startCmd(false, cmdStart, win, true);
          setCurrentAsAppStartupContainer();
          return true;
        }
      }
    }

    return false;
  }

  public List<LandingPageUrlItem> updateLandingPageTileUrlItems() {
    for (int i = 0; i < ListSequence.fromList(tileActions).count(); i++) {
      TileAction tile = ListSequence.fromList(tileActions).getElement(i);
      LandingPageUrlItem item = ListSequence.fromList(tileActionsUrlItems).getElement(i);
      CmdAction action = tile.getAction();

      tile.calcAndSetCurrentTileLabel(appLandingPageProcessor.getSession());
      item.enabled = tile.getAction().reevalEnabled();
      item.label = action.labelText;
    }

    return tileActionsUrlItems;
  }

  private int checkEnabledForMenu(int index, LandingPageUrlItem menu) {
    if (!(menu.isSubMenu())) {
      throw new RuntimeException("This can not happen..");
    }

    for (LandingPageUrlItem item : menu.getSubItems()) {

      if (item.isSeperator()) {

      } else if (item.isSubMenu()) {
        index = checkEnabledForMenu(index, item);

      } else {
        CmdAction action = ListSequence.fromList(menuActions).getElement(index);
        item.enabled = action.reevalEnabled();

        index++;
      }
    }

    return index;
  }
  public List<LandingPageUrlItem> updateLandingPageMenuUrlItems() {
    checkEnabledForMenu(0, rootOfMainMenu);
    return rootOfMainMenu.getSubItems();
  }


  @Override
  public void reevalEnabledInMenusAndTiles() {
    // noop, only evaluate on request (get enabled landing page links)
  }

  @Override
  public IOFXSession getMainWindowEvalSession() {
    return null;
  }
  public boolean noGraphsToCommit() {
    for (int i = 0; i < ListSequence.fromList(allWindows).count(); i++) {
      if (ListSequence.fromList(allWindows).getElement(i).hasRwSessionToCommit()) {
        return false;
      }
    }
    return true;
  }

  @Override
  public boolean checkForAppParDeploymentForward() {
    boolean forwardPlease = false;

    if (getAppTelemetrics().isParDeploymentForwardImmediate() || (getAppTelemetrics().isParDeploymentForwardGracefully() && noGraphsToCommit())) {
      forwardPlease = true;

      if (!(userAlreadyNotifiedParDeplyForward)) {
        userAlreadyNotifiedParDeplyForward = true;

        for (int i = 0; i < ListSequence.fromList(allWindows).count(); i++) {
          WindowControllerSDI win = ListSequence.fromList(allWindows).getElement(i);

          win.showSimpleInfoDialog(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.APPLICATION_LOCKED), new IApplication.DlgRunnable() {
            @Override
            public void run(boolean confirmed) {
              // checks internally if already shtudown of instance.
              internal_shutdownSDIAppImmediatelly();
              parDeployForward();
            }
          });

        }

      }
    }
    return forwardPlease;
  }

  public abstract void parDeployForward();

  @Override
  public boolean isSameInstanceRunningThenFocus(String fqName, Object[] params) {
    for (int i = 0; i < allRunningContainersToTerminate.size(); i++) {
      if (allRunningContainersToTerminate.get(i).isSameCommandInstance(fqName, params)) {
        return true;
      }
    }
    return false;
  }
  @Override
  public IToolkit_MainWindow getMainWindowImpl() {
    // There is no main window in sdi apps. No background processing, no ref in ui factory for createTab/Probmpt().
    return null;
  }
  @Override
  public String fullApplicationCrtlState() {
    return "This is the SDI Application Crtl\nCurrently with " + ListSequence.fromList(allWindows).count() + ". In shutdown mode is " + shutdownMode;
  }

  public void startWithNewCrtl(IToolkit_Window parentWin, BasisCmdStart toStart) {
    toStart.forceToThisWindowCrtl();
    WindowControllerSDI sdi = new WindowControllerSDI(uiFactory, this, parentWin);
    crtlPickingUp = sdi;
    ListSequence.fromList(allWindows).addElement(sdi);

    sdi.receiveAndProcess(toStart);
  }

  public void setUiForPickup(String url, IToolkit_CommandContainerUi ui) {
    urlToPickupFrom = url;
    uiToPickup = ui;
  }

  public boolean hasCrtlAwaitingPickup() {
    return crtlPickingUp != null;
  }

  public boolean wasPickupCmdThenStart(IToolkit_Window newWindow, OFXUrlParams params) {

    if (params.asUrl().equals(urlToPickupFrom)) {

      crtlPickingUp.swapWindows(newWindow);
      crtlPickingUp = null;

      newWindow.addTab(uiToPickup);

      uiToPickup = null;
      urlToPickupFrom = null;
      return true;
    }
    return false;
  }

  public String startLandingPageCmdViaHash(IToolkit_Window win, final int hash) {

    if (appLockedByModalName != null) {
      return String.format(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.APP_IN_MODAL_NO_CMD_START), appLockedByModalName);

    } else {
      CmdAction toStart;
      TileAction tileAction = ListSequence.fromList(tileActions).findFirst((it) -> it.hashCode() == hash);
      if (tileAction != null) {
        toStart = tileAction.getAction();

      } else {
        toStart = ListSequence.fromList(menuActions).findFirst((it) -> it.hashCode() == hash);

      }

      if (toStart == null) {
        throw new RuntimeException("This can not happen.");
      }

      Object[] localParams = toStart.calculateParams(null);
      BasisCmdStart ev = toStart.configCompoundOuterCmdStartOrJustBasisCmdStart(localParams);
      ev.setLabelText(toStart.labelText);
      intenal_startCmd(true, ev, win, false);
      return null;
    }
  }

  public String startCommandViaUrl(boolean withPickup, IToolkit_Window win, OFXUrlParams urlParam) {
    IOFXCmdModule.CmdUrlDefaults infoForCmd = getUrlDefaultFor(allUrlDefaults, urlParam);

    if (appLockedByModalName != null) {
      return String.format(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.APP_IN_MODAL_NO_CMD_START), appLockedByModalName);

    } else if (infoForCmd == null) {
      return String.format(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.CMD_NOT_AVAILABLE), availableCmdUrlsDescription);

    } else {
      BasisCmdStart ev = cmdStartForUrlDefault(infoForCmd, urlParam, appLandingPageProcessor.getSession());
      intenal_startCmd(withPickup, ev, win, false);
      return null;
    }
  }

  private void intenal_startCmd(boolean withPickup, BasisCmdStart ev, IToolkit_Window win, boolean isStartup) {
    ev.forceToThisWindowCrtl();

    WindowControllerSDI sdi = new WindowControllerSDI(uiFactory, this, win);
    if (isStartup) {
      sdi.setModal();
    }

    if (withPickup) {
      crtlPickingUp = sdi;
    }

    ListSequence.fromList(allWindows).addElement(sdi);
    sdi.receiveAndProcess(ev);
  }

  public void closedWindowCrtl(WindowControllerSDI crtl) {
    if (!(ListSequence.fromList(allWindows).contains(crtl))) {
      throw new RuntimeException("This can not happen. The crtl " + crtl + " is not part of our " + ListSequence.fromList(allWindows).count() + " windows.");
    }

    ListSequence.fromList(allWindows).removeElement(crtl);
  }

  public void setModal(final WindowControllerSDI themodalWindow, String name) {
    if (themodalWindow != null && appLockedByModalName != null) {
      throw new RuntimeException("This can not happen.");
    }

    if (themodalWindow == null) {
      applicationModalTabMode = false;
      appLockedByModalName = null;
      ListSequence.fromList(allWindows).visitAll((it) -> it.lockWindow(false));

    } else {
      applicationModalTabMode = true;
      appLockedByModalName = name;
      ListSequence.fromList(allWindows).visitAll((it) -> {
        boolean isModalWin = it == themodalWindow;
        it.lockWindow(!(isModalWin));
      });
    }

  }

  public void external_closeBrowserTab(final IToolkit_Window win) {
    WindowControllerSDI crtl = ListSequence.fromList(allWindows).findFirst((it) -> it.responsibleFor(win));
    if (crtl == null) {
      //  this happens in case closedWindowCrtl is called via esc / ok conclusion
      //  might also be due to beacon vs. heartbeat call 
    } else {
      crtl.externalClose();
    }
  }

  public void internal_shutdownSDIAppImmediatelly() {
    if (!(shutdownMode)) {
      afterStartupCmd = null;
      List<ICommandContainer> allContainers = new ArrayList<ICommandContainer>(allRunningContainersToTerminate);
      Collections.reverse(allContainers);

      for (ICommandContainer c : allContainers) {
        c.internal_immediatelyShutdown();
      }
    }
    shutdownMode = true;
  }

  public String getAppVersionAndDyn() {
    return userEnvironment.getUserName() + " - " + applicationBehaviour.getShortAppName() + " " + applicationBehaviour.getApplicationVersion() + " " + userEnvironment.getDynamicStatusInfo();
  }


  public boolean inShutdownMode() {
    return shutdownMode;
  }
  public String toString() {
    String cmdsOpen = "";
    for (ICommandContainer cc : allRunningContainersToTerminate) {
      cmdsOpen += cc + ", ";

    }
    return getClass().getSimpleName() + "_" + (hashCode() % 1000) + " (" + cmdsOpen + ")";
  }

}
