package org.modellwerkstatt.dataux.runtime.sdicore;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.WindowController;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;

public class WindowControllerSDI extends WindowController {
  private ICommandContainer windowContainer;
  private ICommandContainer promptContainer;
  private boolean externalModalSet;


  public WindowControllerSDI(IToolkit_UiFactory uf, ApplicationSDI theApp, IToolkit_Window win) {
    super(uf, theApp, win);
    externalModalSet = false;
  }

  protected ApplicationSDI getTheApp() {
    return ((ApplicationSDI) app);
  }

  @Override
  public void sameInstanceRunningUserNotification() {
    showSimpleInfoDialog(uiFactory.getSystemLabel(app.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_OPENED_IN_OTHER_TAB), null);
  }

  @Override
  public void showCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {
    content.rootForm();

    ui.show(windowTitle, content);
    if (ui.isTabWindow()) {
      if (windowContainer != null) {
        throw new RuntimeException("This can not happen. WindowContainer is " + windowContainer + " and the tab to show is " + cc);
      }
      windowContainer = cc;
      window.addTab(ui);

      if (ui.isModalTabWindow() || externalModalSet) {
        getTheApp().setModal(this, windowTitle);
      }

    } else {
      if (promptContainer != null) {
        throw new RuntimeException("This can not happen. PromptContainer is " + promptContainer + " and the prompt to show is " + cc);
      }
      promptContainer = cc;

    }
  }

  @Override
  public void closeCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, ICommandContainer parent) {

    if (ui.isTabWindow()) {
      window.ensureTabClosed(ui);
      if (ui.isModalTabWindow() || externalModalSet) {
        getTheApp().setModal(null, null);
      }

      // do not set windowContainer to null - this window ist not reusable
      getTheApp().closedWindowCrtl(this);

    } else {
      promptContainer = null;

    }

    ui.close();
  }

  @Override
  public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {
    window.focusTab(ui);
  }

  public void swapWindows(IToolkit_Window win) {
    window = win;
  }

  public boolean responsibleFor(IToolkit_Window win) {
    return this.window == win;
  }

  public void lockWindow(boolean lock) {
    if (lock) {
      if (promptContainer != null) {
        promptContainer.internal_immediatelyShutdown();
      }
      window.setCurrentTabModal(true);
    } else {
      window.setCurrentTabModal(false);
    }
  }

  public boolean hasRwSessionToCommit() {
    // no cmd open yet
    if (windowContainer == null) {
      return false;
    }
    return windowContainer.hasRwSessionToCommit();
  }
  public void externalClose() {
    if (promptContainer != null) {
      promptContainer.internal_immediatelyShutdown();
    }
    windowContainer.internal_immediatelyShutdown();
  }
  public void setModal() {
    externalModalSet = true;
  }
}
