package org.modellwerkstatt.dataux.runtime.services;

/*Generated by MPS */

import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import java.util.Map;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.List;
import mjson.Json;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.dataux.runtime.core.EventCommandContainer;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;

public class ImplDynLockQuery implements ConsumerHandler, DynLockStateHolder {
  private IMoEventBusService bus;
  private Map<String, String> locksAndUsers;
  private String problem;
  private long ebLockRequestedTimeStamp;
  private String userName;
  private String deviceName;
  private String sessId;

  private long appStartupLocalMillis;
  private IOFXUserServices userServices;



  public ImplDynLockQuery(IToolkit_UiFactory uiFactory, IOFXSession session) {
    bus = uiFactory.getEventBus();
    locksAndUsers = MapSequence.fromMap(new HashMap<String, String>());
    problem = null;

    userName = session.getUserEnvironment().getUserName();
    deviceName = session.getUserEnvironment().getDeviceName();
    ebLockRequestedTimeStamp = 0;
    appStartupLocalMillis = session.getUserEnvironment().getAppStartupLocalMillis();
    userServices = session.getUserServices();
    sessId = session.getSessionLoggingId();
  }

  public void requestLocks(List<String> requestedLocks) {
    if (ebLockRequestedTimeStamp != 0) {
      throw new RuntimeException("Do not call requestLocks twice!");
    }
    bus.register(this, "locking");
    ll("requesteLocks", "bus receiver registered.");

    for (String lockName : requestedLocks) {
      String lowerLockName = lockName.toLowerCase();
      String lockingInstanceName = lowerLockName + "_" + this.hashCode();
      String lockingUserName = ("".equals(deviceName) ? userName : userName + " " + deviceName);

      // last msg timestamp
      ebLockRequestedTimeStamp = System.currentTimeMillis();

      MapSequence.fromMap(locksAndUsers).put(lowerLockName, "");
      // could also be published as single message...
      bus.publish("locking", Json.object().set("type", "requestLock").set("lockName", lowerLockName).set("userName", lockingUserName).set("userInstanceName", lockingInstanceName).set("requestTimestamp", ebLockRequestedTimeStamp).set("containerHash", this.hashCode()).set("appStartup", appStartupLocalMillis));
      ll("requestLocks", "sent req. for " + lowerLockName);
    }


  }


  public void ensureLocksReceived(long minMillisWaitTime) {
    try {
      long diff = System.currentTimeMillis() - ebLockRequestedTimeStamp;
      ll("ensureLocksRecieved", "diff to wait is " + diff + "ms");
      if (diff < minMillisWaitTime) {
        long timeToWaitAdditionally = minMillisWaitTime - diff;
        Thread.sleep(timeToWaitAdditionally);
        ll("ensureLocksReceived", "ok, we waited additionally " + timeToWaitAdditionally + "ms");
      }
    } catch (InterruptedException ex) {
      throw new RuntimeException(ex);
    }

  }

  public String userHoldingLock(String lockName) {
    String relevantLock = lockName.toLowerCase();

    if (!(MapSequence.fromMap(locksAndUsers).containsKey(relevantLock))) {
      return null;
    }
    String result = MapSequence.fromMap(locksAndUsers).get(relevantLock);
    if ("".equals(result)) {
      return null;
    }
    return result;
  }

  public boolean anyLockNotGranted() {
    return firstUserHoldingALock() != null;
  }

  public String firstUserHoldingALock() {
    if (problem != null) {
      throw new RuntimeException(problem);
    }

    // not syncronized. not needed anyway.
    for (String key : MapSequence.fromMap(locksAndUsers).keySet()) {
      if ("".equals(MapSequence.fromMap(locksAndUsers).get(key))) {
        // ignore...
      } else {
        // first lock not granted..
        ll("firstUserHoldingALock", "oh, we have a lock for " + MapSequence.fromMap(locksAndUsers).get(key));
        return MapSequence.fromMap(locksAndUsers).get(key);
      }
    }

    // got all locks
    return null;
  }

  public void handle(Message busMsg) {

    if (busMsg.isErrorMsg()) {
      problem = "EB BUS ERROR (from EB, but EB still running) " + busMsg.getErrMessage() + " / " + busMsg.getErrFailureCode() + " / " + busMsg.getErrFailureType();
      return;
    }

    Json body = busMsg.getBodyAsMJson();
    if (!(body.has("type"))) {
      problem = "EB BUS ERROR (still running, received an unknown message with no type)" + body.toString();
      return;
    }
    String type = body.at("type").asString();

    if ("locked".equals(type)) {
      // should we be subscribed?
      String lockName = (body.has("lockName") ? body.at("lockName").asString().toLowerCase() : "");
      String byUserName = (body.has("userName") ? body.at("userName").asString() : "");
      String userInstanceName = (body.has("userInstanceName") ? body.at("userInstanceName").asString() : "");
      long requestContainerHash = (body.has("containerHash") ? body.at("containerHash").asLong() : 0);
      long lockTimestamp = (body.has("lockTimestamp") ? body.at("lockTimestamp").asLong() : 0);
      long appStartup = (body.has("appStartup") ? body.at("appStartup").asLong() : 0);

      if (userServices != null) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String paramSt = "lock hold since " + EventCommandContainer.LOCK_DBG_TIME_FRMT.print(lockTimestamp) + " (appstart " + EventCommandContainer.LOCK_DBG_TIME_FRMT.print(new DateTime(appStartup)) + ")";
        parameterMap.put(CoreReporterInfo.PARAM, paramSt);

        userServices.logOnCoreReporter(this.getClass().getName(), sessId, IOFXCoreReporter.LOCKING, IOFXCoreReporter.LogPriority.TRACE, "received lock not granted for " + lockName + " (held by " + byUserName + ")", parameterMap);
      }

      for (String tmp : lockName.split(",")) {
        String requestedLock = tmp.trim();

        if (!("".equals(requestedLock)) && MapSequence.fromMap(locksAndUsers).containsKey(requestedLock)) {
          if (requestContainerHash == this.hashCode() && !(userInstanceName.equals(requestedLock + "_" + this.hashCode()))) {
            MapSequence.fromMap(locksAndUsers).put(requestedLock, byUserName);
          }

        }
      }
    }
  }

  public void ll(String method, String msg) {
  }

  public void close() {
    bus.unregister(this, "locking");
    ll("close", "bus receiver unregistered.");
    bus = null;
    userServices = null;
  }
}
