package org.modellwerkstatt.dataux.runtime.telemetrics;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import java.util.Properties;

public class MessaggingLogger {
  private static final DateTimeFormatter frmt = DateTimeFormat.forPattern("EEE dd MMM kk:mm:ss");

  private String topic;
  private boolean disabled;

  public MessaggingLogger() {
  }

  public void init(String server) {

    Properties props = new Properties();
    props.put("bootstrap.servers", server);
    props.put("acks", "0");
    props.put("retries", 0);
    props.put("batch.size", 16384);
    props.put("linger.ms", 100);
    props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
    props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");

    // nondefault settings
    props.put("request.timeout.ms", 1000);
    props.put("max.block.ms", 1100);
    // First time we send data to topic
    props.put("metadata.fetch.timeout.ms", 1100);

    topic = "mylogs";
    disabled = false;
  }

  public void disabled() {
    disabled = true;
  }
  public void send(String key, long lastEventMillis, String value) {

    if (disabled) {
      return;
    }
    try {
      long t = System.currentTimeMillis();
      String dateAsString = frmt.print(lastEventMillis);

      if (System.currentTimeMillis() - t > 1000) {
        disabled = true;
        close();
        System.err.println("Kafka event logging disabled since custom timeout was hit.");
      }

    } catch (IllegalStateException ex) {
      String st = ex.getMessage();
      // okay, on servlet shutdown without any
      if (st != null && st.contains("Cannot send after the producer is closed")) {
        disabled = true;
      } else {
        throw ex;
      }

    }
  }
  public void close() {
    // init not called?
  }

  public static void main(String[] args) {
    System.err.println(" DateTime now " + frmt.print(System.currentTimeMillis()));
  }



}
