package org.modellwerkstatt.dataux.runtime.utils;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

/**
 * * Contains utility methods for working with JSON or JSON-like data structures.
 */
public class MoJSON {
  public MoJSON() {
  }
  /**
   * * Returns the value at a given path.
   * *
   * * @param root
   * * The root object.
   * *
   * * @param path
   * * The path to the value as a JavaScript path.
   * *
   * * @return
   * * The value at the given path.
   * *
   * * @see #get(Object, Sequence)
   */
  public static <T> T get(Object root, String path) {
    return (T) MoJSON.get(root, MoJSON.parse(path));
  }
  /**
   * * Returns the value at a given path.
   * *
   * * @param root
   * * The root object.
   * *
   * * @param keys
   * * The path to the value as a sequence of keys.
   * *
   * * @return
   * * The value at the given path.
   */
  public static <T> T get(Object root, List<String> keys) {
    if (keys == null) {
      throw new IllegalArgumentException("keys is null.");
    }
    Object value = root;
    int n = ListSequence.fromList(keys).count();
    for (int i = 0; i < n; i++) {
      if (value == null) {
        break;
      }
      String key = ListSequence.fromList(keys).getElement(i);
      MoBeanAdapter adapter = new MoBeanAdapter(value);

      if (adapter.containsKey(key)) {
        value = adapter.get(key);
      } else {
        throw new IllegalArgumentException("Property \"" + key + "\" not found.");
      }
    }
    return (T) value;
  }
  /**
   * * Sets the value at the given path.
   * *
   * * @param root
   * * @param path
   * * @param value
   * *
   * * @return
   * * The value previously associated with the path.
   */
  public static <T> T put(Object root, String path, T value) {
    if (root == null) {
      throw new IllegalArgumentException("root is null.");
    }
    List<String> keys = MoJSON.parse(path);
    if (ListSequence.fromList(keys).count() == 0) {
      throw new IllegalArgumentException("Path is empty.");
    }

    String key = ListSequence.fromList(keys).last();
    ListSequence.fromList(keys).removeLastElement();

    Object parent = MoJSON.get(root, keys);
    if (parent == null) {
      throw new IllegalArgumentException("Invalid path: " + path);
    }

    MoBeanAdapter adapter = new MoBeanAdapter(parent);
    Object previousValue;
    if (adapter.containsKey(key)) {
      previousValue = adapter.put(key, value);
    } else {
      throw new IllegalArgumentException("Property \"" + key + "\" not found.");
    }

    return (T) previousValue;
  }
  /**
   * * Parses a JSON path into a sequence of string keys.
   * *
   * * @param path
   */
  public static List<String> parse(String path) {
    if (path == null) {
      throw new IllegalArgumentException("path is null.");
    }
    List<String> keys = ListSequence.fromList(new ArrayList<String>());
    int i = 0;
    int n = path.length();
    while (i < n) {
      char c = path.charAt(i++);
      StringBuilder identifierBuilder = new StringBuilder();
      boolean bracketed = (c == '[');
      if (bracketed && i < n) {
        c = path.charAt(i++);
        char quote = (char) 0;
        boolean quoted = (c == '\"' || c == '\'');
        if (quoted && i < n) {
          quote = c;
          c = path.charAt(i++);
        }
        while (i <= n && bracketed) {
          bracketed = quoted || (c != ']');
          if (bracketed) {
            if (c == quote) {
              if (i < n) {
                c = path.charAt(i++);
                quoted = (c == quote);
              }
            }
            if (quoted || c != ']') {
              if (Character.isISOControl(c)) {
                throw new IllegalArgumentException("Illegal identifier character.");
              }
              identifierBuilder.append(c);
              if (i < n) {
                c = path.charAt(i++);
              }
            }
          }
        }
        if (quoted) {
          throw new IllegalArgumentException("Unterminated quoted identifier.");
        }
        if (bracketed) {
          throw new IllegalArgumentException("Unterminated bracketed identifier.");
        }
        if (i < n) {
          c = path.charAt(i);
          if (c == '.') {
            i++;
          }
        }
      } else {
        while (i <= n && c != '.' && c != '[') {
          if (!(Character.isJavaIdentifierPart(c))) {
            throw new IllegalArgumentException("Illegal identifier character.");
          }
          identifierBuilder.append(c);
          if (i < n) {
            c = path.charAt(i);
          }
          i++;
        }
        if (c == '[') {
          i--;
        }
      }
      if (c == '.' && i == n) {
        throw new IllegalArgumentException("Path cannot end with a '.' character.");
      }
      if (identifierBuilder.length() == 0) {
        throw new IllegalArgumentException("Missing identifier.");
      }
      ListSequence.fromList(keys).addElement(identifierBuilder.toString());
    }
    return keys;
  }
}
