package org.modellwerkstatt.dataux.tests.apidesc;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.httpapi.ApiDescription;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiErrorReporter;
import org.modellwerkstatt.dataux.runtime.httpapi.JSonApiErrorReporter;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiEndpointBase;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiEndpointSerdes;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiEndpointJSonSerdes;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiOperationBase;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiDefs;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import org.joda.time.LocalDate;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;

public class TestDescription extends ApiDescription {
  @Autowired
  private ApiService __apidescApiService;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  public TestDescription() {
    super("TestDescription", 1);
  }

  @Override
  public String getApiImplVersion() {
    return "1";
  }
  public IApiErrorReporter initApiDescription() {
    IApiErrorReporter errorReporter = new JSonApiErrorReporter(new JackyInfra());


    {
      ApiEndpointBase ParamChecks = new ApiEndpointBase() {
        private IApiEndpointSerdes epSerdes;

        @Override
        public void initEndpointSerdes() {
          epSerdes = new ApiEndpointJSonSerdes(true, CONV.CONV_DEFAULT_EN);
          // register necessary partials
          epSerdes.createPartialSerdes(SimpleDTO.class, false);
          epSerdes.createPartialSerdes(SimpleDTO[].class, true);
        }

        public void initApiOperations() {
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/optionalparam", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "optStringParam", "optIntParam", "optListIntParam", "optListStringParam", "stringParam", "intParam", "listIntParam", "listStringParam");
              String optStringParam = ApiOperationBase.convString("param optStringParam", __request.getParameter("optStringParam"), false, "2");
              int optIntParam = ApiOperationBase.convInt("param optIntParam", __request.getParameter("optIntParam"), false, 2);
              List<Integer> optListIntParam = ApiOperationBase.convListInt("param optListIntParam", __request.getParameter("optListIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 2, 2, 2, 2));
              List<String> optListStringParam = ApiOperationBase.convListString("param optListStringParam", __request.getParameter("optListStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "2", "2", "2", "2"));
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String optHeaderParam = ApiOperationBase.convString("header optHeaderParam", __request.getHeader("optHeaderParam"), false, "2");
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");

              String ret = "";

              ret += " stringParam " + stringParam;
              ret += " intParam " + intParam;
              ret += " listIntParam " + listIntParam;
              ret += " listStringParam " + listStringParam;
              ret += " headerParam " + headerParam;

              ret += " optStringParam " + optStringParam;
              ret += " optIntParam " + optIntParam;
              ret += " optListIntParam " + optListIntParam;
              ret += " optListStringParam " + optListStringParam;
              ret += " optHeaderParam " + optHeaderParam;

              {
                HashMap<String, Object> parameterMap = null;
                __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Some Warning :)"), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
              }
              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "total", ret);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP optionalparam optStringParam, optIntParam, optListIntParam, optListStringParam / optHeaderParam /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/singlepayloadtest", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              SimpleDTO simple;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(1, content);
                epSerdes.checkKnownFieldNames(__deserialized, "simple");
                simple = epSerdes.<SimpleDTO>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO.class, false, "simple", false, null);
              }

              String ret = "";
              ret += " simple " + simple;
              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "total", ret);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP singlepayloadtest  -  /  -  / simple";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/listsinglepayloadtest", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<SimpleDTO> simple;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(1, content);
                epSerdes.checkKnownFieldNames(__deserialized, "simple");
                simple = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple", true, null);
              }
              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "size", ListSequence.fromList(simple).count());
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listsinglepayloadtest  -  /  -  / simple";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/multipayloadtest", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<SimpleDTO> simple;
              List<SimpleDTO> simple1;
              List<SimpleDTO> simple2;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(3, content);
                epSerdes.checkKnownFieldNames(__deserialized, "simple", "simple1", "simple2");
                simple = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple", true, null);
                simple1 = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple1", false, null);
                simple2 = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple2", false, null);
              }

              int content = ListSequence.fromList(simple).count();
              if (simple1 != null) {
                content += ListSequence.fromList(simple1).count();
              }
              if (simple2 != null) {
                content += ListSequence.fromList(simple2).count();
              }

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "size", content);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP multipayloadtest  -  /  -  / simple, simple1, simple2";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/listprimpayload", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<Integer> someList;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(1, content);
                epSerdes.checkKnownFieldNames(__deserialized, "someList");
                someList = epSerdes.<List<Integer>>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, int.class, true, "someList", true, null);
              }

              final Wrappers._int result = new Wrappers._int(0);
              ListSequence.fromList(someList).visitAll((it) -> result.value += it);


              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "result", result.value);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listprimpayload  -  /  -  / someList";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/doublelistprimpayload", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<Integer> intList;
              List<String> stringList;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(2, content);
                epSerdes.checkKnownFieldNames(__deserialized, "intList", "stringList");
                intList = epSerdes.<List<Integer>>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, int.class, true, "intList", true, null);
                stringList = epSerdes.<List<String>>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, String.class, true, "stringList", true, null);
              }




              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "size", ListSequence.fromList(intList).count() + ListSequence.fromList(stringList).count());
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP doublelistprimpayload  -  /  -  / intList, stringList";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/listdtprimpayload", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<LocalDate> dates;
              List<SimpleDTO_SimpleDtoStatus> status;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(2, content);
                epSerdes.checkKnownFieldNames(__deserialized, "dates", "status");
                dates = epSerdes.<List<LocalDate>>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, LocalDate.class, true, "dates", false, __apidescApiService.retNull(__manMapSession));
                status = epSerdes.<List<SimpleDTO_SimpleDtoStatus>>deserToVariable(IApiEndpointSerdes.Hint.STATUS, __deserialized, SimpleDTO_SimpleDtoStatus.class, true, "status", false, null);
              }

              final Wrappers._T<LocalDate> min = new Wrappers._T<LocalDate>(null);
              SimpleDTO_SimpleDtoStatus sta = null;

              if (dates != null) {
                min.value = ListSequence.fromList(dates).first();
                ListSequence.fromList(dates).visitAll((it) -> {
                  if (it.isBefore(min.value)) {
                    min.value = it;
                  }
                });
              }

              if (status != null) {
                sta = ListSequence.fromList(status).last();
                System.err.println(">Just checking correct object conversion " + sta.getDbValue() + " = " + sta.getShortDesc());
              }

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(2);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, LocalDate.class, false, "date", min.value);
                  epSerdes.serVar(IApiEndpointSerdes.Hint.STATUS, serialized, SimpleDTO_SimpleDtoStatus.class, false, "status", sta);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listdtprimpayload  -  /  -  / dates, status";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/listreturn", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<SimpleDTO> simple;
              List<SimpleDTO> simple1;
              List<SimpleDTO> simple2;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(3, content);
                epSerdes.checkKnownFieldNames(__deserialized, "simple", "simple1", "simple2");
                simple = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple", true, null);
                simple1 = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple1", false, null);
                simple2 = epSerdes.<List<SimpleDTO>>deserToVariable(IApiEndpointSerdes.Hint.PARTIAL, __deserialized, SimpleDTO[].class, true, "simple2", false, null);
              }

              List<SimpleDTO> res = ListSequence.fromList(new ArrayList<SimpleDTO>());
              ListSequence.fromList(res).addSequence(ListSequence.fromList(simple));
              if (simple1 != null) {
                ListSequence.fromList(res).addSequence(ListSequence.fromList(simple1));
              }
              // ignore simple2 - just to check serdes infra list/plain
              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "size", ListSequence.fromList(res).count());
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listreturn  -  /  -  / simple, simple1, simple2";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("post", "/testapi1/primitivefiels", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              int id;
              String name;
              BigDecimal bd;
              LocalDate ld;
              DateTime dt;
              SimpleDTO_SimpleDtoStatus status;
              {
                String content = ApiDefs.readPayloadFromRequest(__request);
                IApiEndpointSerdes.Deserialized __deserialized = epSerdes.startPayload(6, content);
                epSerdes.checkKnownFieldNames(__deserialized, "id", "name", "bd", "ld", "dt", "status");
                id = epSerdes.<Integer>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, int.class, false, "id", true, null);
                name = epSerdes.<String>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, String.class, false, "name", true, null);
                bd = epSerdes.<BigDecimal>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, BigDecimal.class, false, "bd", false, new BigDecimal("0.0"));
                ld = epSerdes.<LocalDate>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, LocalDate.class, false, "ld", true, null);
                dt = epSerdes.<DateTime>deserToVariable(IApiEndpointSerdes.Hint.PRIMITIVE, __deserialized, DateTime.class, false, "dt", true, null);
                status = epSerdes.<SimpleDTO_SimpleDtoStatus>deserToVariable(IApiEndpointSerdes.Hint.STATUS, __deserialized, SimpleDTO_SimpleDtoStatus.class, false, "status", true, null);
              }

              String res = "" + id + " / " + name + " / " + bd + " / " + ld + " / " + dt + " / " + status;


              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "result", res);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP primitivefiels  -  /  -  / id, name, bd, ld, dt, status";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/singleresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");


              SimpleDTO dto = new SimpleDTO();
              dto.setId(270180);
              dto.setName("270180");

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO.class, false, "dto", dto);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP singleresponse  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/singlelistresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              List<SimpleDTO> dtoList = ListSequence.fromList(new ArrayList<SimpleDTO>());
              ListSequence.fromList(dtoList).addElement(new SimpleDTO(270180, "270180"));
              ListSequence.fromList(dtoList).addElement(new SimpleDTO(70185, "70185"));




              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO[].class, true, "dtolist", dtoList);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP singlelistresponse  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/multiresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");


              SimpleDTO dto = new SimpleDTO(270180, "270180");

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(2);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO.class, false, "resp1", dto);
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO.class, false, "resp2", dto);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP multiresponse  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/listmultiresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");


              List<SimpleDTO> dtoList = ListSequence.fromList(new ArrayList<SimpleDTO>());
              ListSequence.fromList(dtoList).addElement(new SimpleDTO(270180, "270180"));
              ListSequence.fromList(dtoList).addElement(new SimpleDTO(70185, "70185"));

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(2);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO[].class, true, "listResp1", dtoList);
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PARTIAL, serialized, SimpleDTO[].class, true, "listResp2", dtoList);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listmultiresponse  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/primresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");


              SimpleDTO_SimpleDtoStatus st = SimpleDTO_SimpleDtoStatus.ON;

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(6);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, false, "i", 4711);
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "s", "4711");
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, BigDecimal.class, false, "bd", new BigDecimal("0.01"));
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, LocalDate.class, false, "ld", new LocalDate(1980, 1, 27));
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, DateTime.class, false, "dt", new DateTime(1980, 1, 27, 7, 0, 0, 0));
                  epSerdes.serVar(IApiEndpointSerdes.Hint.STATUS, serialized, SimpleDTO_SimpleDtoStatus.class, false, "st", st);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP primresponse  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/listintresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "num", "stringParam", "intParam", "listIntParam", "listStringParam");
              int num = ApiOperationBase.convInt("param num", __request.getParameter("num"), true, -1);
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");

              List<Integer> theList = ListSequence.fromList(new ArrayList<Integer>());
              for (int i = 0; i < num; i++) {
                ListSequence.fromList(theList).addElement(i);
              }

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, int.class, true, "i", theList);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP listintresponse num /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/liststringresponse", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "num", "stringParam", "intParam", "listIntParam", "listStringParam");
              int num = ApiOperationBase.convInt("param num", __request.getParameter("num"), true, -1);
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");

              List<String> theList = ListSequence.fromList(new ArrayList<String>());
              for (int i = 0; i < num; i++) {
                ListSequence.fromList(theList).addElement("i" + i);
              }

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(2);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, true, "listA", theList);
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, true, "listB", theList);
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP liststringresponse num /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/guard", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");


              if (20 < 100) {

                throw new OFXShutDownSessionException(new OFXProblem(true, __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "This is a guard."), null, null));
              }


              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "noresponse", "");
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP guard  -  /  -  /  - ";
            }
          });
          TestDescription.this.addOperation(new ApiOperationBase("get", "/testapi1/precondition", false) {

            public void executeOp(HttpServletRequest __request, HttpServletResponse __response, IOFXSession __manMapSession) throws Exception {

              ApiOperationBase.checkForUnknownParams(__request, "stringParam", "intParam", "listIntParam", "listStringParam");
              String stringParam = ApiOperationBase.convString("param stringParam", __request.getParameter("stringParam"), false, "1");
              int intParam = ApiOperationBase.convInt("param intParam", __request.getParameter("intParam"), false, 1);
              List<Integer> listIntParam = ApiOperationBase.convListInt("param listIntParam", __request.getParameter("listIntParam"), false, ListSequence.fromListAndArray(new ArrayList<Integer>(), 1, 1, 1, 1));
              List<String> listStringParam = ApiOperationBase.convListString("param listStringParam", __request.getParameter("listStringParam"), false, ListSequence.fromListAndArray(new ArrayList<String>(), "1", "1", "1", "1"));
              String headerParam = ApiOperationBase.convString("header headerParam", __request.getHeader("headerParam"), false, "1");
              String inst = "instance4711";

              {
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("myporp1", 4711);
                parameterMap.put("myprop2", 4712);
                __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "precondition 1 - with props and instance"), "" + inst, parameterMap, new IOFXProblem.Opt[]{}));
              }

              {
                HashMap<String, Object> parameterMap = null;
                __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "precondition 2 - no props"), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.PRIO_INFO}));
              }
              {
                HashMap<String, Object> parameterMap = null;
                __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "precondition 3 - Warning hint"), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
              }
              if (__manMapSession.hasProblemsOtherThanWarnings()) {
                throw new OFXAbortedException();
              }

              List<IOFXProblem> warnings = __manMapSession.getAndclearProblemState();

              {
                IApiEndpointSerdes.ISerialzed serialized = epSerdes.startResponse(1);
                try {
                  epSerdes.serVar(IApiEndpointSerdes.Hint.PRIMITIVE, serialized, String.class, false, "noresponse", "");
                  epSerdes.writeResponse(__response, serialized, warnings);

                } finally {
                  if (serialized != null) {
                    serialized.close();
                  }
                }
              }
            }

            @Override
            public String toString() {
              return "OP precondition  -  /  -  /  - ";
            }
          });
        }
      };

      ParamChecks.initEndpointSerdes();
      ParamChecks.initApiOperations();
    }

    return errorReporter;
  }


}
