package org.modellwerkstatt.objectflow.tests.ConvSerdes;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import java.util.ArrayList;

public class JSonSerialization extends OFXTestSuit {

  @Autowired
  private JsonRootFactory __ConvSerdesJsonRootFactory;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;




  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Serialize and check various types here..", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));
    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);

    String st = myDeser.ser(origObj);
    {
      String operand = st;
      String param0 = "\"intValue\":4711,";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"intValue\":4711,\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"stringValue\":\"Test String\"";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"stringValue\":\"Test String\"\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"bdValue\":\"12.45\"";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"bdValue\":\"12.45\"\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"localDateValue\":\"27.01.80\"";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"localDateValue\":\"27.01.80\"\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"dateTimeValue\":\"04:00:59 27.01.80\"";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"dateTimeValue\":\"04:00:59 27.01.80\"\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"statusValue\":\"S3\"";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  st .contains(\"\"statusValue\":\"S3\"\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

    Text dObj = myDeser.deser(st);

    {
      int leftSide = dObj.getIntValue();
      int rightSide = origObj.getIntValue();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .intValue ==  origObj .intValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = dObj.getBdValue();
      BigDecimal rightSide = origObj.getBdValue();
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .bdValue ==  origObj .bdValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = dObj.getStringValue();
      String rightSide = origObj.getStringValue();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .stringValue ==  origObj .stringValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = dObj.getLocalDateValue().compareTo(origObj.getLocalDateValue());
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .localDateValue.compareTo( origObj .localDateValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = dObj.getDateTimeValue().compareTo(origObj.getDateTimeValue());
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .dateTimeValue.compareTo( origObj .dateTimeValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      Text_MySatus leftSide = dObj.getStatusValue();
      Text_MySatus rightSide = origObj.getStatusValue();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .statusValue ==  origObj .statusValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = dObj.getTextChild().getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = dObj.getTextChild().getBdValue();
      BigDecimal rightSide = new BigDecimal("47.11");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .textChild.bdValue == 47.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = dObj.getTextChild().getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S1))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .textChild.statusValue of S1           ==>>" + operand + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(dObj.getMultipleChilds()).count();
      int rightSide = ListSequence.fromList(dObj.getMultipleChilds()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize and check various types here..':  dObj .multipleChilds.size ==  dObj .multipleChilds.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "Serialize null fields to json correctly..", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));
    Text obj = new Text();

    obj.setIntValue(0);
    obj.setStringValue(null);
    obj.setBdValue(null);
    obj.setLocalDateValue(null);
    obj.setDateTimeValue(null);
    obj.setStatusValue(null);

    obj.setTextChild(null);
    obj.setMultipleChilds(null);

    String json = myDeser.ser(obj);
    String toCheckAgainst = "{\"intValue\":0,\"stringValue\":null,\"bdValue\":null,\"localDateValue\":null,\"dateTimeValue\":null,\"statusValue\":null,\"textChild\":null,\"multipleChilds\":null}";
    {
      String operand = json;
      String param0 = toCheckAgainst;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize null fields to json correctly..':  json .equals( toCheckAgainst )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Using Key Substitutioner for json to obj graph", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB));
    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);

    String st = myDeser.ser(origObj);
    {
      String operand = st;
      String param0 = "\"int-Value\":4711,";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Using Key Substitutioner for json to obj graph':  st .contains(\"\"int-Value\":4711,\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"text-Child\":{";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Using Key Substitutioner for json to obj graph':  st .contains(\"\"text-Child\":{\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Writing empty list and null object to json", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);

    ListSequence.fromList(origObj.getMultipleChilds()).clear();
    origObj.setTextChild(null);

    String st = myDeser.ser(origObj);
    {
      String operand = st;
      String param0 = "\"textChild\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing empty list and null object to json':  st .contains(\"\"textChild\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"multipleChilds\":[]";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing empty list and null object to json':  st .contains(\"\"multipleChilds\":[]\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 4, name = "Writing null values to json", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));
    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);

    origObj.setIntValue(0);
    origObj.setStringValue(null);
    origObj.setBdValue(null);
    origObj.setDateTimeValue(null);
    origObj.setLocalDateValue(null);
    origObj.setStatusValue(null);

    String st = myDeser.ser(origObj);
    {
      String operand = st;
      String param0 = "\"intValue\":0";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"intValue\":0\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"stringValue\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"stringValue\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"bdValue\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"bdValue\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"dateTimeValue\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"dateTimeValue\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"localDateValue\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"localDateValue\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"statusValue\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Writing null values to json':  st .contains(\"\"statusValue\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "Just trying to serialize the complex ROOT obj, but check for BOOLEAN also.", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<ROOT> myDeser = CONV.<ROOT>jsonSerDes(ROOT.class, new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB_COMPLEX));
    ROOT origObj = __ConvSerdesJsonRootFactory.createROOT(__manMapSession);

    String st = myDeser.ser(origObj);

    {
      String operand = st;
      String param0 = "\"useJSP\":false,";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize the complex ROOT obj, but check for BOOLEAN also.':  st .contains(\"\"useJSP\":false,\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"useDataStore\":true,";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize the complex ROOT obj, but check for BOOLEAN also.':  st .contains(\"\"useDataStore\":true,\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Just trying to serialize an entity with valueObject", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<MyE> myDeser = CONV.<MyE>jsonSerDes(MyE.class, new ConvStdFormatters(opts));
    MyE origObj = __ConvSerdesJsonRootFactory.createEntity(__manMapSession);

    String st = myDeser.ser(origObj);

    {
      String operand = st;
      String param0 = "\"vo1\":{";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize an entity with valueObject':  st .contains(\"\"vo1\":{\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"vo2\":{";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize an entity with valueObject':  st .contains(\"\"vo2\":{\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = st;
      String param0 = "\"myIntVal\":4712";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize an entity with valueObject':  st .contains(\"\"myIntVal\":4712\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "\"myIntVal\":4713";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Just trying to serialize an entity with valueObject':  st .contains(\"\"myIntVal\":4713\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }


  }
  @OFXTestMethod(id = 7, name = "Serialize a list of DTOs into a string.", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text[]> myDeser = CONV.<Text[]>jsonSerDes(Text[].class, new ConvStdFormatters(opts));

    Text textObj = __ConvSerdesJsonRootFactory.create(__manMapSession);
    Text textObj2 = __ConvSerdesJsonRootFactory.create(__manMapSession);
    Text[] textArray = new Text[]{textObj, textObj2};

    String st = myDeser.ser(textArray);


    {
      String operand = st;
      String param0 = "[{";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.startsWith(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize a list of DTOs into a string.':  st .startsWith(\"[{\")          ==>> '" + operand + "'.startsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      int leftSide = st.indexOf("\"intValue\":4711");
      int rightSide = st.lastIndexOf("\"intValue\":4711");
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize a list of DTOs into a string.':  st .indexOf(\"\"intValue\":4711\") !=  st .lastIndexOf(\"\"intValue\":4711\")          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 8, name = "Serialize null list property to null field", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));
    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);


    origObj.setMultipleChilds(null);
    String st = myDeser.ser(origObj);

    {
      String operand = st;
      String param0 = "\"multipleChilds\":null";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize null list property to null field':  st .contains(\"\"multipleChilds\":null\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Serialize a list of simple int's ", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);

    IConvSerdes<ErrCodes[]> myDeser = CONV.<ErrCodes[]>jsonSerDes(ErrCodes[].class, new ConvStdFormatters(opts));

    ComplexArr arrayObject = __ConvSerdesJsonRootFactory.createComplexArrObject(__manMapSession);
    ErrCodes[] codes = ListSequence.fromList(arrayObject.getErrorCodes()).toGenericArray(ErrCodes.class);

    String st = myDeser.ser(codes);

    {
      String operand = st;
      String param0 = "[500,501,502]";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize a list of simple int's ':  st .equals(\"[500,501,502]\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 10, name = "Serialize a cycle of objects", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    RootEntity root = ((_FunctionTypes._return_P0_E0<RootEntity>) () -> {
      RootEntity tmp = new RootEntity();
      tmp.setListOfChilds(ListSequence.fromList(new ArrayList<RootChild>()));
      tmp.setId(1);
      tmp.setRootName("Root");
      ListSequence.fromList(tmp.getListOfChilds()).addElement(new _FunctionTypes._return_P0_E0<RootChild>() {
        public RootChild invoke() {
          RootChild tmp = new RootChild();
          tmp.setId(2);
          tmp.setChildName("Child 2");
          return tmp;
        }
      }.invoke());
      ListSequence.fromList(tmp.getListOfChilds()).addElement(new _FunctionTypes._return_P0_E0<RootChild>() {
        public RootChild invoke() {
          RootChild tmp = new RootChild();
          tmp.setId(3);
          tmp.setChildName("Child 3");
          return tmp;
        }
      }.invoke());
      ListSequence.fromList(tmp.getListOfChilds()).addElement(new _FunctionTypes._return_P0_E0<RootChild>() {
        public RootChild invoke() {
          RootChild tmp = new RootChild();
          tmp.setListOfChilds(ListSequence.fromList(new ArrayList<RootChild>()));
          tmp.setId(4);
          tmp.setChildName("Child 4");
          ListSequence.fromList(tmp.getListOfChilds()).addElement(new _FunctionTypes._return_P0_E0<RootChild>() {
            public RootChild invoke() {
              RootChild tmp = new RootChild();
              tmp.setId(5);
              tmp.setChildName("Child 5");
              return tmp;
            }
          }.invoke());
          return tmp;
        }
      }.invoke());
      return tmp;
    }).invoke();

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<RootEntity> myDeser = CONV.<RootEntity>jsonSerDes(RootEntity.class, new ConvStdFormatters(opts));
    String st = myDeser.ser(root);

    {
      String operand = st;
      String param0 = "Child 5";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize a cycle of objects':  st .contains(\"Child 5\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 11, name = "Serialize complex object with list of simple int's ", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#0.00", "en", IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);

    IConvSerdes<ComplexArr> myDeser = CONV.<ComplexArr>jsonSerDes(ComplexArr.class, new ConvStdFormatters(opts));

    ComplexArr arrayObject = __ConvSerdesJsonRootFactory.createComplexArrObject(__manMapSession);

    String st = myDeser.ser(arrayObject);

    {
      String operand = st;
      String param0 = "[500,501,502]";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize complex object with list of simple int's ':  st .contains(\"[500,501,502]\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "[14.14,15.15]";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.Serialize complex object with list of simple int's ':  st .contains(\"[14.14,15.15]\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 12, name = "StringSerDes: Serialize and check various types here..", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>stringSer(Text.class, new ConvStdFormatters(opts));
    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);

    String st = myDeser.ser(origObj);

    {
      String operand = st;
      String param0 = "intValue: 4711";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"intValue: 4711\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "stringValue: Test String";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"stringValue: Test String\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "bdValue: 12.45";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"bdValue: 12.45\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "localDateValue: 27.01.80";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"localDateValue: 27.01.80\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "dateTimeValue: 04:00:59 27.01.80";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"dateTimeValue: 04:00:59 27.01.80\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "statusValue: S3";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.StringSerDes: Serialize and check various types here..':  st .contains(\"statusValue: S3\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 13, name = "FopXMLSerializer: Serialize and check various types here..", debug = false, enabled = true, runAt = "")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IConvSerdes fopSerializer = CONV.fopXmlSer();
    MyE entity = __ConvSerdesJsonRootFactory.createEntity(__manMapSession);

    String st = fopSerializer.ser(entity);

    {
      String operand = st;
      String param0 = "<MYINTVAL>4712</MYINTVAL>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .contains(\"<MYINTVAL>4712</MYINTVAL>\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "<MYSTRINGVAL>4712</MYSTRINGVAL>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .contains(\"<MYSTRINGVAL>4712</MYSTRINGVAL>\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "<VO1>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .contains(\"<VO1>\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "<VO2>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .contains(\"<VO2>\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = st;
      String param0 = "<CHILDSSET>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .contains(\"<CHILDSSET>\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

    st = CONV.fopXmlSer().ser(entity);
    // was checked to be backward compatible with conv(entity) Winter 2021/22
    {
      int leftSide = st.length();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'JSonSerialization.FopXMLSerializer: Serialize and check various types here..':  st .length() > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", JSonSerialization.class, allIncludedTest, includedTestToRun);
  }
}
