package org.modellwerkstatt.objectflow.tests.ObjectFlowInfra;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import java.text.DecimalFormat;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity_OnOff;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import java.util.Locale;

public class Services extends OFXTestSuit {

  @Autowired
  private SimpleService __ObjectFlowInfraSimpleService;
  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private PlatformService __ObjectFlowInfraPlatformService;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private DecimalFormat deziFormat = new DecimalFormat("#,##0.00");
  private String bigDeci10 = deziFormat.format(new BigDecimal("10.0"));
  private int DE = -1;
  private String NULL_STRING = "#NULL?";
  @Autowired
  private IOFXPlatform platform;

  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "OFXS_INSTANCE", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public IOFXTranslationProvider __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OFXStringFormatter2 frmt = new OFXStringFormatter2();
    frmt.setBigDecimalFormat("#,##0.00");
    frmt.setDateTimeFormat("dd.MM.yyyy hh:mm:ss");
    frmt.setTimeDateTimeFormat("hh:mm");
    frmt.setLocalDateFormat("dd.MM.yy");
    frmt.setShortLocalDateFormat("dd.MMM");
    frmt.afterPropertiesSet();

    return frmt;
  }
  @OFXTestMethod(id = 1, name = "Formatting not format chars at al", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);


    String toFormat = p.translate(DE, "Hello World");
    {
      String operand = toFormat;
      String param0 = "Hello World";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Formatting not format chars at al':  toFormat .equals(\"Hello World\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Format simple integer, string, decimal, float.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "%d,%s,%f,%f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);
    String expected = String.format("%d,%s,%f,%f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);
    // default seems to be 6 commas ..
    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format simple integer, string, decimal, float.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 3, name = "Format simple integer, string, decimal, float with format specified", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "%05d,%5s,%05.2f,%07.2f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);
    String expected = String.format("%05d,%5s,%05.2f,%07.2f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format simple integer, string, decimal, float with format specified':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 4, name = "Format simple float and bigDecimal with dynamic formatter", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "DAN %07.3f == %07.3bd DAN %05.2bd DAN", new BigDecimal("1.4711"), new BigDecimal("1.4711"), new BigDecimal("1.4711"));
    String expected = String.format("DAN %07.3f == %07.3f DAN %05.2f DAN", new BigDecimal("1.4711"), new BigDecimal("1.4711"), new BigDecimal("1.4711"));

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format simple float and bigDecimal with dynamic formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 5, name = "Format simple bigDecimal with default formatter", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "DAN %bd DAN %bd", new BigDecimal("123456.4711"), new BigDecimal("12.4711"));
    String expected = "DAN 123.456,47 DAN 12,47";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format simple bigDecimal with default formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Format status, DB-Values, Short-, Long-Desc and nulls.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "%stdb,%sts,%st,%stdb,%sts,%st", AuditEntity_OnOff.ON, AuditEntity_OnOff.ON, AuditEntity_OnOff.ON, null, null, null);
    String expected_BEFORE_REFACT_JULY23 = "ON,On_Short,On_Long,,,";

    String expected = "ON,On_Short,On_Long," + NULL_STRING + "," + NULL_STRING + "," + NULL_STRING;

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format status, DB-Values, Short-, Long-Desc and nulls.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 7, name = "Applying Escape character to string formatter", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "DAN%%DAN");
    String expected = "DAN%DAN";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Applying Escape character to string formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 8, name = "Applying Escape character to string formatter - more complex version.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "%%%%%%%%DAN%%");
    String expected = "%%%%DAN%";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Applying Escape character to string formatter - more complex version.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Format LocalDate and DateTime with %dt", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    String toFormat = p.translate(DE, "DAN%dtDAN%dtDAN", curTime, currentDate);
    String expected = "DAN27.01.1980 05:30:20DAN27.01.1980 ��:��:��DAN";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %dt':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 10, name = "Format LocalDate and DateTime with %tdt", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    String toFormat = p.translate(DE, "DAN%tdtDAN%tdtDAN", curTime, currentDate);
    String expected = "DAN05:30DAN��:��DAN";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %tdt':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 11, name = "Format LocalDate and DateTime with %ld", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    String toFormat = p.translate(DE, "DAN%ldDAN%ldDAN", curTime, currentDate);
    String expected = "DAN27.01.80DAN27.01.80DAN";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %ld':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 12, name = "Format LocalDate and DateTime with %sld", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    String toFormat = p.translate(DE, "DAN%sldDAN%sldDAN", curTime, currentDate);
    String expected = "DAN27.JanDAN27.JanDAN";

    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %sld':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 13, name = "Force %d and %s instead of moware extensions starting with %s or %d.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    String toFormat = p.translate(DE, "DAN%0dtDAN%0stDAN", 4711, "string");
    String expected = "DAN4711tDANstringtDAN";
    {
      String operand = toFormat;
      String param0 = expected;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Force %d and %s instead of moware extensions starting with %s or %d.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 14, name = "Rainy - sld with width and precission is taken as %s and will be checked.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        String toFormat = p.translate(DE, "DAN%2.0sldDAN%2.0sldDAN", curTime, currentDate);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("but argument")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("but argument")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 15, name = "Rainy - tdt with width and precission is wrong.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    LocalDate currentDate = new LocalDate(1980, 1, 27);
    DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        String toFormat = p.translate(DE, "DAN%2.0tdtDAN%2.0tdtDAN", curTime, currentDate);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("unclear how we should handle")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("unclear how we should handle")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 16, name = "Rainy - argument forgotten", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        String toFormat = p.translate(DE, "DAN%0dtDAN%0stDAN", 4711);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("Expecting to format argument 2 but we have only 1 in total")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("Expecting to format argument 2 but we have only 1 in total")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 17, name = "Rainy - wrong argument (eg. for dt)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        String toFormat = p.translate(DE, "DAN%dtDAN%dtDAN", 4711, 4711);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("is required")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("is required")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 18, name = "Rainy - wrong argument (eg. for status)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        String toFormat = p.translate(DE, "DAN%stDAN%stDAN", 4711, 4711);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("is required")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("is required")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 19, name = "Multistring - Print status", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String s = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts ok", AccountKey_Active.ON);
    {
      String operand = s;
      String param0 = "On ok";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Multistring - Print status':  s .equals(\"On ok\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    AuditEntity_OnOff status = AuditEntity_OnOff.ON;
    s = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts ok", status);
    {
      String operand = s;
      String param0 = "On_Short ok";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Multistring - Print status':  s .equals(\"On_Short ok\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 20, name = "MultiString - Print BigDecimal.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String s = __ObjectFlowInfraSimpleService.testInteger_String_BigDeci(10, "dan", new BigDecimal("10.0"), __manMapSession);
    {
      String operand = s;
      String param0 = "   10   dan   " + bigDeci10 + "   ";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Print BigDecimal.':  s .equals(\"   10   dan   \" +  bigDeci10  + \"   \")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 21, name = "MultiString - Print BigDecimal with 4 f", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String s = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%.4bd", new BigDecimal("10.999855"));
    {
      String operand = s;
      String param0 = "10,9999";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Print BigDecimal with 4 f':  s .equals(\"10,9999\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 22, name = "MultiString - Print LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String s = __ObjectFlowInfraSimpleService.testInteger_String_BigDeci_LocalDate_DateTime(10, "dan", new BigDecimal("10.0"), DeprecatedServerDateProvider.getSqlServerLocalDate(), DeprecatedServerDateProvider.getSqlServerDateTime(), __manMapSession);

    String shouldBe = "   10   dan   " + bigDeci10 + "   27.01.80   27.01.1980 04:30:00   ";

    {
      String operand = s;
      String param0 = shouldBe;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Print LocalDate and DateTime.':  s .equals( shouldBe )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 23, name = "MultiString - Print LocalDate and LocalDate.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String s = __ObjectFlowInfraSimpleService.testInteger_String_BigDeci_LocalDate_Localdate(10, "dan", new BigDecimal("10.0"), DeprecatedServerDateProvider.getSqlServerLocalDate(), DeprecatedServerDateProvider.getSqlServerDateTime(), __manMapSession);
    {
      String operand = s;
      String param0 = "   10   dan   " + bigDeci10 + "   27.01.80   27.01.80   ";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Print LocalDate and LocalDate.':  s .equals(\"   10   dan   \" +  bigDeci10  + \"   27.01.80   27.01.80   \")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 24, name = "MultiString - Used in OFXTestSuit itself.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello %s %d", "Dan", 10), __manMapSession);
    {
      String operand = ListSequence.fromList(inv1.getPositions()).first().getPosText();
      String param0 = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello Dan 10_0");
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Used in OFXTestSuit itself.':  inv1 .positions.first.posText.equals('Hello Dan 10_0')          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    inv1.setText(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello Wolfgang it is %dt", DeprecatedServerDateProvider.getSqlServerDateTime()));
    {
      String operand = inv1.getText();
      String param0 = "Hello Wolfgang it is 27.01.1980 04:30:00";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - Used in OFXTestSuit itself.':  inv1 .text.equals(\"Hello Wolfgang it is 27.01.1980 04:30:00\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 25, name = "MultiString - More complex string with string and decimal precission", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%06d = %s", 4711, "4711");
      String param0 = "004711 = 4711";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - More complex string with string and decimal precission': '%06d = %s'.equals(\"004711 = 4711\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 26, name = "MultiString - More complex int with float precission", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%4d and %2.2f", 4711, 88.88f);
      String param0 = String.format("%4d and %2.2f", 4711, 88.88f);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - More complex int with float precission': '%4d and %2.2f'.equals(String.format(\"%4d and %2.2f\", 4711,  floating point constant (float) ))          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 27, name = "MultiString - More complex string with new line and int", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%06d%n", 4711);
      String param0 = String.format("%06d%n", 4711);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.MultiString - More complex string with new line and int': '%06d%n'.equals(String.format(\"%06d%n\", 4711))          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 28, name = "Check platform is handled correctly, running on Platform_1.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {




    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __ObjectFlowInfraPlatformService.dependsOnPlatForm(__manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 29, name = "get platform and set platform. set platform forth and back.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    String currentPlatform = platform.getPlatformName();
    {
      boolean leftSide = platform.isPlatform(currentPlatform, null);
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform( currentPlatform ,  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    platform.setPlatformName("dan");
    {
      boolean leftSide = platform.isPlatform("dan", null);
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform(\"dan\",  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    platform.setPlatformName(currentPlatform);
    {
      boolean leftSide = platform.isPlatform(currentPlatform, null);
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform( currentPlatform ,  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 30, name = "Check Platform aware string handling.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    platform.setPlatformName("Default");
    String st1 = __ObjectFlowInfraSimpleService.calcPlatformString(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      String operand = st1;
      String param0 = "Default Platform";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st1 .equals(\"Default Platform\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }


    platform.setPlatformName("Platform_2");
    String st2 = __ObjectFlowInfraSimpleService.calcPlatformString(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      String operand = st2;
      String param0 = "Default";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st2 .equals(\"Default\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    platform.setPlatformName("Some Other Platform");
    String st3 = __ObjectFlowInfraSimpleService.calcPlatformString(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      String operand = st3;
      String param0 = "Default";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st3 .equals(\"Default\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 31, name = "Some checks on Fail-In: RuntimeException with text.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        throw new RuntimeException("Hello this is some text");

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("some text")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("some text")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 32, name = "Some checks on Fail-In: condition with text handled correctly.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_32(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        {
          HashMap<String, Object> parameterMap = null;
          __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello condtion some text."), null, parameterMap, new IOFXProblem.Opt[]{}));
          throw new OFXAbortedException();
        }

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("some text")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("some text")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 33, name = "Strange behaviour of JAVA 11 on short local date printing. ", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_33(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    Locale l = Locale.getDefault();

    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 1, 27));
      String param0 = "Jan";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jan\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 2, 27));
      String param0 = "Feb";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Feb\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 3, 27));
      String param0 = "Mär";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Mär\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 4, 27));
      String param0 = "Apr";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Apr\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 5, 27));
      String param0 = "Mai";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Mai\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 6, 27));
      String param0 = "Jun";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jun\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 7, 27));
      String param0 = "Jul";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jul\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 8, 27));
      String param0 = "Aug";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Aug\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 9, 27));
      String param0 = "Sep";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Sep\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 10, 27));
      String param0 = "Okt";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Okt\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 11, 27));
      String param0 = "Nov";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Nov\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new DateTime().withDate(1980, 12, 27));
      String param0 = "Dez";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Dez\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 34, name = "Handling of null in OFXStringFormatter 2", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_34(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    BigDecimal bd = null;
    DateTime dt = null;
    AccountKey_Active status = null;
    LocalDate ld = null;
    Integer intVal = null;
    Float floatVal = null;


    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%bd", bd);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%bd'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%dt", dt);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%dt'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%tdt", dt);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%tdt'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%ld", ld);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%ld'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", ld);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%sld'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%st", status);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%st'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts", status);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%sts'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%stdb", status);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%stdb'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }


    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%d", intVal);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%d'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = __runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%f", bd);
      String param0 = NULL_STRING;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%f'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Services.class, allIncludedTest, includedTestToRun);
  }
}
