package org.modellwerkstatt.objectflow.tests.ObjectFlowInfra;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IMoLdapService;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;

public class Tests_Ldap__not_in_compound_tests_ extends OFXTestSuit {

  @Autowired
  private LdapService __ObjectFlowInfraLdapService;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private String userName;



  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    userName = "daniels";
  }


  @OFXTestMethod(id = 0, name = "Can we login/ not log in a user with password.", debug = false, enabled = false, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String userPassword;
    try {
      BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
      System.err.print("Enter password for AD User " + userName + ": ");
      userPassword = br.readLine();
      br.close();

    } catch (IOException ex) {
      throw new RuntimeException(ex);
    }


    {
      String param0 = userName;
      String param1 = userPassword;

      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.append("" + param1 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);

      if (!(__ObjectFlowInfraLdapService.authenticatedMe(param0, param1, null))) {
        throw new OFXTestSuitException("'Tests Ldap (not in compound tests).Can we login/ not log in a user with password.': #LdapService.authenticatedMe( userName ,  userPassword )          ==>> op call with(" + textRepresentation + ")" + "\n");
      }
    }
    if (!(!(__ObjectFlowInfraLdapService.authenticatedMe(userName + "X", userPassword, null)))) {
      throw new OFXTestSuitException("'Tests Ldap (not in compound tests).Can we login/ not log in a user with password.': !(#LdapService.authenticatedMe( userName  + \"X\",  userPassword ))          ==>> FALSE !" + "\n");
    }
    if (!(!(__ObjectFlowInfraLdapService.authenticatedMe(userName, userPassword + "X", null)))) {
      throw new OFXTestSuitException("'Tests Ldap (not in compound tests).Can we login/ not log in a user with password.': !(#LdapService.authenticatedMe( userName ,  userPassword  + \"X\"))          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 1, name = "Can retrieve groups of user.", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<IMoLdapService.ICnInfo> groupInfo = __ObjectFlowInfraLdapService.getGroupsToUser(userName, null);
    {
      int leftSide = ListSequence.fromList(groupInfo).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Tests Ldap (not in compound tests).Can retrieve groups of user.':  groupInfo .size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    ListSequence.fromList(groupInfo).visitAll((it) -> {
    });
  }
  @OFXTestMethod(id = 2, name = "Can retrieve groups of common name.", debug = true, enabled = true, runAt = "")
  public void __testmethod_2(final IOFXSession __manMapSession, final IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {

    __testSuitHandler.breakLine(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "'Tests Ldap (not in compound tests).Can retrieve groups of common name.'");

    List<IMoLdapService.ICnInfo> userGroupInfo = __ObjectFlowInfraLdapService.getGroupsToUser(userName, null);
    {
      int leftSide = ListSequence.fromList(userGroupInfo).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Tests Ldap (not in compound tests).Can retrieve groups of common name.':  userGroupInfo .size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    if (ListSequence.fromList(userGroupInfo).count() > 0) {
      __testSuitHandler.debug(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "passed:  userGroupInfo .size > 0");
    }
    ListSequence.fromList(userGroupInfo).visitAll((it) -> {
      List<IMoLdapService.ICnInfo> furtherGroupInfo = __ObjectFlowInfraLdapService.getGroupsToCommonName("OU=01RESOURCE,DC=mpreis,DC=co,DC=at", it.getProcessedName(), null);

      __testSuitHandler.debug(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "Groupname " + it.getUnprocessedName());
      ListSequence.fromList(furtherGroupInfo).visitAll(new _FunctionTypes._void_P1_E0<IMoLdapService.ICnInfo>() {
        public void invoke(IMoLdapService.ICnInfo it) {
          __testSuitHandler.debug(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "     Subgroupname processed " + it.getProcessedName());
          __testSuitHandler.debug(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "     Subgroupname unprocessed " + it.getUnprocessedName() + "\n");

        }
      });

    });
  }
  @OFXTestMethod(id = 3, name = "Can retrieve names to common name.", debug = true, enabled = true, runAt = "")
  public void __testmethod_3(final IOFXSession __manMapSession, final IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {

    __testSuitHandler.breakLine(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "'Tests Ldap (not in compound tests).Can retrieve names to common name.'");

    List<IMoLdapService.ICnInfo> names = __ObjectFlowInfraLdapService.getNamesToAttrAndCommonName("OU=DOKUMENTENARCHIV,OU=02PERMISSIONS,DC=mpreis,DC=co,DC=at", "member", "XS_ArchivType-KONTOAUSZUG", null);

    ListSequence.fromList(names).visitAll((it) -> {
      __testSuitHandler.debug(__manMapSession, "org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.Tests_Ldap__not_in_compound_tests_", "Member " + it.getProcessedName());

    });
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Tests_Ldap__not_in_compound_tests_.class, allIncludedTest, includedTestToRun);
  }
}
