package org.modellwerkstatt.objectflow.tests.OrderDocument;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import org.modellwerkstatt.objectflow.runtime.IOFXMeta4Object;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import java.math.BigDecimal;
import jetbrains.mps.references.Reference;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class MonetaryValue implements IOFXValueObject<MonetaryValue>, IOFXMeta4Object, IOFXRevertableObject {

  protected boolean _enabled = true;
  public void setEnabled(boolean value) {
    this._enabled = value;
  }
  public boolean getEnabled() {
    return this._enabled;
  }
  public MonetaryValue _META() {
    return this;
  }



  protected OFXBigDecimal amount = new OFXBigDecimal();
  protected OFXString currency = new OFXString();
  public BigDecimal getAmount() {
    return this.amount.getValue();
  }
  private void _setAmount(BigDecimal value) {
    if (this.amount.setValue(value)) {
    }
  }
  public BigDecimal setAmount(BigDecimal value) {
    _setAmount(value);
    return value;
  }
  public Reference<BigDecimal> refToAmount() {
    return new Reference<BigDecimal>() {
      public BigDecimal get() {
        return getAmount();
      }
      public void set(BigDecimal value) {
        _setAmount(value);
      }
    };
  }
  public String getCurrency() {
    return this.currency.getValue();
  }
  private void _setCurrency(String value) {
    if (this.currency.setValue(value)) {
    }
  }
  public String setCurrency(String value) {
    _setCurrency(value);
    return value;
  }
  public Reference<String> refToCurrency() {
    return new Reference<String>() {
      public String get() {
        return getCurrency();
      }
      public void set(String value) {
        _setCurrency(value);
      }
    };
  }

  public MonetaryValue() {
  }
  public MonetaryValue(BigDecimal amnt) {
    setAmount(amnt);
    setCurrency("EUR");
  }
  public MonetaryValue(BigDecimal amnt, String cur) {
    setAmount(amnt);
    setCurrency(cur);
  }
  public MonetaryValue withAmount(BigDecimal val) {
    return new MonetaryValue(val, getCurrency());
  }
  public MonetaryValue withCurrency(String cur) {
    return new MonetaryValue(getAmount(), cur);
  }
  public IOFXMetaRangeScale<BigDecimal> getAmount_META() {
    return this.amount;
  }
  public IOFXMetaLength<String> getCurrency_META() {
    return this.currency;
  }

  public boolean isNullKey() {
    boolean isNullKey = true;
    isNullKey &= (this.currency.getValue() == null || this.currency.getValue().equals(""));
    isNullKey &= (this.amount.getValue() == null);
    return isNullKey;
  }

  public MonetaryValue createNullKey() {
    MonetaryValue nullKey = new MonetaryValue();
    nullKey.currency.setValue("");
    nullKey.amount.setValue(null);
    return nullKey;
  }

  @Override
  public boolean equals(Object object) {
    if (this == object) {
      return true;
    }

    if (!(object instanceof MonetaryValue)) {
      return false;
    }
    MonetaryValue that = (MonetaryValue) object;
    boolean result = true;

    result &= SaveObjectComperator.equalsBigDecimal(this.amount.getValue(), that.amount.getValue());
    result &= SaveObjectComperator.equals(this.currency.getValue(), that.currency.getValue());
    return result;
  }
  @Override
  public int hashCode() {
    int result = 17;
    if (((Object) this.currency.getValue()) != null) {
      result = 37 * result + ((Object) this.currency.getValue()).hashCode();
    } else {
      // hashcode of null is 0, then multiply result.
      result = 37 * result;
    }
    if (this.amount.getValue() != null) {
      result = 37 * result + ((BigDecimal) this.amount.getValue()).stripTrailingZeros().hashCode();
    } else {
      // hashcode of null is 0, then multiply result.
      result = 37 * result;
    }

    return result;
  }
  @Override
  public String toString() {
    String result = "MonetaryValue  ";
    result += this.amount.getValue() + " ";
    result += this.currency.getValue() + " ";
    return result;
  }

  public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
    MonetaryValue val = ((MonetaryValue) param);
    // this does not correspond to the immutable pattern, but we want to
    // revert the last step? Does that lead to problems? > in collection! but collections are not allowed for vO
    this.amount.load(val.amount, fullRevertNotMerge);
    this.currency.load(val.currency, fullRevertNotMerge);
    if (fullRevertNotMerge) {
      this._enabled = val._enabled;
    }
  }

  public MonetaryValue copy() {
    // just to be safe, we could also expose the current valueObject,
    // since it is defined as imutable
    MonetaryValue valueObject = new MonetaryValue();
    valueObject.amount = this.amount.copy();
    valueObject.currency = this.currency.copy();
    valueObject._enabled = this._enabled;
    return valueObject;
  }
}
