package org.modellwerkstatt.objectflow.tests.OrderDocument;

/*Generated by MPS */

import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.joda.time.LocalDate;
import jetbrains.mps.internal.collections.runtime.ListSequence;

@Component(value = "org.modellwerkstatt.objectflow.tests.OrderDocument.ODS")
public class ODS {

  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private ODS __OrderDocumentODS = this;


  public void checkAndSetEdititing(OrderDocument agg, final IOFXSession __manMapSession) {
    if (!(SaveObjectComperator.equalsStatus(agg.getStatus(), OrderDocument_OrderDocStatus.DRAFT, OrderDocument_OrderDocStatus.EDITING))) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Can only be called in draft or editing."), null, parameterMap, new IOFXProblem.Opt[]{}));
      throw new OFXAbortedException();
    }

    boolean arePositionsEdited = true;

    if (SaveObjectComperator.equalsStatus(agg.getStatus(), OrderDocument_OrderDocStatus.DRAFT) && arePositionsEdited) {
      agg.setStatus(OrderDocument_OrderDocStatus.EDITING);
    }
  }
  public void order(OrderDocument od, final IOFXSession __manMapSession) {
    if (!(!(SaveObjectComperator.equalsStatus(od.getStatus(), OrderDocument_OrderDocStatus.ORDERED)))) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Can not be called in status ordered."), null, parameterMap, new IOFXProblem.Opt[]{}));
      throw new OFXAbortedException();
    }

    // validation
    if (!(od.getExpectedDate().isBefore(new LocalDate(1980, 1, 27)))) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Order date should not be before 27 Jan 80."), "" + od.getExpectedDate(), parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
    }

    if (!(ListSequence.fromList(od.getPositions()).count() > 5)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Ordering less then 5 positions, additional charges may apply."), "" + od.getPositions(), parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
    }

    {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Order status is changed to ordered. This is a hint."), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
    }


    // changing graph here.
    od.setStatus(OrderDocument_OrderDocStatus.ORDERED);
  }
  public void approve(OrderDocument od, boolean someComplexCondition, final IOFXSession __manMapSession) {


    if (!(someComplexCondition)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "This is just a warning. ComplexCondition is not true."), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
    }

    if (!(someComplexCondition)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "This is an error message. (status %sts)", od.getStatus()), "" + od, parameterMap, new IOFXProblem.Opt[]{}));
    }
    if (!(someComplexCondition)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "This is another error message."), "" + od, parameterMap, new IOFXProblem.Opt[]{}));
    }
    if (__manMapSession.hasProblemsOtherThanWarnings()) {
      throw new OFXAbortedException();
    }


    // status has to be ordered
    od.setStatus(OrderDocument_OrderDocStatus.APPROVED);
  }
  public void revision(OrderDocument od, String reason, final IOFXSession __manMapSession) {

    // cancel xxx when boolexp

    // bool exp else <fehlermeldung>

    boolean revisionIsPossible = false;
    boolean revisionOrderValueTooHigh = true;

    if (!(revisionIsPossible)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Revision on this order not possible cause ..."), null, parameterMap, new IOFXProblem.Opt[]{}));
    }

    helperMethod(__manMapSession);

    if (!(!(revisionOrderValueTooHigh))) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Order value too high for a revision. It should not be above ..."), null, parameterMap, new IOFXProblem.Opt[]{}));
    }
    if (__manMapSession.hasProblemsOtherThanWarnings()) {
      throw new OFXAbortedException();
    }


    //  changing graph.
    od.setStatus(OrderDocument_OrderDocStatus.REVISIONED);
    od.setRemark(od.getRemark() + " [" + reason + "]");


  }
  private void helperMethod(final IOFXSession __manMapSession) {

    if (!(1 > 10)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Problem 1 from helper Method"), null, parameterMap, new IOFXProblem.Opt[]{}));
    }

    if (!(1 > 10)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Problem 2 from helper Method"), null, parameterMap, new IOFXProblem.Opt[]{}));
    }
    if (__manMapSession.hasProblemsOtherThanWarnings()) {
      throw new OFXAbortedException();
    }

  }
  public boolean problemsWithOptions(final IOFXSession __manMapSession) {

    if (!(1 > 10)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "With Job_Ignore option"), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.JOB_IGNORE}));
    }
    if (!(1 > 10)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "With Job_Item_Alread_Done option"), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.JOB_ITEM_ALREAD_DONE}));
    }
    if (!(1 > 10)) {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Warning Only."), null, parameterMap, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
    }
    if (__manMapSession.hasProblemsOtherThanWarnings()) {
      throw new OFXAbortedException();
    }

    {
      HashMap<String, Object> parameterMap = null;
      __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Do not return any value here. This is a generator check."), null, parameterMap, new IOFXProblem.Opt[]{}));
      throw new OFXAbortedException();
    }

  }




}
