package org.modellwerkstatt.objectflow.tests.OrderDocument;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;

public class OrderDocTests extends OFXTestSuit {

  @Autowired
  private ODTF __OrderDocumentODTF;
  @Autowired
  private ODS __OrderDocumentODS;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  @Autowired
  private IOFXApplicationFactory appFact;



  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Illustrative case: totalamount is amount of positions", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Totalamount test", 5, new BigDecimal("20.0"), __manMapSession);
    od.setRemark("");

    {
      OrderDocument_OrderDocStatus leftSide = od.getStatus();
      OrderDocument_OrderDocStatus rightSide = OrderDocument_OrderDocStatus.DRAFT;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: totalamount is amount of positions':  od .status == \"OrderDocStatus.Draft\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    od.calcAggregate();

    {
      BigDecimal leftSide = od.getTotalValue().getAmount();
      BigDecimal rightSide = new BigDecimal("100.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: totalamount is amount of positions':  od .totalValue.amount == 100.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 1, name = "Generating some Warnings without interrupting control flow.", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);

    __OrderDocumentODS.checkAndSetEdititing(od, __manMapSession);
    __OrderDocumentODS.order(od, __manMapSession);

    List<IOFXProblem> listOfProblems = __manMapSession.getAndclearProblemState();
    {
      int leftSide = ListSequence.fromList(listOfProblems).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Generating some Warnings without interrupting control flow.':  listOfProblems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(listOfProblems).all((it) -> it.isWarningOnly()))) {
      throw new OFXTestSuitException("'OrderDocTests.Generating some Warnings without interrupting control flow.':  listOfProblems .all          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 2, name = "Illustrative case: Ordering a document changes state", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);

    this.__testmethod_1(__manMapSession, __testSuitHandler);

    {
      BigDecimal leftSide = od.getTotalValue().getAmount();
      BigDecimal rightSide = new BigDecimal("100.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document changes state':  od .totalValue.amount == 100.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    __OrderDocumentODS.order(od, __manMapSession);

    {
      OrderDocument_OrderDocStatus leftSide = od.getStatus();
      OrderDocument_OrderDocStatus rightSide = OrderDocument_OrderDocStatus.ORDERED;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document changes state':  od .status == \"OrderDocStatus.Ordered\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 3, name = "Illustrative case: Ordering a document precondition raises problem", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);



    od.setStatus(OrderDocument_OrderDocStatus.ORDERED);
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __OrderDocumentODS.order(od, __manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();

    {
      int leftSide = ListSequence.fromList(problems).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem':  problems .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(problems).all((it) -> !(it.isWarningOnly())))) {
      throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem':  problems .all          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 4, name = "Illustrative case: Different currencies trigger guard.", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test", 5, new BigDecimal("20.0"), __manMapSession);

    ListSequence.fromList(od.getPositions()).first().setVal(ListSequence.fromList(od.getPositions()).first().getVal().withCurrency("SFR"));

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        od.calcAggregate();

      } catch (OFXShutDownSessionException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("Different currencies are not suppored yet")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("Different currencies are not suppored yet")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception OFXShutDownSessionException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception OFXShutDownSessionException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception 'OFXShutDownSessionException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    // TODO: not yet in session.
    {
      int leftSide = ListSequence.fromList(__manMapSession.getAndclearProblemState()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.':  session .getAndclearProblemState().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 5, name = "Trigger gard with instance and solution desc", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test2", 5, new BigDecimal("20.0"), __manMapSession);

    try {
      od.triggerGuardWithInstanceAndSolution();
      throw new RuntimeException("We should never get here.");

    } catch (OFXShutDownSessionException ex) {

      // no access to session from entity
      {
        int leftSide = ListSequence.fromList(__manMapSession.getAndclearProblemState()).count();
        int rightSide = 0;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  session .getAndclearProblemState().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }

      if (!(isNotEmptyString(ex.getProblem().getProblemDescOrNull()))) {
        throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().getProblemDescOrNull().isNotEmpty          ==>> FALSE !" + "\n");
      }
      if (!(isNotEmptyString(ex.getProblem().getInstanceDescOrNull()))) {
        throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().getInstanceDescOrNull().isNotEmpty          ==>> FALSE !" + "\n");
      }
      {
        boolean leftSide = ex.getProblem().hasForwardedEx();
        boolean rightSide = false;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().hasForwardedEx() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        boolean leftSide = ex.getProblem().isFromGuard();
        boolean rightSide = true;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().isFromGuard() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }

  }
  @OFXTestMethod(id = 6, name = "Trigger gard with forwarded ex", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);

    try {
      od.triggerGuardWithEX();
      throw new RuntimeException("We should never get here.");

    } catch (OFXShutDownSessionException ex) {

      // TODO: not yet in session.
      {
        int leftSide = ListSequence.fromList(__manMapSession.getAndclearProblemState()).count();
        int rightSide = 0;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  session .getAndclearProblemState().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }

      if (!(isEmptyString(ex.getProblem().getProblemDescOrNull()))) {
        throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getProblemDescOrNull().isEmpty          ==>> FALSE !" + "\n");
      }
      if (!(isEmptyString(ex.getProblem().getInstanceDescOrNull()))) {
        throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getInstanceDescOrNull().isEmpty          ==>> FALSE !" + "\n");
      }
      {
        boolean leftSide = ex.getProblem().hasForwardedEx();
        boolean rightSide = true;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().hasForwardedEx() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        boolean leftSide = ex.getProblem().isFromGuard();
        boolean rightSide = true;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().isFromGuard() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        String operand = ex.getProblem().getForwardedEx().getMessage();
        String param0 = "Somne IO Excpetion?";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.contains(param0))) {
          throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getForwardedEx().getMessage().contains(\"Somne IO Excpetion?\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
        }
      }
    }

  }
  @OFXTestMethod(id = 7, name = "Mulltiple messages due to a validation construct.", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __OrderDocumentODS.approve(od, false, __manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();
    {
      int leftSide = ListSequence.fromList(problems).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXProblem operand = ListSequence.fromList(problems).first();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isWarningOnly())) {
        throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .first.isWarningOnly()          ==>> '" + operand + "'.isWarningOnly(" + textRepresentation + ") " + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(problems).first().isFromGuard();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .first.isFromGuard() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(problems).skip(1).all((it) -> !(it.isWarningOnly())))) {
      throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .skip.all          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 8, name = "Two validation blocks lead to the second one triggering immediatelly.", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __OrderDocumentODS.revision(od, "Some Reason here.", __manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();
    {
      int leftSide = ListSequence.fromList(problems).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Check options of problem statement. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __OrderDocumentODS.problemsWithOptions(__manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();
    {
      int leftSide = ListSequence.fromList(problems).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXProblem operand = ListSequence.fromList(problems).getElement(0);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isJobIgnore())) {
        throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isJobIgnore()          ==>> '" + operand + "'.isJobIgnore(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXProblem operand = ListSequence.fromList(problems).getElement(1);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isJobItemAlreadDone())) {
        throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isJobItemAlreadDone()          ==>> '" + operand + "'.isJobItemAlreadDone(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXProblem operand = ListSequence.fromList(problems).getElement(2);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isWarningOnly())) {
        throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isWarningOnly()          ==>> '" + operand + "'.isWarningOnly(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 10, name = "Check fail in shortcut for the problems message. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    OrderDocument od = __OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __OrderDocumentODS.problemsWithOptions(__manMapSession);

      } catch (OFXAbortedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("Job_Item_Alread_Done option")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("Job_Item_Alread_Done option")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception OFXAbortedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", OrderDocTests.class, allIncludedTest, includedTestToRun);
  }
  private static boolean isNotEmptyString(String str) {
    return str != null && str.length() > 0;
  }
  private static boolean isEmptyString(String str) {
    return str == null || str.isEmpty();
  }
}
