package org.modellwerkstatt.objectflow.tests.OrderDocument;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.OFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import jetbrains.mps.references.Reference;
import org.joda.time.LocalDate;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;

public class OrderDocument extends OFXEntity<Integer> {
  public static final int entitySessionUID = OrderDocument.class.hashCode();

  public OrderDocument() {
  }

  public int getSessionObjectKeyStoreID() {
    return entitySessionUID;
  }
  public Integer getIM3Key() {
    return this.id.getValue();
  }
  public Object getKeyProperty() {
    return this.id;
  }


  protected OFXInteger id = new OFXInteger();
  protected OFXString remark = new OFXString(0, 100);
  protected OFXString crtlpath = new OFXString(0, 200);
  protected OFXString personName = new OFXString(0, 100);
  protected OFXLocalDate expectedDate = new OFXLocalDate();
  protected OFXValueObject<MonetaryValue> totalValue = new OFXValueObject<MonetaryValue>();
  protected OFXList<OrderDocumentPos> positions = new OFXList<OrderDocumentPos>();
  protected OFXStatus<OrderDocument_OrderDocStatus> status = new OFXStatus<OrderDocument_OrderDocStatus>(OrderDocument_OrderDocStatus.ON_CREATE);
  protected OFXString goPrblm = new OFXString();
  protected OFXString gePrblm = new OFXString();
  protected OFXString preProblem = new OFXString();
  public int getId() {
    return this.id.getValue();
  }
  private void _setId(int value) {
    if ((_dirty |= this.id.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public int setId(int value) {
    _setId(value);
    return value;
  }
  public Reference<Integer> refToId() {
    return new Reference<Integer>() {
      public Integer get() {
        return getId();
      }
      public void set(Integer value) {
        _setId(value);
      }
    };
  }
  public String getRemark() {
    return this.remark.getValue();
  }
  private void _setRemark(String value) {
    if ((_dirty |= this.remark.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setRemark(String value) {
    _setRemark(value);
    return value;
  }
  public Reference<String> refToRemark() {
    return new Reference<String>() {
      public String get() {
        return getRemark();
      }
      public void set(String value) {
        _setRemark(value);
      }
    };
  }
  public String getCrtlpath() {
    return this.crtlpath.getValue();
  }
  private void _setCrtlpath(String value) {
    if ((_dirty |= this.crtlpath.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setCrtlpath(String value) {
    _setCrtlpath(value);
    return value;
  }
  public Reference<String> refToCrtlpath() {
    return new Reference<String>() {
      public String get() {
        return getCrtlpath();
      }
      public void set(String value) {
        _setCrtlpath(value);
      }
    };
  }
  public String getPersonName() {
    return this.personName.getValue();
  }
  private void _setPersonName(String value) {
    if ((_dirty |= this.personName.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setPersonName(String value) {
    _setPersonName(value);
    return value;
  }
  public Reference<String> refToPersonName() {
    return new Reference<String>() {
      public String get() {
        return getPersonName();
      }
      public void set(String value) {
        _setPersonName(value);
      }
    };
  }
  public LocalDate getExpectedDate() {
    return this.expectedDate.getValue();
  }
  private void _setExpectedDate(LocalDate value) {
    if ((_dirty |= this.expectedDate.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public LocalDate setExpectedDate(LocalDate value) {
    _setExpectedDate(value);
    return value;
  }
  public Reference<LocalDate> refToExpectedDate() {
    return new Reference<LocalDate>() {
      public LocalDate get() {
        return getExpectedDate();
      }
      public void set(LocalDate value) {
        _setExpectedDate(value);
      }
    };
  }
  public MonetaryValue getTotalValue() {
    return this.totalValue.getValue();
  }
  private void _setTotalValue(MonetaryValue value) {
    if ((_dirty |= this.totalValue.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public MonetaryValue setTotalValue(MonetaryValue value) {
    _setTotalValue(value);
    return value;
  }
  public Reference<MonetaryValue> refToTotalValue() {
    return new Reference<MonetaryValue>() {
      public MonetaryValue get() {
        return getTotalValue();
      }
      public void set(MonetaryValue value) {
        _setTotalValue(value);
      }
    };
  }
  public List<OrderDocumentPos> getPositions() {
    return this.positions.getValue();
  }
  private void _setPositions(List<OrderDocumentPos> value) {
    if ((_dirty |= this.positions.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public List<OrderDocumentPos> setPositions(List<OrderDocumentPos> value) {
    _setPositions(value);
    return value;
  }
  public Reference<List<OrderDocumentPos>> refToPositions() {
    return new Reference<List<OrderDocumentPos>>() {
      public List<OrderDocumentPos> get() {
        return getPositions();
      }
      public void set(List<OrderDocumentPos> value) {
        _setPositions(value);
      }
    };
  }
  public OrderDocument_OrderDocStatus getStatus() {
    return this.status.getValue();
  }
  private void _setStatus(OrderDocument_OrderDocStatus value) {
    if ((_dirty |= this.status.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public OrderDocument_OrderDocStatus setStatus(OrderDocument_OrderDocStatus value) {
    _setStatus(value);
    return value;
  }
  public Reference<OrderDocument_OrderDocStatus> refToStatus() {
    return new Reference<OrderDocument_OrderDocStatus>() {
      public OrderDocument_OrderDocStatus get() {
        return getStatus();
      }
      public void set(OrderDocument_OrderDocStatus value) {
        _setStatus(value);
      }
    };
  }
  public String getGoPrblm() {
    return this.goPrblm.getValue();
  }
  private void _setGoPrblm(String value) {
    if ((_dirty |= this.goPrblm.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setGoPrblm(String value) {
    _setGoPrblm(value);
    return value;
  }
  public Reference<String> refToGoPrblm() {
    return new Reference<String>() {
      public String get() {
        return getGoPrblm();
      }
      public void set(String value) {
        _setGoPrblm(value);
      }
    };
  }
  public String getGePrblm() {
    return this.gePrblm.getValue();
  }
  private void _setGePrblm(String value) {
    if ((_dirty |= this.gePrblm.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setGePrblm(String value) {
    _setGePrblm(value);
    return value;
  }
  public Reference<String> refToGePrblm() {
    return new Reference<String>() {
      public String get() {
        return getGePrblm();
      }
      public void set(String value) {
        _setGePrblm(value);
      }
    };
  }
  public String getPreProblem() {
    return this.preProblem.getValue();
  }
  private void _setPreProblem(String value) {
    if ((_dirty |= this.preProblem.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setPreProblem(String value) {
    _setPreProblem(value);
    return value;
  }
  public Reference<String> refToPreProblem() {
    return new Reference<String>() {
      public String get() {
        return getPreProblem();
      }
      public void set(String value) {
        _setPreProblem(value);
      }
    };
  }


  public void calcAggregate() {

    if (!(ListSequence.fromList(getPositions()).select((it) -> it.getVal().getCurrency()).distinct().count() == 1)) {
      throw new OFXShutDownSessionException(new OFXProblem(true, OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG.translate(-1, "Different currencies are not suppored yet. We have %s", "" + ListSequence.fromList(getPositions()).select((it) -> it.getVal().getCurrency()).distinct()), null, null));



    }

    BigDecimal val = ListSequence.fromList(getPositions()).foldLeft(new BigDecimal("0.0"), (BigDecimal s, OrderDocumentPos it) -> s.add(it.getVal().getAmount()));
    setTotalValue(new MonetaryValue(val));
  }
  public void triggerGuardWithInstanceAndSolution() {

    throw new OFXShutDownSessionException(new OFXProblem(true, OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG.translate(-1, "TestGuard with instance and solution"), "" + this, null));
  }
  public void triggerGuardWithEX() {
    try {
      // problem
      throw new Exception("Somne IO Excpetion?");

    } catch (Exception ex) {
      // use ALT-ENTER for options..
      throw new OFXShutDownSessionException(new OFXProblem(true, null, null, ex), ex);
    }

  }
  public void passed(String point) {
    this.setCrtlpath(this.getCrtlpath() + " [" + point + "]");
  }
  public boolean did(String point) {
    String pointName = "[" + point + "]";
    return this.getCrtlpath().contains(pointName);
  }
  public int count(String point) {
    String pointName = "[" + point + "]";
    String st = this.getCrtlpath().replace(pointName, "§");
    return st.length() - st.replace("§", "").length();
  }
  public boolean isCase(String caseString) {
    return this.getRemark().toLowerCase().contains(caseString.toLowerCase());
  }

  public IOFXMetaRange<Integer> getId_META() {
    return this.id;
  }
  public IOFXMetaLength<String> getRemark_META() {
    return this.remark;
  }
  public IOFXMetaLength<String> getCrtlpath_META() {
    return this.crtlpath;
  }
  public IOFXMetaLength<String> getPersonName_META() {
    return this.personName;
  }
  public IOFXMetaRange<LocalDate> getExpectedDate_META() {
    return this.expectedDate;
  }
  public IOFXMetaBasis getTotalValue_META() {
    return this.totalValue;
  }
  public IOFXMetaBasis getPositions_META() {
    return this.positions;
  }
  public IOFXMetaStatus<OrderDocument_OrderDocStatus> getStatus_META() {
    return this.status;
  }
  public IOFXMetaLength<String> getGoPrblm_META() {
    return this.goPrblm;
  }
  public IOFXMetaLength<String> getGePrblm_META() {
    return this.gePrblm;
  }
  public IOFXMetaLength<String> getPreProblem_META() {
    return this.preProblem;
  }



  public void beforeSave() {
    super.beforeSave();
  }

  @Override
  public void rollback() {
    super.rollback();
    this.id.setValue(_BEFORESAVE_KEY);
  }
  public boolean anyOfListDirty() {
    boolean dirty = super.anyOfListDirty();
    dirty |= positions.wasListChanged();
    return dirty;
  }
  public void clearDirtyOnLists() {
    super.clearDirtyOnLists();
    positions.setHashForDirtyChecking();
  }
  @Override
  public String toString() {
    return "OrderDocument " + getKeyProperty();
  }

  public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
    OrderDocument entity = ((OrderDocument) param);
    this.id.load(entity.id, fullRevertNotMerge);
    this.remark.load(entity.remark, fullRevertNotMerge);
    this.crtlpath.load(entity.crtlpath, fullRevertNotMerge);
    this.personName.load(entity.personName, fullRevertNotMerge);
    this.expectedDate.load(entity.expectedDate, fullRevertNotMerge);
    this.totalValue.load(entity.totalValue, fullRevertNotMerge);
    this.positions.load(entity.positions, fullRevertNotMerge);
    this.status.load(entity.status, fullRevertNotMerge);
    this.goPrblm.load(entity.goPrblm, fullRevertNotMerge);
    this.gePrblm.load(entity.gePrblm, fullRevertNotMerge);
    this.preProblem.load(entity.preProblem, fullRevertNotMerge);
    super.load(param, fullRevertNotMerge);
  }
  public IOFXRevertableObject copy() {
    OrderDocument entity = new OrderDocument();
    entity.id = this.id.copy();
    entity.remark = this.remark.copy();
    entity.crtlpath = this.crtlpath.copy();
    entity.personName = this.personName.copy();
    entity.expectedDate = this.expectedDate.copy();
    entity.totalValue = this.totalValue.copy();
    entity.positions = this.positions.copy();
    entity.status = this.status.copy();
    entity.goPrblm = this.goPrblm.copy();
    entity.gePrblm = this.gePrblm.copy();
    entity.preProblem = this.preProblem.copy();
    super.entityInfraInto(entity);
    return entity;
  }
}
