package org.modellwerkstatt.objectflow.tests.ProdConsJob;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.RunProducerMsg;
import org.modellwerkstatt.objectflow.batchjob.ShutdownWhenInboxEmptyMsg;
import org.modellwerkstatt.objectflow.batchjob.ConsWorkDoneMsg;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.batchjob.ConsumerFinallyDownMsg;
import org.modellwerkstatt.objectflow.batchjob.ShutdownMsg;
import org.modellwerkstatt.objectflow.batchjob.MultiCronJobDesc;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.batchjob.OFXExceptionStrategy;

public class Consumer_Producer extends OFXTestSuit {

  @Autowired
  private InfraFactory __ProdConsJobInfraFactory;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.ProdConsJob.Consumer_Producer_Rainy")
  private Consumer_Producer_Rainy ___inst_Consumer_Producer_Rainy;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Start and shutdown Producer with 1 consumer", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(20, new int[]{}, 0, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(1);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    pCrtl.receive(new ShutdownWhenInboxEmptyMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 20;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 1 consumer': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 1 consumer':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 1 consumer':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 1 consumer': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(TestUtil.noMsgsRemaining(pCrtl))) {
      throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 1 consumer': TestUtil.noMsgsRemaining( pCrtl )          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 1, name = "Start and shutdown Producer with 5 consumer, balance work nicely.", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(20, new int[]{}, 0, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(5);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    pCrtl.receive(new ShutdownWhenInboxEmptyMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 20;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 5 consumer, balance work nicely.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 5 consumer, balance work nicely.':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 5 consumer, balance work nicely.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 5 consumer, balance work nicely.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(TestUtil.noMsgsRemaining(pCrtl))) {
      throw new OFXTestSuitException("'Consumer Producer.Start and shutdown Producer with 5 consumer, balance work nicely.': TestUtil.noMsgsRemaining( pCrtl )          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 2, name = "Start and refill inbox twice with one consumer.", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(10, new int[]{}, 2, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(1);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 30;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one consumer.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 30          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one consumer.':  tCrtl .runCompledtedResched == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one consumer.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one consumer.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(TestUtil.noMsgsRemaining(pCrtl))) {
      throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one consumer.': TestUtil.noMsgsRemaining( pCrtl )          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 3, name = "Start and refill inbox twice with one 5 consumer and delay.", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(10, new int[]{100}, 2, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(5);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 30;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and delay.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 30          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and delay.':  tCrtl .runCompledtedResched == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and delay.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and delay.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(TestUtil.noMsgsRemaining(pCrtl))) {
      throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and delay.': TestUtil.noMsgsRemaining( pCrtl )          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 4, name = "Start and refill inbox twice with one 5 consumer and different delays.", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(10, new int[]{10, 50, 100, 500, 1000}, 1, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(5);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 20;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and different delays.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and different delays.':  tCrtl .runCompledtedResched == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and different delays.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and different delays.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(TestUtil.noMsgsRemaining(pCrtl))) {
      throw new OFXTestSuitException("'Consumer Producer.Start and refill inbox twice with one 5 consumer and different delays.': TestUtil.noMsgsRemaining( pCrtl )          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 5, name = "Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(6, new int[]{40, 50, TestUtil.THE_LOOP_TIME, 40, 50, 40}, 0, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(3);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    TestUtil.wait(500);
    pCrtl.receive(new ShutdownMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numMsgsRemaining(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Consumer should take over work if one consumer is looping/waiting. BUT shutdown needed.': TestUtil.numMsgsRemaining( pCrtl , ConsumerFinallyDownMsg.class) == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Tear down inbox when two long waiting consumers have done their work.", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(4, new int[]{2000, 2000}, 0, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(2);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    TestUtil.start();
    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    TestUtil.wait(1000);
    pCrtl.receive(new ShutdownMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numMsgsRemaining(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.': TestUtil.numMsgsRemaining( pCrtl , ConsWorkDoneMsg.class) == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numMsgsRemaining(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.': TestUtil.numMsgsRemaining( pCrtl , ConsumerFinallyDownMsg.class) == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      long leftSide = TestUtil.stopInSecs();
      int rightSide = 4;
      if (!(leftSide < rightSide)) {
        throw new OFXTestSuitException("'Consumer Producer.Tear down inbox when two long waiting consumers have done their work.': TestUtil.stopInSecs() < 4          ==>>" + leftSide + " <" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 7, name = "Two RunProducer instructions should lead to a warning only.", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(6, new int[]{}, 0, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(2);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    pCrtl.receive(new ShutdownWhenInboxEmptyMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 6;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Two RunProducer instructions should lead to a warning only.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 6          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Two RunProducer instructions should lead to a warning only.':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Two RunProducer instructions should lead to a warning only.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Two RunProducer instructions should lead to a warning only.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 8, name = "PairCrtl does not issue a Reschedule on a manual run.", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ContinousTestDummyTimerCrtl tCrtl = __ProdConsJobInfraFactory.CreateSingleProducerWithThreadSleep(6, new int[]{}, 5, __manMapSession);



    OFXPCPairController pCrtl = tCrtl.controllerID1;
    pCrtl.setupPairController(2);

    Thread prodThread = new Thread(pCrtl);
    prodThread.start();

    pCrtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MANUAL));
    pCrtl.receive(new ShutdownWhenInboxEmptyMsg());
    TestUtil.joinThread(prodThread);

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsWorkDoneMsg.class);
      int rightSide = 6;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.PairCrtl does not issue a Reschedule on a manual run.': TestUtil.numOfMsgs( pCrtl , ConsWorkDoneMsg.class) == 6          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = tCrtl.runCompledtedResched;
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.PairCrtl does not issue a Reschedule on a manual run.':  tCrtl .runCompledtedResched == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = tCrtl.shutdownExecuted;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.PairCrtl does not issue a Reschedule on a manual run.':  tCrtl .shutdownExecuted == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numOfMsgs(pCrtl, ConsumerFinallyDownMsg.class);
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.PairCrtl does not issue a Reschedule on a manual run.': TestUtil.numOfMsgs( pCrtl , ConsumerFinallyDownMsg.class) == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Check MultiCron delayMode without cron window.", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.setDelayInMS(1000);

    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode without cron window.':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    DateTime next = m.nextEarlyiestRunMS(0);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(1100);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode without cron window.':  next .isBefore( new .plusMillis(1100))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(900);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode without cron window.':  next .isAfter( new .plusMillis(900))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 10, name = "Check MultiCron delayMode with cron window.", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("* * 23 * * *");
    m.setDelayInMS(1000);

    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with cron window.':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    DateTime next = m.nextEarlyiestRunMS(0);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(22);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with cron window.':  next .isAfter( new .withHourOfDay(22))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(23);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with cron window.':  next .isBefore( new .withHourOfDay(23))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 11, name = "Check MultiCron delayMode with multi in cron window.", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("* * 23 * * *");
    m.addCron("* 0 22 * * *");
    m.setDelayInMS(1000);

    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with multi in cron window.':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    DateTime next = m.nextEarlyiestRunMS(0);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(21);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with multi in cron window.':  next .isAfter( new .withHourOfDay(21))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(22).withMinuteOfHour(5);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode with multi in cron window.':  next .isBefore( new .withHourOfDay(22).withMinuteOfHour(5))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 12, name = "Check MultiCron delayMode issue a delay NOT in the maintainance window", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("* * 7-20 * * *");
    m.setDelayInMS(1000);

    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay NOT in the maintainance window':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    DateTime next = m.nextEarlyiestRunMS(1000 * 60 * 60);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(1000 * 60 * 60 - 1000);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay NOT in the maintainance window':  next .isAfter( new .plusMillis(1000 * 60 * 60 - 1000))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(1000 * 60 * 60 + 1000);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay NOT in the maintainance window':  next .isBefore( new .plusMillis(1000 * 60 * 60 + 1000))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 13, name = "Check MultiCron delayMode issue a delay not in the maintainance window", debug = false, enabled = true, runAt = "")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("* * 22 * * *");
    m.setDelayInMS(1000);

    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay not in the maintainance window':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    DateTime next = m.nextEarlyiestRunMS(1000 * 60 * 60);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(21);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay not in the maintainance window':  next .isAfter( new .withHourOfDay(21))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(23);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron delayMode issue a delay not in the maintainance window':  next .isBefore( new .withHourOfDay(23))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 14, name = "Check MultiCron specific-time, earlier first .. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("0 * 23 * * *");
    m.addCron("0 * 22 * * *");

    // allways true
    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, earlier first .. ':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    DateTime next = m.nextEarlyiestRunMS(0);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(21);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, earlier first .. ':  next .isAfter( new .withHourOfDay(21))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().withHourOfDay(23);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, earlier first .. ':  next .isBefore( new .withHourOfDay(23))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 15, name = "Check MultiCron specific-time, issue a delay... ", debug = false, enabled = true, runAt = "")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    MultiCronJobDesc m = new MultiCronJobDesc(0, "T");
    m.addCron("0 * 23 * * *");
    m.addCron("0 * 22 * * *");

    // allways true
    {
      boolean leftSide = m.canRunAccoordingToCronWindowInDelayMode(new DateTime());
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, issue a delay... ':  m .canRunAccoordingToCronWindowInDelayMode( new ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    DateTime next = m.nextEarlyiestRunMS(1000 * 60 * 60);
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(1000 * 60 * 60 - 1000);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isAfter(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, issue a delay... ':  next .isAfter( new .plusMillis(1000 * 60 * 60 - 1000))          ==>> '" + operand + "'.isAfter(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = next;
      DateTime param0 = new DateTime().plusMillis(1000 * 60 * 60 + 1000);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.isBefore(param0))) {
        throw new OFXTestSuitException("'Consumer Producer.Check MultiCron specific-time, issue a delay... ':  next .isBefore( new .plusMillis(1000 * 60 * 60 + 1000))          ==>> '" + operand + "'.isBefore(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 16, name = "Run independent crons in delay mode. Both sould process", debug = false, enabled = true, runAt = "")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OFXExceptionStrategy start = __ProdConsJobInfraFactory.createExceptionStrategy(new OFXExceptionStrategy.Strategy(200, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), new OFXExceptionStrategy.Strategy(1000, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), __manMapSession);
    DT dt = __ProdConsJobInfraFactory.createCronMasterControllerWithTwoIndependentPairs(start, new int[][]{{1, 2, 3, 4, 5, 6}}, new int[]{}, __manMapSession);



    dt.crtl.initialProducerRuns();

    TestUtil.wait(4000);
    dt.crtl.shuttingDown(null);
    TestUtil.joinThread(dt.t2);
    TestUtil.joinThread(dt.t1);

    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(0), ConsWorkDoneMsg.class);
      int rightSide = 12;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'Consumer Producer.Run independent crons in delay mode. Both sould process': TestUtil.numOfMsgs( dt .crtl.getPair(0), ConsWorkDoneMsg.class) >= 12          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(1), ConsWorkDoneMsg.class);
      int rightSide = 12;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'Consumer Producer.Run independent crons in delay mode. Both sould process': TestUtil.numOfMsgs( dt .crtl.getPair(1), ConsWorkDoneMsg.class) >= 12          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numMsgsRemaining(dt.crtl.getPair(0), ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run independent crons in delay mode. Both sould process': TestUtil.numMsgsRemaining( dt .crtl.getPair(0), ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numMsgsRemaining(dt.crtl.getPair(1), ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run independent crons in delay mode. Both sould process': TestUtil.numMsgsRemaining( dt .crtl.getPair(1), ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 17, name = "Run dependent crons in delay mode. Both should process.", debug = false, enabled = true, runAt = "")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OFXExceptionStrategy start = __ProdConsJobInfraFactory.createExceptionStrategy(new OFXExceptionStrategy.Strategy(200, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), new OFXExceptionStrategy.Strategy(1000, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), __manMapSession);
    DT dt = __ProdConsJobInfraFactory.createCronMasterControllerWithTwoIndependentPairs(start, new int[][]{{1, 2, 3, 4, 5, 6}}, new int[]{TestUtil.CRONTMR_DEPENDENTMODE}, __manMapSession);



    dt.crtl.initialProducerRuns();

    TestUtil.wait(5000);
    dt.crtl.shuttingDown(null);
    TestUtil.joinThread(dt.t2);
    TestUtil.joinThread(dt.t1);

    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(0), ConsWorkDoneMsg.class);
      int rightSide = 12;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process.': TestUtil.numOfMsgs( dt .crtl.getPair(0), ConsWorkDoneMsg.class) >= 12          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(1), ConsWorkDoneMsg.class);
      int rightSide = 12;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process.': TestUtil.numOfMsgs( dt .crtl.getPair(1), ConsWorkDoneMsg.class) >= 12          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    {
      int leftSide = TestUtil.numMsgsRemaining(dt.crtl.getPair(0), ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process.': TestUtil.numMsgsRemaining( dt .crtl.getPair(0), ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numMsgsRemaining(dt.crtl.getPair(1), ConsumerFinallyDownMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process.': TestUtil.numMsgsRemaining( dt .crtl.getPair(1), ConsumerFinallyDownMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 18, name = "Run dependent crons in delay mode. Both should process (no consumer setup).", debug = false, enabled = true, runAt = "")
  public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    OFXExceptionStrategy start = __ProdConsJobInfraFactory.createExceptionStrategy(new OFXExceptionStrategy.Strategy(200, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), new OFXExceptionStrategy.Strategy(1000, OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION), __manMapSession);
    DT dt = __ProdConsJobInfraFactory.createCronMasterControllerWithTwoPairs_withoutConsumers_prodOnly(start, new int[][]{{1, 2, 3, 4, 5, 6}}, new int[]{TestUtil.CRONTMR_DEPENDENTMODE}, __manMapSession);



    dt.crtl.initialProducerRuns();

    TestUtil.wait(500);
    dt.crtl.shuttingDown(null);
    TestUtil.joinThread(dt.t2);
    TestUtil.joinThread(dt.t1);

    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(0), ConsWorkDoneMsg.class);
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process (no consumer setup).': TestUtil.numOfMsgs( dt .crtl.getPair(0), ConsWorkDoneMsg.class) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(1), ConsWorkDoneMsg.class);
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process (no consumer setup).': TestUtil.numOfMsgs( dt .crtl.getPair(1), ConsWorkDoneMsg.class) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(0), RunProducerMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process (no consumer setup).': TestUtil.numOfMsgs( dt .crtl.getPair(0), RunProducerMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = TestUtil.numOfMsgs(dt.crtl.getPair(1), RunProducerMsg.class);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Consumer Producer.Run dependent crons in delay mode. Both should process (no consumer setup).': TestUtil.numOfMsgs( dt .crtl.getPair(1), RunProducerMsg.class) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.ProdConsJob.Consumer_Producer_Rainy"};
    String[] includedTestToRun = new String[]{"org.modellwerkstatt.objectflow.tests.ProdConsJob.Consumer_Producer_Rainy"};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Consumer_Producer.class, allIncludedTest, includedTestToRun);
  }
}
