package org.modellwerkstatt.objectflow.tests.ProdConsJob;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.RunProducerMsg;
import org.modellwerkstatt.objectflow.batchjob.ShutdownWhenInboxEmptyMsg;
import org.modellwerkstatt.objectflow.batchjob.SchedInfo;
import org.modellwerkstatt.objectflow.batchjob.WakeupPairCrtlMsg;
import org.joda.time.DateTime;

public class ContinousTestDummyTimerCrtl implements IOFXTimerMasterController {
  public int runCompledtedResched = 0;
  public int notCompletedDueToEX_ProducerResched = 0;
  public int notCompletedDueToEX_ConsumerResched = 0;
  public int notCompletedOutOfCron_ProducerResched = 0;
  public int notCompletedOutOfCron_ConsumerResched = 0;
  public int refillsTotal = 0;
  public boolean outOfCronWindowRetVal = false;
  public boolean shutdownExecuted = false;

  public boolean sendUnexpectedRunProducer = false;
  public JobProperties properties;

  public List<CallReceived> calls = ListSequence.fromList(new ArrayList<CallReceived>());

  public OFXPCPairController controllerID1;

  public ContinousTestDummyTimerCrtl(int refs, JobProperties props) {
    refillsTotal = refs;
    properties = props;
  }

  @Override
  public JobProperties getJobProperties() {
    return properties;
  }
  public String getSchedSetting(OFXPCPairController pair) {
    return "null";
  }
  public void runCompletedResched(OFXPCPairController crtl) {
    ListSequence.fromList(calls).addElement(new CallReceived(CallReceived.CT.RUN_DONE, -1, false, true));
    runCompledtedResched++;
    if (refillsTotal > 0) {
      refillsTotal--;
      crtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));

    } else {
      crtl.receive(new ShutdownWhenInboxEmptyMsg());
    }
  }
  public SchedInfo runNotCompletedDueEXResched(OFXPCPairController crtl, int minWaitingTimeInMS, boolean prodRun, boolean inboxEmpty) {
    ListSequence.fromList(calls).addElement(new CallReceived(CallReceived.CT.NOT_DUETOEX, minWaitingTimeInMS, prodRun, inboxEmpty));

    boolean reRunProducer = prodRun || inboxEmpty || sendUnexpectedRunProducer;

    if (prodRun) {
      notCompletedDueToEX_ProducerResched++;

    } else {
      notCompletedDueToEX_ConsumerResched++;

    }

    if (reRunProducer && refillsTotal > 0) {
      refillsTotal--;
      crtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));

    } else if (!(prodRun) && !(inboxEmpty)) {
      // consumer run.
      crtl.receive(new WakeupPairCrtlMsg(-1));

    } else {
      crtl.receive(new ShutdownWhenInboxEmptyMsg());

    }
    return new SchedInfo("test sched info", new DateTime());
  }
  public SchedInfo runNotCompletedOutOfCronWindowResched(OFXPCPairController crtl, boolean prodRun) {
    ListSequence.fromList(calls).addElement(new CallReceived(CallReceived.CT.NOT_OUTOFCRON, -1, prodRun, false));

    if (prodRun) {
      notCompletedOutOfCron_ProducerResched++;
    } else {
      notCompletedOutOfCron_ConsumerResched++;
    }

    if (refillsTotal > 0) {
      refillsTotal--;
      crtl.receive(new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    } else {
      crtl.receive(new ShutdownWhenInboxEmptyMsg());
    }
    return new SchedInfo("test sched info", new DateTime());
  }
  public boolean outOfCronWindow(OFXPCPairController crtl) {
    return outOfCronWindowRetVal;
  }
  public boolean enableTimer(boolean enabled) {
    return true;
  }
  public void shuttingDown(OFXPCPairController crtl) {
    shutdownExecuted = true;
  }
  public String getFullStatusReport(OFXPCPairController crtl) {
    return "";
  }

  public int getCurrentTimerVersion() {
    throw new RuntimeException("This can not happen - not implemented.");
  }
  public int clearJobTimerState() {
    throw new RuntimeException("This can not happen - not implemented.");
  }

  public static class CallReceived {
    public boolean prodRun;
    public int delayTimeinMS;
    public boolean wasInboxEmpty;

    public enum CT {
      RUN_DONE(),
      NOT_DUETOEX(),
      NOT_OUTOFCRON()
    }
    public CT callType;


    public CallReceived(CT ct, int delMs, boolean isFromProd, boolean inboxEmpty) {
      callType = ct;
      delayTimeinMS = delMs;
      prodRun = isFromProd;
      wasInboxEmpty = inboxEmpty;
    }
    public boolean wasProdRun() {
      return prodRun;
    }
    public boolean wasInboxEmpty() {
      return wasInboxEmpty;
    }
    public boolean isRunDone() {
      return callType == CT.RUN_DONE;
    }
    public boolean isNotRunDueEX() {
      return callType == CT.NOT_DUETOEX;
    }
    public boolean isNotRunDueWin() {
      return callType == CT.NOT_OUTOFCRON;
    }

  }


}
