package org.modellwerkstatt.objectflow.tests.ProdConsJob;

/*Generated by MPS */

import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.Message;
import java.util.List;
import java.util.ArrayList;
import java.util.Date;

public class TestUtil {
  public static final int THE_LOOP_TIME = 1000000;

  public static final int ON_KEY_2_RTEX = 1;
  public static final int ON_KEY_3_ILSTATEEX = 2;
  public static final int PRODUCER_RTEX_ON_KEY_2 = 3;
  public static final int ON_KEY_2_EXITCONSUMER = 4;
  public static final int ON_KEY_3_EXITCONSUMER = 5;
  public static final int CRONTMR_DEPENDENTMODE = 4711;



  private static DateTime lastStart;


  public static boolean configVal(int[] cfg, int val) {
    for (int i = 0; i < cfg.length; i++) {
      if (cfg[i] == val) {
        return true;
      }
    }
    return false;
  }
  public static void start() {
    lastStart = new DateTime();
  }
  public static long stopInSecs() {
    DateTime stop = new DateTime();
    long diffMillis = stop.getMillis() - lastStart.getMillis();
    return diffMillis / 1000;
  }


  public static void joinThread(Thread t) {
    try {

      t.join();

    } catch (InterruptedException ex) {
      throw new RuntimeException(ex);
    }
  }
  public static void wait(int milllis) {
    try {
      Thread.sleep(milllis);
    } catch (InterruptedException ex) {
      throw new RuntimeException(ex);
    }
  }
  public static int numOfMsgs(OFXPCPairController prod, Class cls) {
    int count = 0;

    for (Message msg : ((List<Message>) prod.dbg_getProcessedMessages())) {
      if (cls.isAssignableFrom(msg.getClass())) {
        count++;
      }
    }
    return count;
  }
  public static int numOfMsgs(OFXPCPairController prod, Class cls, int sender) {
    int count = 0;

    for (Message msg : ((List<Message>) prod.dbg_getProcessedMessages())) {
      if (msg.getClass() == cls && msg.getConsumerSenderId() == sender) {
        count++;
      }
    }
    return count;
  }
  public static boolean noMsgsRemaining(OFXPCPairController prod) {
    return prod.dbg_getRemainingMessages().size() == 0;
  }
  public static int numMsgsRemaining(OFXPCPairController prod, Class cls) {
    int count = 0;

    for (Message msg : ((List<Message>) prod.dbg_getRemainingMessages())) {
      if (cls.isAssignableFrom(msg.getClass())) {
        count++;
      }
    }
    return count;
  }

  public static ArrayList<Integer> buildIntegerArrayList(Integer... elem) {
    ArrayList<Integer> a = new ArrayList<Integer>();
    for (Integer e : elem) {
      a.add(e);
    }
    return a;
  }

  public static void waitForModuloSec(int secs) {
    while ((new Date().getSeconds() % secs) != (secs - 1)) {
      try {
        Thread.sleep(300);
      } catch (InterruptedException ex) {
      }
    }
  }

}
