package org.modellwerkstatt.objectflow.tests.manmap.Domain;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import org.modellwerkstatt.objectflow.runtime.IOFXMeta4Object;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import jetbrains.mps.references.Reference;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class AccountKey implements IOFXValueObject<AccountKey>, IOFXMeta4Object, IOFXRevertableObject {

  protected boolean _enabled = true;
  public void setEnabled(boolean value) {
    this._enabled = value;
  }
  public boolean getEnabled() {
    return this._enabled;
  }
  public AccountKey _META() {
    return this;
  }



  protected OFXInteger number = new OFXInteger();
  protected OFXString mandant = new OFXString();
  protected OFXStatus<AccountKey_Active> active = new OFXStatus<AccountKey_Active>(AccountKey_Active.ON_CREATE);
  public int getNumber() {
    return this.number.getValue();
  }
  private void _setNumber(int value) {
    if (this.number.setValue(value)) {
    }
  }
  public int setNumber(int value) {
    _setNumber(value);
    return value;
  }
  public Reference<Integer> refToNumber() {
    return new Reference<Integer>() {
      public Integer get() {
        return getNumber();
      }
      public void set(Integer value) {
        _setNumber(value);
      }
    };
  }
  public String getMandant() {
    return this.mandant.getValue();
  }
  private void _setMandant(String value) {
    if (this.mandant.setValue(value)) {
    }
  }
  public String setMandant(String value) {
    _setMandant(value);
    return value;
  }
  public Reference<String> refToMandant() {
    return new Reference<String>() {
      public String get() {
        return getMandant();
      }
      public void set(String value) {
        _setMandant(value);
      }
    };
  }
  public AccountKey_Active getActive() {
    return this.active.getValue();
  }
  private void _setActive(AccountKey_Active value) {
    if (this.active.setValue(value)) {
    }
  }
  public AccountKey_Active setActive(AccountKey_Active value) {
    _setActive(value);
    return value;
  }
  public Reference<AccountKey_Active> refToActive() {
    return new Reference<AccountKey_Active>() {
      public AccountKey_Active get() {
        return getActive();
      }
      public void set(AccountKey_Active value) {
        _setActive(value);
      }
    };
  }

  public AccountKey() {
  }
  public AccountKey(int account, String mandant, AccountKey_Active active) {
    this.setNumber(account);
    this.setMandant(mandant);
    this.setActive(active);
  }
  public AccountKey withNumber(int k) {
    return new AccountKey(k, this.getMandant(), this.getActive());
  }
  public AccountKey withMandant(String k) {
    return new AccountKey(this.getNumber(), k, this.getActive());
  }
  @Override
  public String toString() {
    return "Konto (" + this.getNumber() + " / " + this.getMandant() + " / " + this.getActive() + ")";
  }
  public AccountKey withActive(AccountKey_Active val) {
    return new AccountKey(this.getNumber(), this.getMandant(), val);
  }
  public IOFXMetaRange<Integer> getNumber_META() {
    return this.number;
  }
  public IOFXMetaLength<String> getMandant_META() {
    return this.mandant;
  }
  public IOFXMetaStatus<AccountKey_Active> getActive_META() {
    return this.active;
  }

  public boolean isNullKey() {
    boolean isNullKey = true;
    isNullKey &= this.number.getValue() <= 0;
    isNullKey &= (this.mandant.getValue() == null || this.mandant.getValue().equals(""));
    isNullKey &= (this.active.getValue() == null);
    return isNullKey;
  }

  public AccountKey createNullKey() {
    AccountKey nullKey = new AccountKey();
    nullKey.number.setValue(0);
    nullKey.mandant.setValue("");
    nullKey.active.setValue(null);
    return nullKey;
  }

  @Override
  public boolean equals(Object object) {
    if (this == object) {
      return true;
    }

    if (!(object instanceof AccountKey)) {
      return false;
    }
    AccountKey that = (AccountKey) object;
    boolean result = true;

    result &= this.number.getValue() == that.number.getValue();
    result &= SaveObjectComperator.equals(this.mandant.getValue(), that.mandant.getValue());
    result &= SaveObjectComperator.equals(this.active.getValue(), that.active.getValue());
    return result;
  }
  @Override
  public int hashCode() {
    int result = 17;
    if (((Object) this.mandant.getValue()) != null) {
      result = 37 * result + ((Object) this.mandant.getValue()).hashCode();
    } else {
      // hashcode of null is 0, then multiply result.
      result = 37 * result;
    }
    if (((Object) this.number.getValue()) != null) {
      result = 37 * result + ((Object) this.number.getValue()).hashCode();
    } else {
      // hashcode of null is 0, then multiply result.
      result = 37 * result;
    }
    if (((Object) this.active.getValue()) != null) {
      result = 37 * result + ((Object) this.active.getValue()).hashCode();
    } else {
      // hashcode of null is 0, then multiply result.
      result = 37 * result;
    }

    return result;
  }

  public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
    AccountKey val = ((AccountKey) param);
    // this does not correspond to the immutable pattern, but we want to
    // revert the last step? Does that lead to problems? > in collection! but collections are not allowed for vO
    this.number.load(val.number, fullRevertNotMerge);
    this.mandant.load(val.mandant, fullRevertNotMerge);
    this.active.load(val.active, fullRevertNotMerge);
    if (fullRevertNotMerge) {
      this._enabled = val._enabled;
    }
  }

  public AccountKey copy() {
    // just to be safe, we could also expose the current valueObject,
    // since it is defined as imutable
    AccountKey valueObject = new AccountKey();
    valueObject.number = this.number.copy();
    valueObject.mandant = this.mandant.copy();
    valueObject.active = this.active.copy();
    valueObject._enabled = this._enabled;
    return valueObject;
  }
}
