package org.modellwerkstatt.objectflow.tests.manmap.Domain;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

public class AccountKey_Active implements IOFXMetaStatus.IOFXStatusElement<AccountKey_Active>, Comparable<AccountKey_Active> {
  public static final AccountKey_Active ON = new AccountKey_Active("on", "1", "On", "ON", null, 1);
  public static final AccountKey_Active OFF = new AccountKey_Active("off", "0", "Off", "OFF", null, 2);

  public static final AccountKey_Active ON_CREATE = ON;
  public static final AccountKey_Active[] ALL_ELEMENTS = new AccountKey_Active[]{ON, OFF};

  public static final String OPTIONAL_TEXT = null;

  private String dbValue;
  private String idName;
  private String shortName;
  private String longName;
  private String color;
  private int ordinal;


  public AccountKey_Active(String id, String dbval, String shortN, String longN, String col, int ord) {
    idName = id;
    dbValue = dbval;
    shortName = shortN;
    longName = longN;
    color = col;
    ordinal = ord;
  }

  public String getDbValue() {
    return dbValue;
  }
  public String getShortDesc() {
    return shortName;
  }
  public String getLongDesc() {
    return longName;
  }
  public String getColor() {
    return color;
  }
  public int getOrdinal() {
    return ordinal;
  }
  public boolean hasColor() {
    return color != null && !(color.trim().equals(""));
  }

  @Override
  public String toString() {
    return "Active " + idName;
  }
  public static String asStringForManmap(AccountKey_Active dcl) {
    if (dcl == null) {
      return null;
    }
    return dcl.getDbValue();
  }

  @Override
  public boolean equals(Object object) {
    if (object != null && !(object instanceof AccountKey_Active)) {
      throw new RuntimeException("You can not compare " + AccountKey_Active.class.getName() + " with obj '" + object + "'.");
    }
    return super.equals(object);
  }

  public static AccountKey_Active fromString(String dbValue) {
    if (dbValue == null || "".equals(dbValue.trim())) {
      return null;
    }

    if (ON.getDbValue().equals(dbValue)) {
      return ON;
    }
    if (OFF.getDbValue().equals(dbValue)) {
      return OFF;
    }

    throw new RuntimeException("Unknown status '" + dbValue + "' on db for status " + AccountKey_Active.class.getName() + ". Use ALLOW_NULL_PERSISTANCE / WHEN_UNDEFINED_WL or WHEN_NULL_WL.");
  }


  @Override
  public int compareTo(AccountKey_Active object) {
    return this.idName.compareTo(object.idName);
  }
  public AccountKey_Active[] getAllStatusElements() {
    return ALL_ELEMENTS;
  }
  public static AccountKey_Active[] getAllElements() {
    return ALL_ELEMENTS;
  }

}
