package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SessionLess;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoiceArchiv;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import java.util.List;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;

public class AlternativeTables extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private SessionLess __DomainSessionLess;
  @Autowired
  private RepoInvoiceArchiv __DomainRepoInvoiceArchiv;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Save and Reload on Archive", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invNotSaved = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive':  invNotSaved .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(invNotSaved, true, sess.value)), sess.value, __manMapSession);

    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive':  invNotSaved .id != 0          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice agg = __DomainRepoInvoiceArchiv.checkoutInvoiceById(invNotSaved.getId(), true, sess.value);

    {
      int leftSide = ListSequence.fromList(agg.getPositions()).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive':  agg .positions.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = agg.getName();
      String param0 = invNotSaved.getName();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'AlternativeTables.Save and Reload on Archive':  agg .name.equals( invNotSaved .name)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invNotSaved = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest0A", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!':  invNotSaved .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(invNotSaved, true, sess.value)), sess.value, __manMapSession);


    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!':  invNotSaved .id != 0          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice agg = __DomainRepoInvoiceArchiv.checkoutInvoiceById(invNotSaved.getId(), true, sess.value);

    {
      int leftSide = ListSequence.fromList(agg.getPositions()).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!':  agg .positions.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = agg.getName();
      String param0 = invNotSaved.getName();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!':  agg .name.equals( invNotSaved .name)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    // double checkout of entity with same key !! independent if taken from archive or not. 
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice agg2 = __DomainRepoInvoiceArchiv.checkoutInvoiceById(invNotSaved.getId(), false, sess.value);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'AlternativeTables.!!! Save and Reload of Entity INDEPENDENT if taken from arch or not from arch !!!!': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }



  }
  @OFXTestMethod(id = 2, name = "Save on archive and Reload on orig not available.", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invNotSaved = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest0B", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.':  invNotSaved .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(invNotSaved, true, sess.value)), sess.value, __manMapSession);

    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.':  invNotSaved .id != 0          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    // not on real table .. 
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoiceArchiv.checkoutInvoiceById(invNotSaved.getId(), false, sess.value);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'AlternativeTables.Save on archive and Reload on orig not available.': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 3, name = "Save on archiv, not found on real", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invNotSaved = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest2", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));
    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save on archiv, not found on real':  invNotSaved .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save on archiv, not found on real': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }
    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(invNotSaved, true, sess.value)), sess.value, __manMapSession);


    {
      int leftSide = invNotSaved.getId();
      int rightSide = 0;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Save on archiv, not found on real':  invNotSaved .id != 0          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(invNotSaved.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Save on archiv, not found on real': !( invNotSaved .positions.any)          ==>> FALSE !" + "\n");
    }

    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<Invoice> allInvoices = __DomainRepoInvoice.findAllInvoices(sess.value);
    if (!(!(ListSequence.fromList(allInvoices).any((it) -> it.getId() == invNotSaved.getId())))) {
      throw new OFXTestSuitException("'AlternativeTables.Save on archiv, not found on real': !( allInvoices .any)          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 4, name = "Query on arch invoice table with ReadOnly and full join.", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice newInvForArch = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest3", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));

    List<Invoice> archInvoices = __DomainRepoInvoiceArchiv.findAllInvoices(true, sess.value);
    int numOfInvoicesBefore = ListSequence.fromList(archInvoices).count();

    {
      int leftSide = newInvForArch.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Query on arch invoice table with ReadOnly and full join.':  newInvForArch .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(newInvForArch.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Query on arch invoice table with ReadOnly and full join.': !( newInvForArch .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(newInvForArch, true, sess.value)), sess.value, __manMapSession);



    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    List<Invoice> allInvoices = __DomainRepoInvoiceArchiv.findAllInvoices(true, sess.value);

    {
      int leftSide = ListSequence.fromList(allInvoices).count();
      int rightSide = numOfInvoicesBefore + 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Query on arch invoice table with ReadOnly and full join.':  allInvoices .size ==  numOfInvoicesBefore  + 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "Query on arch invoicepos table with ReadOnly and full join the invoice.", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice newInvForArch = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest4", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));

    List<InvoicePosition> archPos = __DomainRepoInvoiceArchiv.findAllInvoicesPosReverse(true, sess.value);
    int numBefore = ListSequence.fromList(archPos).count();

    {
      int leftSide = newInvForArch.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Query on arch invoicepos table with ReadOnly and full join the invoice.':  newInvForArch .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(newInvForArch.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Query on arch invoicepos table with ReadOnly and full join the invoice.': !( newInvForArch .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(newInvForArch, true, sess.value)), sess.value, __manMapSession);



    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    List<InvoicePosition> archPosAfter = __DomainRepoInvoiceArchiv.findAllInvoicesPosReverse(true, sess.value);
    int numAfter = ListSequence.fromList(archPosAfter).count();

    {
      int leftSide = numAfter;
      int rightSide = numBefore + 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Query on arch invoicepos table with ReadOnly and full join the invoice.':  numAfter  ==  numBefore  + 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(archPosAfter).any((it) -> it.getInvoiceKEY() != it.getInvoice().getId() && it.getInvoiceKEY() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Query on arch invoicepos table with ReadOnly and full join the invoice.': !( archPosAfter .any)          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 6, name = "Create and delete an Invoice on arch table", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice newInvForArch = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("archTest4", __manMapSession);


    final Wrappers._T<IOFXSession> sess = new Wrappers._T<IOFXSession>(__localApplicationFactory.createNewSession(__userEnvironment, __userServices));

    List<Invoice> archInvoices = __DomainRepoInvoiceArchiv.findAllInvoices(true, sess.value);
    int numOfInvoicesBefore = ListSequence.fromList(archInvoices).count();

    {
      int leftSide = newInvForArch.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Create and delete an Invoice on arch table':  newInvForArch .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!(ListSequence.fromList(newInvForArch.getPositions()).any((it) -> it.getId() > 0)))) {
      throw new OFXTestSuitException("'AlternativeTables.Create and delete an Invoice on arch table': !( newInvForArch .positions.any)          ==>> FALSE !" + "\n");
    }

    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoiceArchiv.checkinInvoice(newInvForArch, true, sess.value)), sess.value, __manMapSession);

    {
      int leftSide = newInvForArch.getId();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'AlternativeTables.Create and delete an Invoice on arch table':  newInvForArch .id > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    __DomainRepoInvoiceArchiv.deleteInvoice(newInvForArch, true, sess.value);

    sess.value = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    List<Invoice> allInvoices = __DomainRepoInvoiceArchiv.findAllInvoices(true, sess.value);
    List<InvoicePosition> positions = __DomainRepoInvoiceArchiv.findAllInvoicesPosReverse(true, sess.value);

    {
      int leftSide = ListSequence.fromList(allInvoices).count();
      int rightSide = numOfInvoicesBefore;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Create and delete an Invoice on arch table':  allInvoices .size ==  numOfInvoicesBefore           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(positions).count();
      int rightSide = ListSequence.fromList(allInvoices).count() * 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'AlternativeTables.Create and delete an Invoice on arch table':  positions .size ==  allInvoices .size * 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", AlternativeTables.class, allIncludedTest, includedTestToRun);
  }
}
