package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoReferer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAccountAudit;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SessionLess;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Referer;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Account;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXMeta4Entity;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_HeadState_DefaultS1_WhenNull;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_HeadState_DefaultS2_WhenUndef;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_HeadState_NonNull;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;

public class References__initialization_no_session_ extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private RepoReferer __DomainRepoReferer;
  @Autowired
  private RepoAccountAudit __DomainRepoAccountAudit;
  @Autowired
  private SessionLess __DomainSessionLess;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Save and load an integer-key reference.", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    {
      InvoicePosition leftSide = inv1.getMainPosRef();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference.':  inv1 .mainPosRef ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    int lastPosId = ListSequence.fromList(inv1.getPositions()).last().getId();
    inv1.setMainPosRef(ListSequence.fromList(inv1.getPositions()).last());
    __DomainRepoInvoice.checkinInvoice(inv1, null);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(inv1.getId(), null);
    {
      int leftSide = reloaded.getMainPosRefKEY();
      int rightSide = lastPosId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference.':  reloaded .mainPosRef#KEY ==  lastPosId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    // no session used: objects not the same, but keys are
    {
      InvoicePosition leftSide = reloaded.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(reloaded.getPositions()).last();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference.':  reloaded .mainPosRef !=  reloaded .positions.last          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded.getMainPosRef().getId();
      int rightSide = ListSequence.fromList(reloaded.getPositions()).last().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference.':  reloaded .mainPosRef.id ==  reloaded .positions.last.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reloaded.getMainPosRef().getPosText();
      String param0 = ListSequence.fromList(reloaded.getPositions()).last().getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference.':  reloaded .mainPosRef.posText.equals( reloaded .positions.last.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "Save and load an integer-key reference (set 0)", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    {
      InvoicePosition leftSide = inv1.getMainPosRef();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference (set 0)':  inv1 .mainPosRef ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    inv1.setMainPosRef(ListSequence.fromList(inv1.getPositions()).last());
    __DomainRepoInvoice.checkinInvoice(inv1, null);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(inv1.getId(), null);
    {
      int leftSide = reloaded.getMainPosRef().getId();
      int rightSide = inv1.getMainPosRef().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference (set 0)':  reloaded .mainPosRef.id ==  inv1 .mainPosRef.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    reloaded.setMainPosRef(null);
    __DomainRepoInvoice.checkinInvoice(reloaded, null);

    Invoice reloaded2 = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(inv1.getId(), null);
    {
      int leftSide = reloaded2.getMainPosRefKEY();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference (set 0)':  reloaded2 .mainPosRef#KEY == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(OFXKeyReference.isNullKey(reloaded2.getMainPosRefKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference (set 0)': OFXKeyReference.isNullKey( reloaded2 .mainPosRef#KEY)          ==>> FALSE !" + "\n");
    }
    // should not lead to a not initialized ex.
    {
      InvoicePosition leftSide = reloaded2.getMainPosRef();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference (set 0)':  reloaded2 .mainPosRef ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Save and load an integer-key reference via join", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    {
      InvoicePosition leftSide = inv2.getMainPosRef();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference via join':  inv2 .mainPosRef ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    inv2.setMainPosRef(ListSequence.fromList(inv2.getPositions()).last());

    __DomainRepoInvoice.checkinInvoice(inv2, null);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIDwithJoinedRefs(inv2.getId(), null);
    {
      int leftSide = reloaded.getMainPosRefKEY();
      int rightSide = ListSequence.fromList(inv2.getPositions()).last().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference via join':  reloaded .mainPosRef#KEY ==  inv2 .positions.last.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    // no session used: objects not the same, but keys are
    {
      InvoicePosition leftSide = reloaded.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(inv2.getPositions()).last();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference via join':  reloaded .mainPosRef !=  inv2 .positions.last          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded.getMainPosRef().getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).last().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an integer-key reference via join':  reloaded .mainPosRef.id ==  inv2 .positions.last.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Save and load an string-key reference.", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer main = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeytest1", __manMapSession);
    Referer refered = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeytest2", __manMapSession);


    __DomainRepoReferer.insertReferer(refered, null);
    main.setParent(refered);
    __DomainRepoReferer.insertReferer(main, null);

    Referer reloadMain = __DomainRepoReferer.checkoutRefererWithStRef(main.getKey(), null);
    {
      String operand = reloadMain.getParentKEY();
      String param0 = refered.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference.':  reloadMain .parent#KEY.equals( refered .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reloadMain.getParent().getKey();
      String param0 = refered.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference.':  reloadMain .parent.key.equals( refered .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reloadMain.getParent().getName();
      String param0 = refered.getName();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference.':  reloadMain .parent.name.equals( refered .name)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 4, name = "Save and load an string-key reference. (set null)", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer main = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeytest1-0set", __manMapSession);
    Referer refered = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeytest2-0set", __manMapSession);


    __DomainRepoReferer.insertReferer(refered, null);
    main.setParent(refered);
    __DomainRepoReferer.insertReferer(main, null);

    Referer reloadMain = __DomainRepoReferer.checkoutRefererWithStRef(main.getKey(), null);
    {
      String operand = reloadMain.getParent().getKey();
      String param0 = refered.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference. (set null)':  reloadMain .parent.key.equals( refered .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    main.setParent(null);
    __DomainRepoReferer.updateReferer(main, null);

    Referer reloadMainAgain = __DomainRepoReferer.checkoutRefererWithStRef(main.getKey(), null);
    if (!(OFXKeyReference.isNullKey(reloadMainAgain.getParentKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference. (set null)': OFXKeyReference.isNullKey( reloadMainAgain .parent#KEY)          ==>> FALSE !" + "\n");
    }
    {
      Referer leftSide = reloadMainAgain.getParent();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference. (set null)':  reloadMainAgain .parent ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    // attention !! It s not null!
    {
      String leftSide = reloadMainAgain.getParentKEY();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference. (set null)':  reloadMainAgain .parent#KEY !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      String operand = reloadMainAgain.getParentKEY();
      String param0 = "";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an string-key reference. (set null)':  reloadMainAgain .parent#KEY.equals(\"\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 5, name = "Save and load a list of string-key references with join.", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer main = __DomainCreatorsFactory.createRefererEntityWithStringKey("parent", __manMapSession);
    Referer child1 = __DomainCreatorsFactory.createRefererEntityWithStringKey("child1", __manMapSession);
    Referer child2 = __DomainCreatorsFactory.createRefererEntityWithStringKey("child2", __manMapSession);
    Referer child3 = __DomainCreatorsFactory.createRefererEntityWithStringKey("child3", __manMapSession);


    child1.setParent(main);
    child2.setParent(main);
    child3.setParent(main);
    __DomainRepoReferer.insertReferer(main, null);
    __DomainRepoReferer.insertReferer(child1, null);
    __DomainRepoReferer.insertReferer(child2, null);
    __DomainRepoReferer.insertReferer(child3, null);

    List<Referer> reloadList = __DomainRepoReferer.checkoutRefererWithChildsJoinAndStRef(main.getKey(), null);
    {
      int leftSide = ListSequence.fromList(reloadList).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load a list of string-key references with join.':  reloadList .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    Referer relodedMain = ListSequence.fromList(reloadList).first();

    {
      int leftSide = ListSequence.fromList(relodedMain.getChilds()).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load a list of string-key references with join.':  relodedMain .childs.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = ListSequence.fromList(relodedMain.getChilds()).getElement(0).getKey();
      String rightSide = child1.getKey();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load a list of string-key references with join.':  relodedMain .childs.get.key ==  child1 .key          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Save and load a string-key references with join.", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer main = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeyref-join1", __manMapSession);
    Referer ref = __DomainCreatorsFactory.createRefererEntityWithStringKey("strkeyref-join2", __manMapSession);


    ref.setParent(main);
    __DomainRepoReferer.insertReferer(main, null);
    __DomainRepoReferer.insertReferer(ref, null);

    List<Referer> reloadList = __DomainRepoReferer.checkoutRefererWithRefJoined(ref.getKey(), null);
    {
      int leftSide = ListSequence.fromList(reloadList).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load a string-key references with join.':  reloadList .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    Referer relodedMain = ListSequence.fromList(reloadList).first();

    {
      String operand = relodedMain.getParent().getKey();
      String param0 = main.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load a string-key references with join.':  relodedMain .parent.key.equals( main .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 7, name = "Save and load an ValueObject-key reference.", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer refere = __DomainCreatorsFactory.createRefererEntityWithStringKey("refvalobj", __manMapSession);
    Account child = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "refvalobj", __manMapSession);


    refere.setAccount(child);

    __DomainRepoAccountAudit.insertAccount(child, null);
    __DomainRepoReferer.insertReferer(refere, null);

    Referer reloaded = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      AccountKey operand = reloaded.getAccount().getKey();
      AccountKey param0 = child.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference.':  reloaded .account.key.equals( child .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 8, name = "Save and load an ValueObject-key reference. (set null)", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer refere = __DomainCreatorsFactory.createRefererEntityWithStringKey("refvalobj-0set", __manMapSession);
    Account child = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "refvalobj-0set", __manMapSession);


    refere.setAccount(child);

    __DomainRepoAccountAudit.insertAccount(child, null);
    __DomainRepoReferer.insertReferer(refere, null);

    Referer reloaded = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      AccountKey operand = reloaded.getAccount().getKey();
      AccountKey param0 = child.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference. (set null)':  reloaded .account.key.equals( child .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    refere.setAccount(null);
    __DomainRepoReferer.updateReferer(refere, null);

    Referer reloadedAgain = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);

    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(reloadedAgain.getAccountKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference. (set null)':  reloadedAgain .account#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
    if (!(OFXKeyReference.isNullKey(reloadedAgain.getAccountKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference. (set null)': OFXKeyReference.isNullKey( reloadedAgain .account#KEY)          ==>> FALSE !" + "\n");
    }
    {
      Account leftSide = reloadedAgain.getAccount();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference. (set null)':  reloadedAgain .account ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Save and load an ValueObject-key reference with join.", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer refere = __DomainCreatorsFactory.createRefererEntityWithStringKey("refvalobj-join", __manMapSession);
    Account child = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "refvalobj-join", __manMapSession);


    refere.setAccount(child);

    __DomainRepoAccountAudit.insertAccount(child, null);
    __DomainRepoReferer.insertReferer(refere, null);

    List<Referer> refererList = __DomainRepoReferer.checkoutRefererWithAccountJoin(refere.getKey(), null);
    {
      int leftSide = ListSequence.fromList(refererList).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference with join.':  refererList .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    Referer reloaded = ListSequence.fromList(refererList).first();


    {
      AccountKey operand = reloaded.getAccount().getKey();
      AccountKey param0 = child.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key reference with join.':  reloaded .account.key.equals( child .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 10, name = "Save and load an ValueObject-key references with join.", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account child1 = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "valobj-joinlist1", __manMapSession);
    Account child2 = __DomainCreatorsFactory.createAccountWithNumAndMandant(2, "valobj-joinlist2", __manMapSession);
    Account child3 = __DomainCreatorsFactory.createAccountWithNumAndMandant(3, "valobj-joinlist3", __manMapSession);
    Referer parent = __DomainCreatorsFactory.createRefererEntityWithStringKey("valobj-joinlist", __manMapSession);


    ListSequence.fromList(parent.getAccountList()).addElement(child1);
    ListSequence.fromList(parent.getAccountList()).addElement(child2);
    ListSequence.fromList(parent.getAccountList()).addElement(child3);
    child1.setParent(parent);
    child2.setParent(parent);
    child3.setParent(parent);

    __DomainRepoReferer.insertReferer(parent, null);
    __DomainRepoAccountAudit.insertAccount(child1, null);
    __DomainRepoAccountAudit.insertAccount(child2, null);
    __DomainRepoAccountAudit.insertAccount(child3, null);

    List<Referer> refList = __DomainRepoReferer.checkoutRefererWithAccountListJoinded(parent.getKey(), null);
    {
      int leftSide = ListSequence.fromList(refList).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key references with join.':  refList .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    Referer reloaded = ListSequence.fromList(refList).first();

    {
      int leftSide = ListSequence.fromList(reloaded.getAccountList()).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key references with join.':  reloaded .accountList.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      AccountKey operand = ListSequence.fromList(reloaded.getAccountList()).getElement(0).getKey();
      AccountKey param0 = child1.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Save and load an ValueObject-key references with join.':  reloaded .accountList.get.key.equals( child1 .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }


  }
  @OFXTestMethod(id = 11, name = "Load entity with ValueObject-key reference and key directly embedded in entity.", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer refere = __DomainCreatorsFactory.createRefererEntityWithStringKey("refvalobjdirect", __manMapSession);
    Account child = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "refvalobjdirect", __manMapSession);


    refere.setAccount(child);
    refere.setAccountKey(child.getKey());
    __DomainRepoAccountAudit.insertAccount(child, null);
    __DomainRepoReferer.insertReferer(refere, null);

    Referer reloaded = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      int leftSide = reloaded.getAccount().getKey().getNumber();
      int rightSide = reloaded.getAccountKey().getNumber();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Load entity with ValueObject-key reference and key directly embedded in entity.':  reloaded .account.key.number ==  reloaded .accountKey.number          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reloaded.getAccount().getKey().getMandant();
      String param0 = reloaded.getAccountKey().getMandant();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Load entity with ValueObject-key reference and key directly embedded in entity.':  reloaded .account.key.mandant.equals( reloaded .accountKey.mandant)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      AccountKey_Active operand = reloaded.getAccount().getKey().getActive();
      AccountKey_Active param0 = reloaded.getAccountKey().getActive();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Load entity with ValueObject-key reference and key directly embedded in entity.':  reloaded .account.key.active.equals( reloaded .accountKey.active)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 12, name = "Assigne ValueObj-Key, reload and assign different one.", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer refere = __DomainCreatorsFactory.createRefererEntityWithStringKey("valobjnewold", __manMapSession);
    Account child = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "valobjnewold", __manMapSession);
    Account newChild = __DomainCreatorsFactory.createAccountWithNumAndMandant(2, "valobjnewold", __manMapSession);


    refere.setAccount(child);
    refere.setAccountKey(child.getKey());
    __DomainRepoAccountAudit.insertAccount(child, null);
    __DomainRepoAccountAudit.insertAccount(newChild, null);

    __DomainRepoReferer.insertReferer(refere, null);

    Referer reloaded = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      AccountKey operand = reloaded.getAccount().getKey();
      AccountKey param0 = child.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Assigne ValueObj-Key, reload and assign different one.':  reloaded .account.key.equals( child .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    reloaded.setAccount(newChild);
    __DomainRepoReferer.updateReferer(reloaded, null);

    Referer reloaded2 = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      AccountKey operand = reloaded2.getAccount().getKey();
      AccountKey param0 = newChild.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Assigne ValueObj-Key, reload and assign different one.':  reloaded2 .account.key.equals( newChild .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded2.setAccount(child);
    __DomainRepoReferer.updateReferer(reloaded2, null);

    Referer reloaded3 = __DomainRepoReferer.checkoutRefererWithValueObjRef(refere.getKey(), null);
    {
      AccountKey operand = reloaded3.getAccount().getKey();
      AccountKey param0 = child.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Assigne ValueObj-Key, reload and assign different one.':  reloaded3 .account.key.equals( child .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 13, name = "Check Reference initialization in Entities for IntegerKey", debug = false, enabled = true, runAt = "")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    InvoicePosition pos = new InvoicePosition();
    {
      Invoice leftSide = pos.getInvoice();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for IntegerKey':  pos .invoice ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = pos.getInvoiceKEY();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for IntegerKey':  pos .invoice#KEY == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(pos.getInvoiceKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for IntegerKey':  pos .invoice#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 14, name = "Check Reference initialization in Entities for StringKey", debug = false, enabled = true, runAt = "")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer r = new Referer();

    {
      Referer leftSide = r.getParent();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for StringKey':  r .parent ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = r.getParentKEY();
      String param0 = "";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for StringKey':  r .parent#KEY.equals(\"\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(r.getParentKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for StringKey':  r .parent#KEY.isNullKey          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 15, name = "Check Reference initialization in Entities for ValueObjectKey", debug = false, enabled = true, runAt = "")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account acc = new Account();

    {
      Account leftSide = acc.getRelatedAccountAudit();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for ValueObjectKey':  acc .relatedAccountAudit ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(acc.getRelatedAccountAuditKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for ValueObjectKey':  acc .relatedAccountAudit#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
    {
      AccountKey operand = acc.getRelatedAccountAuditKEY();
      Object param0 = ((IOFXValueObject) new AccountKey()).createNullKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check Reference initialization in Entities for ValueObjectKey':  acc .relatedAccountAudit#KEY.equals(((IOFXValueObject) new ).createNullKey())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 16, name = "Check IntegerKey dirty handling for entities - initially not set", debug = false, enabled = true, runAt = "")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    InvoicePosition p = new InvoicePosition();
    Invoice i = new Invoice();
    i.setId(10);

    ((IOFXEntity) p).clearDirtySetReadonly(false);
    if (!(!(p._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially not set': !( p .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    p.setInvoice(i);
    {
      int leftSide = p.getInvoiceKEY();
      int rightSide = i.getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially not set':  p .invoice#KEY ==  i .id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMeta4Entity operand = p._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially not set':  p .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

    ((IOFXEntity) p).clearDirtySetReadonly(false);
    p.setInvoice(null);
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(p.getInvoiceKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially not set':  p .invoice#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
    {
      IOFXMeta4Entity operand = p._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially not set':  p .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 17, name = "Check IntegerKey dirty handling for entities - initially set", debug = false, enabled = true, runAt = "")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith2PositionsAnd2SubPos_onDB("inkey_dirty", __manMapSession);



    int pos_id = ListSequence.fromList(invoice.getPositions()).first().getId();
    InvoicePosition pos = __DomainRepoInvoice.checkoutInvoicePosition(pos_id, null);

    {
      int leftSide = pos.getInvoiceKEY();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set':  pos .invoice#KEY > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    if (!(!(pos._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set': !( pos .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    Invoice inv = __DomainRepoInvoice.checkoutInvoiceHeadGet(pos.getInvoiceKEY(), null);
    {
      Invoice leftSide = inv;
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set':  inv  !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    pos.setInvoice(inv);
    if (!(!(pos._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set': !( pos .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }
    {
      int leftSide = inv.getId();
      int rightSide = pos.getInvoiceKEY();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set':  inv .id ==  pos .invoice#KEY          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice newInvoice = new Invoice();
    pos.setInvoice(newInvoice);

    {
      IOFXMeta4Entity operand = pos._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check IntegerKey dirty handling for entities - initially set':  pos .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 18, name = "Check StringKey dirty handling for entities - initially not set", debug = false, enabled = true, runAt = "")
  public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer child = new Referer();
    Referer parent = new Referer();
    parent.setKey("st_d_chk");

    ((IOFXEntity) child).clearDirtySetReadonly(false);
    if (!(!(child._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially not set': !( child .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    child.setParent(parent);
    {
      String operand = child.getParentKEY();
      String param0 = parent.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially not set':  child .parent#KEY.equals( parent .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMeta4Entity operand = child._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially not set':  child .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

    ((IOFXEntity) child).clearDirtySetReadonly(false);
    child.setParent(null);
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(child.getParentKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially not set':  child .parent#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
    {
      IOFXMeta4Entity operand = child._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially not set':  child .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 19, name = "Check StringKey dirty handling for entities - initially set", debug = false, enabled = true, runAt = "")
  public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer pre_child = __DomainCreatorsFactory.createRefererEntityWithStringKey("stkey_dirty_1", __manMapSession);
    Referer pre_parent = __DomainCreatorsFactory.createRefererEntityWithStringKey("stkey_dirty_2", __manMapSession);



    pre_child.setParent(pre_parent);

    __DomainRepoReferer.insertReferer(pre_parent, null);
    __DomainRepoReferer.insertReferer(pre_child, null);
    {
      String operand = pre_child.getParentKEY();
      String param0 = pre_parent.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set':  pre_child .parent#KEY.equals( pre_parent .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    Referer child = __DomainRepoReferer.checkoutReferer(pre_child.getKey(), null);
    Referer parent = __DomainRepoReferer.checkoutReferer(pre_parent.getKey(), null);

    if (!(!(MMStaticAccessHelper.isNullKeyStaticHelper(child.getParentKEY())))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set': !( child .parent#KEY.isNullKey)          ==>> FALSE !" + "\n");
    }
    {
      String operand = child.getParentKEY();
      String param0 = parent.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set':  child .parent#KEY.equals( parent .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(parent.getParentKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set':  parent .parent#KEY.isNullKey          ==>> FALSE !" + "\n");
    }

    if (!(!(child._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set': !( child .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }
    if (!(!(parent._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set': !( parent .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    child.setParent(parent);
    if (!(!(child._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set': !( child .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }


    Referer newRefer = new Referer();
    child.setParent(newRefer);
    {
      IOFXMeta4Entity operand = child._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check StringKey dirty handling for entities - initially set':  child .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 20, name = "Check CompoundKey dirty handling for entities - initially not set", debug = false, enabled = true, runAt = "")
  public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account main = new Account();
    main.setKey(new AccountKey(123, "dirty", AccountKey_Active.ON));

    Account related = new Account();
    related.setKey(new AccountKey(456, "dirty", AccountKey_Active.ON));

    ((IOFXEntity) main).clearDirtySetReadonly(false);
    if (!(!(main._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially not set': !( main .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    main.setRelatedAccountAudit(related);
    {
      AccountKey operand = main.getRelatedAccountAuditKEY();
      AccountKey param0 = related.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially not set':  main .relatedAccountAudit#KEY.equals( related .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMeta4Entity operand = main._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially not set':  main .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

    ((IOFXEntity) main).clearDirtySetReadonly(false);
    main.setRelatedAccountAudit(null);
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(main.getParentKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially not set':  main .parent#KEY.isNullKey          ==>> FALSE !" + "\n");
    }
    {
      IOFXMeta4Entity operand = main._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially not set':  main .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 21, name = "Check CompoundKey dirty handling for entities - initially set", debug = false, enabled = true, runAt = "")
  public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account pre_related = __DomainCreatorsFactory.createAccount_onDB("dirty_1", null, __manMapSession);
    Account pre_main = __DomainCreatorsFactory.createAccount_onDB("dirty_2", pre_related, __manMapSession);



    {
      AccountKey operand = pre_main.getRelatedAccountAuditKEY();
      AccountKey param0 = pre_related.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set':  pre_main .relatedAccountAudit#KEY.equals( pre_related .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    if (!(!(MMStaticAccessHelper.isNullKeyStaticHelper(pre_main.getRelatedAccountAuditKEY())))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set': !( pre_main .relatedAccountAudit#KEY.isNullKey)          ==>> FALSE !" + "\n");
    }

    Account related = __DomainRepoAccountAudit.checkoutAccountAudit(pre_related.getKey(), null);
    Account main = __DomainRepoAccountAudit.checkoutAccountAudit(pre_main.getKey(), null);

    if (!(!(MMStaticAccessHelper.isNullKeyStaticHelper(main.getRelatedAccountAuditKEY())))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set': !( main .relatedAccountAudit#KEY.isNullKey)          ==>> FALSE !" + "\n");
    }
    {
      AccountKey operand = main.getRelatedAccountAuditKEY();
      AccountKey param0 = related.getKey();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set':  main .relatedAccountAudit#KEY.equals( related .key)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(related.getRelatedAccountAuditKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set':  related .relatedAccountAudit#KEY.isNullKey          ==>> FALSE !" + "\n");
    }

    if (!(!(related._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set': !( related .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }
    if (!(!(main._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set': !( main .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }

    main.setRelatedAccountAudit(related);
    if (!(!(related._META().getDirty()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set': !( related .#Meta.getDirty())          ==>> FALSE !" + "\n");
    }


    Account newAccount = new Account();
    main.setRelatedAccountAudit(newAccount);
    {
      IOFXMeta4Entity operand = main._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getDirty())) {
        throw new OFXTestSuitException("'References, initialization(no session).Check CompoundKey dirty handling for entities - initially set':  main .#Meta.getDirty()          ==>> '" + operand + "'.getDirty(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 22, name = "CompoundKey reference saving without setting the key of the object", debug = false, enabled = true, runAt = "")
  public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account someAccount = __DomainCreatorsFactory.createAccount_onDB("nokey_3", null, __manMapSession);


    Account newAccount = new Account();
    // key is null
    {
      AccountKey leftSide = newAccount.getKey();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).CompoundKey reference saving without setting the key of the object':  newAccount .key ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    someAccount.setRelatedAccountAudit(newAccount);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoAccountAudit.insertAccount(someAccount, null);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("reference without saving the referred entity first")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("reference without saving the referred entity first")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'References, initialization(no session).CompoundKey reference saving without setting the key of the object': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'References, initialization(no session).CompoundKey reference saving without setting the key of the object': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'References, initialization(no session).CompoundKey reference saving without setting the key of the object': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 23, name = "Query a status which is null on the db - ALLOW_NULL", debug = false, enabled = true, runAt = "")
  public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceHeadGet(47000001, null);
    {
      Invoice_HeadState leftSide = inv.getHeadState();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - ALLOW_NULL':  inv .headState ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 24, name = "Query a status which is null on the db - NULL not allowed", debug = false, enabled = true, runAt = "")
  public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        InvoiceStat inv = __DomainRepoInvoice.checkoutInvoiceStat_notnull(47000001, null);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("Unknown status")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("Unknown status")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - NULL not allowed': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - NULL not allowed': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - NULL not allowed': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }


  }
  @OFXTestMethod(id = 25, name = "Query a status which is null on the db - S1 when null", debug = false, enabled = true, runAt = "")
  public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    InvoiceStat inv = __DomainRepoInvoice.checkoutInvoiceStat_S1_when_null(47000001, null);
    {
      InvoiceStat_HeadState_DefaultS1_WhenNull leftSide = inv.getHs_S1_when_null();
      InvoiceStat_HeadState_DefaultS1_WhenNull rightSide = InvoiceStat_HeadState_DefaultS1_WhenNull.STAT1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - S1 when null':  inv .hs_S1_when_null == \"HeadState_DefaultS1_WhenNull.stat1\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 26, name = "Query a status which is null on the db - S2 when undefined ", debug = false, enabled = true, runAt = "")
  public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    InvoiceStat inv = __DomainRepoInvoice.checkoutInvoiceStat_S2_when_undefined(47000001, null);
    {
      InvoiceStat_HeadState_DefaultS2_WhenUndef leftSide = inv.getHs_S2_when_undefined();
      InvoiceStat_HeadState_DefaultS2_WhenUndef rightSide = InvoiceStat_HeadState_DefaultS2_WhenUndef.STAT2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Query a status which is null on the db - S2 when undefined ':  inv .hs_S2_when_undefined == \"HeadState_DefaultS2_WhenUndef.stat2\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 27, name = "On Create correctly set", debug = false, enabled = true, runAt = "")
  public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    InvoiceStat s = new InvoiceStat();
    {
      InvoiceStat_HeadState_DefaultS1_WhenNull leftSide = s.getHs_S1_when_null();
      InvoiceStat_HeadState_DefaultS1_WhenNull rightSide = InvoiceStat_HeadState_DefaultS1_WhenNull.DEFAULT;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).On Create correctly set':  s .hs_S1_when_null == \"HeadState_DefaultS1_WhenNull.default\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      InvoiceStat_HeadState_DefaultS2_WhenUndef leftSide = s.getHs_S2_when_undefined();
      InvoiceStat_HeadState_DefaultS2_WhenUndef rightSide = InvoiceStat_HeadState_DefaultS2_WhenUndef.DEFAULT;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).On Create correctly set':  s .hs_S2_when_undefined == \"HeadState_DefaultS2_WhenUndef.default\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      InvoiceStat_HeadState_NonNull leftSide = s.getHs_notnull();
      InvoiceStat_HeadState_NonNull rightSide = InvoiceStat_HeadState_NonNull.DEFAULT;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).On Create correctly set':  s .hs_notnull == \"HeadState_NonNull.default\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 28, name = "Write status on db - NULL allowed (and reload)", debug = false, enabled = true, runAt = "")
  public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("status nullcheck", __manMapSession);


    // inserted by sql script
    inv.setHeadState(null);
    final IOFXSession sess = __DomainSessionLess.CREATE_SESSION(__manMapSession);
    __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoice.checkinInvoice(inv, sess)), sess, __manMapSession);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceHeadGet(inv.getId(), null);
    {
      Invoice_HeadState leftSide = reloaded.getHeadState();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Write status on db - NULL allowed (and reload)':  reloaded .headState ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 29, name = "Write status on db - NULL not allowed", debug = false, enabled = true, runAt = "")
  public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // inserted by sql script
    InvoiceStat s = new InvoiceStat();
    s.setName("null checking");
    s.setText("null checking");
    s.setHs_notnull(null);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.checkinInvoiceStat_notnull(s, null);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("You can not write")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("You can not write")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'References, initialization(no session).Write status on db - NULL not allowed': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'References, initialization(no session).Write status on db - NULL not allowed': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'References, initialization(no session).Write status on db - NULL not allowed': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 30, name = "Check if we can compile a complex list operation with status", debug = false, enabled = true, runAt = "")
  public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<Invoice> invoices = __DomainRepoInvoice.findAllInvoices(null);

    List<Invoice_HeadState> states = ListSequence.fromList(invoices).select((it) -> ((Invoice_HeadState) it.getHeadState())).toList();
    List<Invoice_HeadState> compressedStates = ListSequence.fromList(states).distinct().toList();
    if (!(ListSequence.fromList(compressedStates).contains(Invoice_HeadState.STAT1))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check if we can compile a complex list operation with status':  compressedStates .contains          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 31, name = "Check that we load left outer joins correctly with composite null key present. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account acc = __DomainCreatorsFactory.createAccount_onDB("null composite ref", null, __manMapSession);


    List<Account> reloaded = __DomainRepoReferer.findAccountByIdJoinRelatedAccount(acc.getKey(), __manMapSession);
    {
      int leftSide = ListSequence.fromList(reloaded).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'References, initialization(no session).Check that we load left outer joins correctly with composite null key present. ':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(ListSequence.fromList(reloaded).first().getRelatedAccountAuditKEY()))) {
      throw new OFXTestSuitException("'References, initialization(no session).Check that we load left outer joins correctly with composite null key present. ':  reloaded .first.relatedAccountAudit#KEY.isNullKey          ==>> FALSE !" + "\n");
    }


  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", References__initialization_no_session_.class, allIncludedTest, includedTestToRun);
  }
}
