package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.manmap.behavior.IAtomMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.MappingReference__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;

public class BinaryOPHelper {
  public BinaryOPHelper() {
  }
  public static boolean isLocalDateInvolvedOrForceDateTime(SNode bo) {
    SNode ref = null;
    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj), CONCEPTS.MappingReference$gj)) {
      ref = SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj), CONCEPTS.MappingReference$gj);
    }
    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(bo, LINKS.rightExpression$nvX), CONCEPTS.MappingReference$gj)) {
      ref = SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.rightExpression$nvX), CONCEPTS.MappingReference$gj);
    }

    // ok, now check the reference..
    if (ref != null) {
      // directly LocalDate mapped ?
      if ((boolean) IAtomMapping__BehaviorDescriptor.isLocalDate_id7kypvuI$EaY.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(SLinkOperations.getTarget(ref, LINKS.fieldMapping$5IyH), LINKS.property$JxuR), LINKS.type$56v0))) {
        return true;
      }

      //  is it a forced localdate ???
      if ((boolean) IAtomMapping__BehaviorDescriptor.isDateTime_id7kypvuI$Eap.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(SLinkOperations.getTarget(ref, LINKS.fieldMapping$5IyH), LINKS.property$JxuR), LINKS.type$56v0)) && (boolean) MappingReference__BehaviorDescriptor.forceToLocalDate_id53w0FTluib9.invoke(ref)) {
        return true;
      }
    }

    return false;
  }

  public static boolean isDateTimeInvolved(SNode bo) {
    SNode ref = null;
    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj), CONCEPTS.MappingReference$gj)) {
      ref = SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj), CONCEPTS.MappingReference$gj);
    }
    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(bo, LINKS.rightExpression$nvX), CONCEPTS.MappingReference$gj)) {
      ref = SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.rightExpression$nvX), CONCEPTS.MappingReference$gj);
    }

    // ok, now check the reference..
    if (ref != null) {
      // not forced, but still a datetime - need the (CAST ?) thing on oracel.
      if ((boolean) IAtomMapping__BehaviorDescriptor.isDateTime_id7kypvuI$Eap.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(SLinkOperations.getTarget(ref, LINKS.fieldMapping$5IyH), LINKS.property$JxuR), LINKS.type$56v0))) {
        return true;
      }
    }

    return false;
  }
  public static boolean mrHere(SNode bo) {
    if (SNodeOperations.isInstanceOf(bo, CONCEPTS.MappingReference$gj)) {
      return true;
    }
    return false;
  }
  public static SNode getMappingRef(SNode bo) {
    if (mrHere(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj))) {
      return SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj), CONCEPTS.MappingReference$gj);
    }
    return SNodeOperations.cast(SLinkOperations.getTarget(bo, LINKS.rightExpression$nvX), CONCEPTS.MappingReference$gj);
  }
  public static SNode getExpNotMapping(SNode bo) {
    if (SNodeOperations.isInstanceOf(bo, CONCEPTS.BinaryOperation$W1)) {
      if (mrHere(SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.BinaryOperation$W1), LINKS.leftExpression$sEj))) {
        return SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.BinaryOperation$W1), LINKS.rightExpression$nvX);
      }
      if (mrHere(SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.BinaryOperation$W1), LINKS.rightExpression$nvX))) {
        return SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.BinaryOperation$W1), LINKS.leftExpression$sEj);
      }
      throw new IllegalStateException("Neither left nor right side contain a mapping reference!");
    }

    if (SNodeOperations.isInstanceOf(bo, CONCEPTS.LikeOperator$m8)) {
      if (mrHere(SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.LikeOperator$m8), LINKS.operand$CXaE))) {
        return SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.LikeOperator$m8), LINKS.target$CXpF);
      }
      if (mrHere(SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.LikeOperator$m8), LINKS.target$CXpF))) {
        return SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.LikeOperator$m8), LINKS.operand$CXaE);
      }
      throw new IllegalStateException("Neither target nor operand side contain a mapping reference!");
    }

    if (SNodeOperations.isInstanceOf(bo, CONCEPTS.InOperation$PA)) {
      if (mrHere(SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.InOperation$PA), LINKS.operand$HFgz))) {
        return SLinkOperations.getTarget(SNodeOperations.cast(bo, CONCEPTS.InOperation$PA), LINKS.targetList$HFv$);
      }
      throw new IllegalStateException("Mapping Reference should be in InOperation's operand. This can not happen.");
    }
    throw new IllegalStateException("Operation not supported by manmap optional() feature. Unknown op " + SNodeOperations.present(bo));

  }
  public static String getAlias(SNode bo) {

    // Assuming the MappingRef is on the left
    // mappingRef <= Expression
    if (mrHere(SLinkOperations.getTarget(bo, LINKS.leftExpression$sEj))) {
      return SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo));
    }

    // ok .. mr on right ...
    if (SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals("==") || SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals("!=")) {
      return SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo));
    }
    if (SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals(">=")) {
      return "<=";
    }
    if (SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals(">")) {
      return "<";
    }
    if (SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals("<=")) {
      return ">=";
    }
    if (SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)).equals("<")) {
      return ">";
    }

    throw new IllegalStateException("Alias of binary operation unknown! " + SConceptOperations.conceptAlias(SNodeOperations.getConcept(bo)));
  }
  public static boolean isEqualOrNotEqual(SNode bo) {
    return BinaryOPHelper.getAlias(bo).equals("==") || BinaryOPHelper.getAlias(bo).equals("!=");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink leftExpression$sEj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11cL, "leftExpression");
    /*package*/ static final SContainmentLink rightExpression$nvX = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11bL, "rightExpression");
    /*package*/ static final SReferenceLink fieldMapping$5IyH = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1b658a0dfe786f67L, 0x4799744bf329064cL, "fieldMapping");
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink target$CXpF = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xda29ee3aec54d1dL, 0xda29ee3aec54d26L, "target");
    /*package*/ static final SContainmentLink operand$CXaE = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xda29ee3aec54d1dL, 0xda29ee3aec54d25L, "operand");
    /*package*/ static final SContainmentLink targetList$HFv$ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7bb9beb8d862d7f3L, 0x7bb9beb8d862d7f5L, "targetList");
    /*package*/ static final SContainmentLink operand$HFgz = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7bb9beb8d862d7f3L, 0x7bb9beb8d862d7f4L, "operand");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept MappingReference$gj = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1b658a0dfe786f67L, "org.modellwerkstatt.manmap.structure.MappingReference");
    /*package*/ static final SInterfaceConcept IAtomMapping$dv = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e4758c3L, "org.modellwerkstatt.manmap.structure.IAtomMapping");
    /*package*/ static final SConcept BinaryOperation$W1 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, "jetbrains.mps.baseLanguage.structure.BinaryOperation");
    /*package*/ static final SConcept LikeOperator$m8 = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xda29ee3aec54d1dL, "org.modellwerkstatt.manmap.structure.LikeOperator");
    /*package*/ static final SConcept InOperation$PA = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7bb9beb8d862d7f3L, "org.modellwerkstatt.manmap.structure.InOperation");
  }
}
