package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.behavior.L2RTComponentCall__BehaviorDescriptor;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;

public class L2RuntimeDefinitions {
  private static final String IOFXPLATFORM_TO_ADD = "org.modellwerkstatt.objectflow.runtime.IOFXPlatform";
  private static final String IOFXTRANSLATOR_TO_ADD = "org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider";


  public static List<String> calcL2RTRequirementsInComponent(final SNode aComponent) {
    // smr23: checked for speed, takes 0 or 1ms per call 
    List<SNode> calls = SNodeOperations.getNodeDescendants(aComponent, CONCEPTS.L2RTComponentCall$gr, false, new SAbstractConcept[]{});

    List<String> components = ListSequence.fromList(calls).select((it) -> (String) L2RTComponentCall__BehaviorDescriptor.getRtComponentFQName_id4Wj1gYKHbnw.invoke(it)).where((it) -> !(it.equals(INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(aComponent)))).toList();

    ListSequence.fromList(components).addElement(IOFXPLATFORM_TO_ADD);
    ListSequence.fromList(components).addElement(IOFXTRANSLATOR_TO_ADD);

    return ListSequence.fromList(components).distinct().toList();
  }

  public static boolean isPlatformOrTransProvider(String st) {
    return IOFXPLATFORM_TO_ADD.equals(st) || IOFXTRANSLATOR_TO_ADD.equals(st);
  }

  public static String getInstanceNameFromFQName(String fqName) {
    int namePoint = fqName.lastIndexOf(".");
    String resulting = fqName.substring(namePoint + 1);
    if (namePoint > 0) {
      String packageStr = fqName.substring(0, namePoint);
      int packagePoint = packageStr.lastIndexOf(".");
      resulting = packageStr.substring(packagePoint + 1) + resulting.substring(0, 1).toUpperCase() + resulting.substring(1);
    }
    return "__" + resulting;
  }
  public static String depLegacyNaming(String fqName) {
    String name = fqName.replace(".", "_");
    String shortName = name.substring(0, 1).toLowerCase() + name.substring(1);
    return "__" + shortName.replaceAll("\\s", "_");
  }


  public static void main(String[] args) {
    String fq = "org.mytest.dan.man";
    String fq2 = "dan.man";
    String fq3 = "man";

    System.err.println("> " + getInstanceNameFromFQName(fq));
    System.err.println("> " + getInstanceNameFromFQName(fq2));
    System.err.println("> " + getInstanceNameFromFQName(fq3));
  }

  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept L2RTComponentCall$gr = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x537ec02635af07f9L, "org.modellwerkstatt.manmap.structure.L2RTComponentCall");
  }
}
