package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.manmap.behavior.ISizeSpecified__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IAtomMapping__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SProperty;

public class OracleVendor implements ISqlTableDescriberVendor {


  @Override
  public String createTable(String tblName) {
    return "CREATE TABLE " + tblName;
  }
  @Override
  public String createNumber(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = fldName + " NUMBER ";
    if (sizeOpt != null) {
      st += " (" + (int) ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt) + ", " + (int) ISizeSpecified__BehaviorDescriptor.getDecValue_id7K21hvEcg2G.invoke(sizeOpt) + ") ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (9) ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (13, 4) ";
    } else {
      throw new RuntimeException("This can not happen.");
    }
    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String createVarchar(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = fldName + " VARCHAR2 ";
    if (sizeOpt != null) {
      st += " (" + (int) ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt) + " CHAR) ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (5 CHAR) ";
    } else {
      st += " (50 CHAR) ";
    }

    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String createBlob(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = fldName + " BLOB ";
    if (sizeOpt != null) {
      // however, no blob size on oracle !
      throw new RuntimeException("Oracle Blob fields do not support any size!");
    }

    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String createLocalDate(SNode fldMap, String fldName, boolean notNull) {
    String st = fldName + " DATE ";
    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String createDateTime(SNode fldMap, String fldName, boolean notNull) {
    String st = fldName + " DATE ";
    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String createTCN() {
    return "TCN NUMBER (9) NOT NULL   /* entity version */";
  }
  @Override
  public String createSequence(String name) {
    return "CREATE SEQUENCE " + name + " START WITH 1 MINVALUE 1 MAXVALUE 999999999 NOCYCLE CACHE 20 ORDER;\n";
  }
  @Override
  public String createAutoIncrement(String tableName, String fieldName) {
    return "";
  }

  @Override
  public String createUniqueConstraint(String name, List<SNode> fields) {
    String concat = IterableUtils.join(ListSequence.fromList(fields).select((it) -> SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.fieldName$un98), PROPS.value$w7MM)), ", ");
    return "CONSTRAINT " + name + " UNIQUE (" + concat + ")";
  }

  @Override
  public String createPrimKeyConstraint(String name, List<SNode> fields) {
    String concat = IterableUtils.join(ListSequence.fromList(fields).select((it) -> SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.fieldName$un98), PROPS.value$w7MM)), ", ");
    return "CONSTRAINT " + name + " PRIMARY KEY (" + concat + ")";
  }

  @Override
  public String alterNumber(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = "ALTER TABLE " + tblName + " ADD " + fldName + " NUMBER ";

    if (sizeOpt != null) {
      st += " (" + (int) ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt) + ", " + (int) ISizeSpecified__BehaviorDescriptor.getDecValue_id7K21hvEcg2G.invoke(sizeOpt) + ") ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (9) ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (13, 4) ";
    } else {
      throw new RuntimeException("This can not happen.");
    }

    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String alterVarchar(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = "ALTER TABLE " + tblName + " ADD " + fldName + " VARCHAR2 ";

    if (sizeOpt != null) {
      st += " (" + (int) ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt) + " CHAR) ";
    } else if ((boolean) IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fldMap, LINKS.property$JxuR), LINKS.type$56v0))) {
      st += " (5 CHAR) ";
    } else {
      st += " (50 CHAR) ";
    }

    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String alterBlob(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
    String st = "ALTER TABLE " + tblName + " ADD " + fldName + " BLOB ";

    if (sizeOpt != null) {
      st += " (" + (int) ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt) + ") ";
    } else {
      st += " (1M) ";
    }

    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String alterLocalDate(String tblName, String afterCol, SNode fldMap, String fldName, boolean notNull) {
    String st = "ALTER TABLE " + tblName + " ADD " + fldName + " DATE ";
    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String alterDateTime(String tblName, String afterCol, SNode fldMap, String fldName, boolean notNull) {
    String st = "ALTER TABLE " + tblName + " ADD " + fldName + " DATE ";
    if (notNull) {
      st += " NOT NULL ";
    }
    return st;
  }
  @Override
  public String alterTCN(String tblName, String afterCol) {
    return "ALTER TABLE " + tblName + " ADD TCN NUMBER (9) NOT NULL";
  }

  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept IAtomMapping$dv = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e4758c3L, "org.modellwerkstatt.manmap.structure.IAtomMapping");
  }

  private static final class LINKS {
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e480de7L, "fieldName");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
  }
}
