package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.behavior.IOptionsProvider__BehaviorDescriptor;
import java.util.Map;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.WeakHashMap;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.EntityMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.FieldMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IAtomMapping__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.manmap.behavior.IKeyMapping__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import org.modellwerkstatt.manmap.behavior.IMapsClassConcept__BehaviorDescriptor;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.manmap.behavior.IAutoIdProvider__BehaviorDescriptor;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;

public class SqlTableDescriber {

  private ISqlTableDescriberVendor vendor;


  public SqlTableDescriber(ISqlTableDescriberVendor aVendor) {
    this.vendor = aVendor;
  }

  private static SNode getSpecifiedSize(SNode fm) {
    SNode sizeOption = null;


    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(fm, LINKS.property$JxuR), CONCEPTS.IOptionsProvider$mY)) {
      sizeOption = SNodeOperations.cast(ListSequence.fromList(IOptionsProvider__BehaviorDescriptor.getFieldOptions_idhm5BQDGo7a.invoke(SNodeOperations.cast(SLinkOperations.getTarget(fm, LINKS.property$JxuR), CONCEPTS.IOptionsProvider$mY))).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.SizeOption$QV)), CONCEPTS.SizeOption$QV);

      if (sizeOption == null) {
        sizeOption = SNodeOperations.cast(ListSequence.fromList(IOptionsProvider__BehaviorDescriptor.getFieldOptions_idhm5BQDGo7a.invoke(SNodeOperations.cast(SLinkOperations.getTarget(fm, LINKS.property$JxuR), CONCEPTS.IOptionsProvider$mY))).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.ISizeSpecified$DJ)), CONCEPTS.ISizeSpecified$DJ);
      }
    }

    if (sizeOption == null) {
      sizeOption = SNodeOperations.cast(ListSequence.fromList(SLinkOperations.getChildren(fm, LINKS.mappingOption$nC$y)).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.SizeOption$QV)), CONCEPTS.SizeOption$QV);
    }

    return sizeOption;
  }

  private static boolean getSpecifiedUnique(SNode fm) {
    SNode opt = null;

    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(fm, LINKS.property$JxuR), CONCEPTS.IOptionsProvider$mY)) {
      opt = SNodeOperations.cast(ListSequence.fromList(IOptionsProvider__BehaviorDescriptor.getFieldOptions_idhm5BQDGo7a.invoke(SNodeOperations.cast(SLinkOperations.getTarget(fm, LINKS.property$JxuR), CONCEPTS.IOptionsProvider$mY))).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.UniqueOption$bS)), CONCEPTS.UniqueOption$bS);
    }
    if (opt == null) {
      opt = SNodeOperations.cast(ListSequence.fromList(SLinkOperations.getChildren(fm, LINKS.mappingOption$nC$y)).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.UniqueOption$bS)), CONCEPTS.UniqueOption$bS);

    }
    return opt != null;
  }

  private void addToMap(Map<SNode, List<SNode>> theMap, SNode key, SNode value) {
    if (ListSequence.fromList(MapSequence.fromMap(theMap).get(key)).isEmpty()) {
      MapSequence.fromMap(theMap).put(key, new ArrayList<SNode>());
    }
    ListSequence.fromList(MapSequence.fromMap(theMap).get(key)).addElement(value);
  }

  private List<List<SNode>> groupUniqueConsntraints(List<SNode> flatMappings) {
    final Map<SNode, List<SNode>> grped = MapSequence.fromMap(new WeakHashMap<SNode, List<SNode>>());

    ListSequence.fromList(flatMappings).visitAll((mpng) -> {
      if (SNodeOperations.isInstanceOf(SNodeOperations.getParent(mpng), CONCEPTS.EmbeddedMapping$xR)) {
        addToMap(grped, SNodeOperations.getParent(mpng), mpng);
      } else {
        addToMap(grped, mpng, mpng);
      }
    });

    final List<List<SNode>> asList = ListSequence.fromList(new ArrayList<List<SNode>>());
    SetSequence.fromSet(MapSequence.fromMap(grped).keySet()).visitAll((it) -> ListSequence.fromList(asList).addElement(MapSequence.fromMap(grped).get(it)));
    return asList;
  }


  private String createTableStatment(SNode em, String tableName) {
    StringBuilder st = new StringBuilder();

    st.append("/* entity " + INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget(em, LINKS.classConcept$r5Kr)) + "\n */\n");
    st.append(vendor.createTable(tableName) + "(\n ");

    List<SNode> mappings = EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em);
    SNode fm;
    SNode sizeopt = null;

    for (int i = 0; i < ListSequence.fromList(mappings).count(); i++) {
      //  prepare field :)
      fm = ListSequence.fromList(mappings).getElement(i);
      if ((boolean) FieldMapping__BehaviorDescriptor.isSizeGiven_id7kI3k5AZW9Y.invoke(fm)) {
        sizeopt = getSpecifiedSize(fm);

      } else {
        sizeopt = null;

      }

      if ((boolean) IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createNumber(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createNumber(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isString_id7kypvuI$E8Q.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createVarchar(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isDateTime_id7kypvuI$Eap.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createDateTime(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isLocalDate_id7kypvuI$EaY.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createLocalDate(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createVarchar(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isByteArray_id2zJhn9ScP3q.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.createBlob(fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else {
        throw new IllegalStateException("" + SNodeOperations.present(fm) + " not implemented in SqlTableDescriber. Type: " + SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0));

      }

      st.append("/* " + SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.property$JxuR), PROPS.propertyName$DLW4) + " */");
      if ((i + 1) < ListSequence.fromList(mappings).count()) {
        st.append(",\n ");
      }
    }

    if ((boolean) EntityMapping__BehaviorDescriptor.isOptimisticLocked_id17uSheOyWB$.invoke(em)) {
      st.append(",\n " + vendor.createTCN());
    }

    List<SNode> primKeyMappings = IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(em));
    List<SNode> uniqueMappings = ListSequence.fromList(EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em)).where((it) -> (boolean) FieldMapping__BehaviorDescriptor.isUnique_id_ALeoXvtt6.invoke(it)).toList();

    if (ListSequence.fromList(primKeyMappings).count() > 0 || ListSequence.fromList(uniqueMappings).count() > 0) {
      st.append(",\n");

      if (ListSequence.fromList(primKeyMappings).count() > 0) {
        st.append("\n " + vendor.createPrimKeyConstraint("PK_" + tableName, primKeyMappings) + ",");
      }
      if (ListSequence.fromList(uniqueMappings).count() > 0) {
        List<List<SNode>> grpd = groupUniqueConsntraints(uniqueMappings);

        for (int i = 0; i < ListSequence.fromList(grpd).count(); i++) {
          st.append("\n " + vendor.createUniqueConstraint("CONSTRAINT_" + i, ListSequence.fromList(grpd).getElement(i)) + ",");
        }

      }
      st.deleteCharAt(st.length() - 1);
    }


    st.append("\n); ");
    return st.toString();
  }


  private void createTableSchema(final StringBuilder st, SNode em, final String tableName) {
    st.append(createTableStatment(em, tableName));
    st.append("\n");


    ListSequence.fromList(EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em)).where((fld) -> (boolean) FieldMapping__BehaviorDescriptor.isIndex_id7kI3k5B4ZsO.invoke(fld)).visitAll((fld) -> {
      st.append("CREATE ");

      if (!((boolean) FieldMapping__BehaviorDescriptor.usedInReferenceMapping_id1H_ywRYwCUj.invoke(fld)) && !((boolean) FieldMapping__BehaviorDescriptor.usedInReferenceMappingEmbedded_idOgrTNEEj5w.invoke(fld)) && !((boolean) IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fld, LINKS.property$JxuR), LINKS.type$56v0)))) {
        st.append("UNIQUE ");
      }

      st.append("INDEX " + schemaNdot(tableName) + "I_" + table(tableName) + "_" + SPropertyOperations.getString(SLinkOperations.getTarget(fld, LINKS.fieldName$un98), PROPS.value$w7MM) + " ON " + tableName + " (" + SPropertyOperations.getString(SLinkOperations.getTarget(fld, LINKS.fieldName$un98), PROPS.value$w7MM) + ");\n");

    });
  }

  public String getSchemaForPersistenceDesc(final SNode pd) {
    final StringBuilder st = new StringBuilder();

    st.append("\n\n\n\n/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n   " + SPropertyOperations.getString(pd, PROPS.name$MnvL) + "  in  " + SModelOperations.getModelName(SNodeOperations.getModel(pd)) + "\n */\n\n");


    // filter on most extensive map .. 
    final List<SNode> mostExtensive = ListSequence.fromList(new ArrayList<SNode>());
    ListSequence.fromList(SLinkOperations.getChildren(pd, LINKS.persistenceMapping$S18_)).select((it) -> SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.tableName$PpjQ), PROPS.value$w7MM)).distinct().visitAll((final String tableName) -> {

      SNode ext = ListSequence.fromList(SLinkOperations.getChildren(pd, LINKS.persistenceMapping$S18_)).where((it) -> tableName.equals(SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.tableName$PpjQ), PROPS.value$w7MM))).sort((it) -> ListSequence.fromList(IMapsClassConcept__BehaviorDescriptor.getMappedProperties_idKou8LemJfQ.invoke(it)).count(), false).first();
      ListSequence.fromList(mostExtensive).addElement(ext);
    });


    ListSequence.fromList(mostExtensive).visitAll((final SNode em) -> {
      String origTableName = SPropertyOperations.getString(SLinkOperations.getTarget(em, LINKS.tableName$PpjQ), PROPS.value$w7MM);
      createTableSchema(st, em, origTableName);

      SNode fmWithSeq = ListSequence.fromList(EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em)).findFirst((it) -> (boolean) FieldMapping__BehaviorDescriptor.isAutoKey_id2Oo32eoNPGM.invoke(it));
      if ((fmWithSeq != null)) {
        st.append(vendor.createAutoIncrement(origTableName, SPropertyOperations.getString(SLinkOperations.getTarget(fmWithSeq, LINKS.fieldName$un98), PROPS.value$w7MM)));
      }


      ListSequence.fromList(EntityMapping__BehaviorDescriptor.getAdditionalTableNames_id5Wi2c3mtlfs.invoke(em)).visitAll(new _FunctionTypes._void_P1_E0<SNode>() {
        public void invoke(SNode alt) {
          st.append("\n");
          String tableName = SPropertyOperations.getString(SLinkOperations.getTarget(alt, LINKS.tablename$LZwA), PROPS.value$w7MM);
          createTableSchema(st, em, tableName);

          SNode fmWithSeq = ListSequence.fromList(EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em)).findFirst((it) -> (boolean) FieldMapping__BehaviorDescriptor.isAutoKey_id2Oo32eoNPGM.invoke(it));
          if ((fmWithSeq != null)) {
            st.append(vendor.createAutoIncrement(tableName, SPropertyOperations.getString(SLinkOperations.getTarget(fmWithSeq, LINKS.fieldName$un98), PROPS.value$w7MM)));
          }

        }
      });

      Sequence.fromIterable(EntityMapping__BehaviorDescriptor.getAutoIdOptionsAndOverwrittens_id35a9wK6b6iq.invoke(em)).visitAll((it) -> {
        st.append(vendor.createSequence(IAutoIdProvider__BehaviorDescriptor.getSequenceName_id35a9wK71eOH.invoke(it)));

      });

      st.append("\n\n\n");
    });


    return st.toString();
  }

  private void createTableAlter(StringBuilder st, SNode em, String tableName) {

    st.append("/* entity " + INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget(em, LINKS.classConcept$r5Kr)) + "\n */\n");

    List<SNode> mappings = EntityMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYuKwa.invoke(em);
    SNode fm;
    SNode sizeopt;
    String lastFldName = null;

    for (int i = 0; i < ListSequence.fromList(mappings).count(); i++) {
      sizeopt = null;
      fm = ListSequence.fromList(mappings).getElement(i);

      if ((boolean) FieldMapping__BehaviorDescriptor.isSizeGiven_id7kI3k5AZW9Y.invoke(fm)) {
        sizeopt = getSpecifiedSize(fm);
      }


      if ((boolean) IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterNumber(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterNumber(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isString_id7kypvuI$E8Q.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterVarchar(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isDateTime_id7kypvuI$Eap.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterDateTime(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isLocalDate_id7kypvuI$EaY.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterLocalDate(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterVarchar(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else if ((boolean) IAtomMapping__BehaviorDescriptor.isByteArray_id2zJhn9ScP3q.invoke(SNodeOperations.asSConcept(CONCEPTS.IAtomMapping$dv), SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0))) {
        st.append(vendor.alterBlob(tableName, lastFldName, fm, SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM), sizeopt, (boolean) FieldMapping__BehaviorDescriptor.isNotNull_id7kI3k5AZWgi.invoke(fm)));

      } else {
        throw new IllegalStateException("" + SNodeOperations.present(fm) + " not implemented in SqlTableDescriber ALTER. Type: " + SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0));

      }

      if (i < ListSequence.fromList(mappings).count()) {
        st.append(";\n");
      }
      lastFldName = SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM);
    }

    if ((boolean) EntityMapping__BehaviorDescriptor.isOptimisticLocked_id17uSheOyWB$.invoke(em)) {
      st.append(vendor.alterTCN(tableName, lastFldName) + ";");
    }

    st.toString();
  }


  public String getAlterForPersistenceDesc(SNode pd) {
    final StringBuilder st = new StringBuilder();

    st.append("\n\n\n\n/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n   " + SPropertyOperations.getString(pd, PROPS.name$MnvL) + "  in  " + SModelOperations.getModelName(SNodeOperations.getModel(pd)) + "\n */\n\n");

    ListSequence.fromList(SLinkOperations.getChildren(pd, LINKS.persistenceMapping$S18_)).visitAll((final SNode em) -> {
      String origTableName = SPropertyOperations.getString(SLinkOperations.getTarget(em, LINKS.tableName$PpjQ), PROPS.value$w7MM);
      createTableAlter(st, em, origTableName);

      ListSequence.fromList(EntityMapping__BehaviorDescriptor.getAdditionalTableNames_id5Wi2c3mtlfs.invoke(em)).visitAll((alt) -> {
        st.append("\n\n");
        String tableName = SPropertyOperations.getString(SLinkOperations.getTarget(alt, LINKS.tablename$LZwA), PROPS.value$w7MM);
        createTableAlter(st, em, tableName);
      });

      st.append("\n\n\n");
    });


    return st.toString();
  }




  private static String schemaNdot(String name) {
    if (name.contains(".")) {
      return name.substring(0, name.indexOf(".") + 1);
    }
    return "";
  }
  private static String table(String name) {
    if (name.contains(".")) {
      return name.substring(name.indexOf(".") + 1);
    }
    return name;
  }

  private static final class LINKS {
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink mappingOption$nC$y = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xabe89ec19332c50L, "mappingOption");
    /*package*/ static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e4730efL, "classConcept");
    /*package*/ static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e480de7L, "fieldName");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink persistenceMapping$S18_ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, 0xc18788c4e46d0b0L, "persistenceMapping");
    /*package*/ static final SContainmentLink tableName$PpjQ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e5a1501L, "tableName");
    /*package*/ static final SContainmentLink tablename$LZwA = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x5f1208c0d630fd8fL, 0x5f1208c0d63103adL, "tablename");
  }

  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept IOptionsProvider$mY = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x456167da9b1804cL, "org.modellwerkstatt.manmap.structure.IOptionsProvider");
    /*package*/ static final SConcept SizeOption$QV = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xabe89ec1935f3e3L, "org.modellwerkstatt.manmap.structure.SizeOption");
    /*package*/ static final SInterfaceConcept ISizeSpecified$DJ = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7c020517ea31000dL, "org.modellwerkstatt.manmap.structure.ISizeSpecified");
    /*package*/ static final SConcept UniqueOption$bS = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x5e02619d8497320dL, "org.modellwerkstatt.manmap.structure.UniqueOption");
    /*package*/ static final SConcept EmbeddedMapping$xR = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476ab6L, "org.modellwerkstatt.manmap.structure.EmbeddedMapping");
    /*package*/ static final SInterfaceConcept IAtomMapping$dv = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e4758c3L, "org.modellwerkstatt.manmap.structure.IAtomMapping");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }
}
