package org.modellwerkstatt.manmap.findUsages;

/*Generated by MPS */

import jetbrains.mps.ide.findusages.findalgorithm.finders.GeneratedFinder;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.module.SearchScope;
import jetbrains.mps.ide.findusages.findalgorithm.finders.IFinder;
import org.jetbrains.mps.openapi.util.ProgressMonitor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import java.util.Set;
import java.util.HashSet;
import org.jetbrains.mps.openapi.module.FindUsagesFacade;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mps.openapi.model.SNodeReference;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SProperty;

public class FindTableAndFieldNames_Finder extends GeneratedFinder {
  public FindTableAndFieldNames_Finder() {
  }
  @Override
  public String getDescription() {
    return "Table/field names";
  }
  @Override
  public String getLongDescription() {
    return "find table and field names in sql strings";
  }
  @Override
  public SAbstractConcept getSConcept() {
    return CONCEPTS.StringLiteral$xu;
  }
  @Override
  public boolean isApplicable(SNode node) {
    return (SNodeOperations.getNodeAncestor(node, CONCEPTS.EntityMapping$ux, false, false) != null);
  }

  @Override
  protected void doFind0(@NotNull SNode node, SearchScope scope, final IFinder.FindCallback callback, ProgressMonitor monitor) {
    try {
      String lookingForName = SPropertyOperations.getString(node, PROPS.value$w7MM).toLowerCase();
      SAbstractConcept stringLiteralConcept = SNodeOperations.getConcept(node);
      SAbstractConcept lineConcept = CONCEPTS.Line$yC;

      Set<SAbstractConcept> lookingFor = new HashSet<SAbstractConcept>();
      lookingFor.add(stringLiteralConcept);
      lookingFor.add(lineConcept);

      Set<SNode> allStringLiteral = FindUsagesFacade.getInstance().findInstances(scope, lookingFor, false, monitor);

      List<SNode> result = CustomSqlFinderHelper.search(allStringLiteral, lookingForName);
      ListSequence.fromList(result).visitAll((it) -> callback.onUsageFound(createSingleResult(it)));
    } finally {
      monitor.done();
    }
  }


  @Nullable
  @Override
  public SNodeReference getDeclarationNode() {
    return buildNodePointer(FindUsagesDescriptor.DECLARING_MODEL, "4042330433291048579");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept StringLiteral$xu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, "jetbrains.mps.baseLanguage.structure.StringLiteral");
    /*package*/ static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, "org.modellwerkstatt.manmap.structure.EntityMapping");
    /*package*/ static final SConcept Line$yC = MetaAdapterFactory.getConcept(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x2331694e561af166L, "jetbrains.mps.lang.text.structure.Line");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
  }
}
