package org.modellwerkstatt.manmap.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import java.awt.datatransfer.Clipboard;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;

public final class CopyFromClipboard_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public CopyFromClipboard_Intention() {
    super(Kind.NORMAL, true, new SNodePointer("r:458f9c42-4b01-4cad-92b9-171a7cd02e72(org.modellwerkstatt.manmap.intentions)", "6516030280902129610"));
  }

  @Override
  public String getPresentation() {
    return "CopyFromClipboard";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      return "Paste SQL";
    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
      String data = null;

      try {
        data = (String) clipboard.getData(DataFlavor.stringFlavor);

      } catch (UnsupportedFlavorException ex) {
        ex.printStackTrace();

      } catch (IOException ex) {
        ex.printStackTrace();

      }

      if (data != null) {
        String[] lines = data.split("[\\r\\n]+");
        boolean first = true;

        for (String singleLine : lines) {
          SNode newLine;
          if (first && ListSequence.fromList(SLinkOperations.getChildren(node, LINKS.newText$XAoY)).count() > 0) {
            newLine = ListSequence.fromList(SLinkOperations.getChildren(node, LINKS.newText$XAoY)).last();
          } else {
            newLine = SLinkOperations.addNewChild(node, LINKS.newText$XAoY, null);
          }

          SPropertyOperations.assign(SLinkOperations.addNewChild(newLine, LINKS.elements$_j45, CONCEPTS.Word$Dn), PROPS.value$zQr_, singleLine);
          first = false;
        }
      }
    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      return true;
    }



    @Override
    public IntentionDescriptor getDescriptor() {
      return CopyFromClipboard_Intention.this;
    }

  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink newText$XAoY = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6e6706e518453b9cL, 0x7f9c9234cfb52bcbL, "newText");
    /*package*/ static final SContainmentLink elements$_j45 = MetaAdapterFactory.getContainmentLink(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x2331694e561af166L, 0x2331694e561af167L, "elements");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Word$Dn = MetaAdapterFactory.getConcept(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x229012ddae35f04L, "jetbrains.mps.lang.text.structure.Word");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$zQr_ = MetaAdapterFactory.getProperty(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x229012ddae35f04L, 0x229012ddae35f05L, "value");
  }
}
