package org.modellwerkstatt.manmap.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionAspectDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Map;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import java.util.Arrays;
import jetbrains.mps.lang.smodel.ConceptSwitchIndex;
import jetbrains.mps.lang.smodel.ConceptSwitchIndexBuilder;
import jetbrains.mps.smodel.adapter.ids.MetaIdFactory;

public final class IntentionsDescriptor extends AbstractIntentionAspectDescriptor {
  private static final IntentionFactory[] EMPTY_ARRAY = new IntentionFactory[0];
  private Map<SAbstractConcept, IntentionFactory[]> myCached = new HashMap<SAbstractConcept, IntentionFactory[]>();

  public IntentionsDescriptor() {
  }

  @Nullable
  public Collection<IntentionFactory> getIntentions(@NotNull SAbstractConcept concept) {
    if (myCached.containsKey(concept)) {
      return Arrays.asList(myCached.get(concept));
    }

    IntentionFactory[] intentions = EMPTY_ARRAY;
    SAbstractConcept cncpt = concept;
    switch (conceptIndex.index(cncpt)) {
      case 0:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new DeleteWithMap_ToggleDebug_Intention();
        }
        break;
      case 1:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new NewLineMappingRef_Intention();
        }
        break;
      case 2:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new NewLineMappingOptional_Intention();
        }
        break;
      case 3:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new ToggleReadOnly_Intention();
          intentions[1] = new QueryFromMap_ToggleDebug_Intention();
        }
        break;
      case 4:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new QueryFromSqlRowParamMissing_Intention();
          intentions[1] = new QueryFromSql_ExtractNP_Intention();
        }
        break;
      case 5:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new SaveWithMap_ToggleDebug_Intention();
        }
        break;
      case 6:
        if (true) {
          // concept
          intentions = new IntentionFactory[3];
          intentions[0] = new RemoveSqlRichText_Intention();
          intentions[1] = new CopyToClipboard_Intention();
          intentions[2] = new CopyFromClipboard_Intention();
        }
        break;
      case 7:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new UpdateFromSql_ExtractNP_Intention();
        }
        break;
      default:
    }
    myCached.put(concept, intentions);
    return Arrays.asList(intentions);
  }

  @NotNull
  @Override
  public Collection<IntentionFactory> getAllIntentions() {
    IntentionFactory[] rv = new IntentionFactory[12];
    rv[0] = new ToggleReadOnly_Intention();
    rv[1] = new QueryFromSqlRowParamMissing_Intention();
    rv[2] = new RemoveSqlRichText_Intention();
    rv[3] = new NewLineMappingRef_Intention();
    rv[4] = new SaveWithMap_ToggleDebug_Intention();
    rv[5] = new QueryFromMap_ToggleDebug_Intention();
    rv[6] = new DeleteWithMap_ToggleDebug_Intention();
    rv[7] = new CopyToClipboard_Intention();
    rv[8] = new CopyFromClipboard_Intention();
    rv[9] = new UpdateFromSql_ExtractNP_Intention();
    rv[10] = new QueryFromSql_ExtractNP_Intention();
    rv[11] = new NewLineMappingOptional_Intention();
    return Arrays.asList(rv);
  }
  private static final ConceptSwitchIndex conceptIndex = new ConceptSwitchIndexBuilder().put(MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7169e0804470a099L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1b658a0dfe786f67L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7bb9beb8d860d0edL), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xabe89ec1936325aL), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3ccdd74372e57d95L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7169e080446c5b92L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6e6706e518453b9cL), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7619f048c67aa842L)).seal();
}
