package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import java.math.BigDecimal;
import org.springframework.jdbc.core.JdbcTemplate;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.RowMapper;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.PreparedStatementCreator;
import java.sql.Connection;
import java.sql.ResultSet;

public abstract class MMClassMapper<Key, Entity extends IM3Entity<Key>> implements IM3ClassMapper<Key, Entity> {
  @Autowired
  @Qualifier("_dateTimeTypeHandler")
  protected IM3TypeHandler<DateTime> __dateTimeTypeHandler;
  @Autowired
  @Qualifier("_localDateTypeHandler")
  protected IM3TypeHandler<LocalDate> __localDateTypeHandler;
  @Autowired
  @Qualifier("_bigDecimalTypeHandler")
  protected IM3TypeHandler<BigDecimal> __bigDecimalTypeHandler;
  @Autowired
  @Qualifier("_stringTypeHandler")
  protected IM3TypeHandler<String> __stringTypeHandler;
  @Autowired
  @Qualifier("_intTypeHandler")
  protected IM3TypeHandler<Integer> __intTypeHandler;
  @Autowired
  @Qualifier("_byteArrayTypeHandler")
  protected IM3TypeHandler<byte[]> __byteArrayTypeHandler;

  @Autowired
  protected IM3DatabaseDescription __dbDesc;
  @Autowired
  protected JdbcTemplate __jdbcTemplate;

  protected String __mapperFqName;
  protected String __classFqName;
  protected String __defaultTableName;

  public MMClassMapper(String mapperFqName, String classFqName, String dfltTable) {
    __mapperFqName = mapperFqName;
    __classFqName = classFqName;
    __defaultTableName = dfltTable;
  }

  public String getEntityFQName() {
    return __classFqName;
  }

  protected abstract String getTableNameFromRef(String refName);

  public String getCurrentTableName(IM3DynamicTableEvaluator[] evaluators) {

    if (evaluators == null || evaluators.length == 0) {
      return __defaultTableName;
    }

    for (int i = 0; i < evaluators.length; i++) {
      if (evaluators[i].useTableRefName()) {
        return getTableNameFromRef(evaluators[i].getTableRefName());
      }
    }

    return __defaultTableName;
  }

  protected abstract void setParametersInsert(Entity entity, PreparedStatement preparedStatement, StringBuilder debugSb) throws SQLException;
  protected abstract void setParametersUpdate(Entity entity, PreparedStatement preparedStatement, StringBuilder debugSb) throws SQLException;

  protected abstract void doUpdateAuditForEntity(Entity entity, IM3Session session);
  protected abstract void doInsertAuditForEntity(Entity entity, IM3Session session);

  public void __insert(final Entity entity, boolean audit, String sql, SequenceSetter<Entity> seqSetter, IM3Session session, Object debugTextOrNull) {
    final StringBuilder paramInfo = new StringBuilder("Parameters:\n");

    if (entity.getReadOnly()) {
      throw new IllegalStateException("Insert called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
    }

    if (!(entity.getDirty())) {
      throw new IllegalStateException("Insert called on entity which was not marked as dirty. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
    }

    // before changing anything in entity, like tcn, audit etc.
    entity.beforeSave();
    if (audit) {
      doInsertAuditForEntity(entity, session);
    }

    int retValue = 0;
    try {
      // set keys in object
      if (__dbDesc.needsSequenceSelectPre()) {
        seqSetter.setValues(entity);
      }

      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
      }

      // run insert
      retValue = __jdbcTemplate.update(sql, new PreparedStatementSetter() {
        public void setValues(PreparedStatement preparedStatement) throws SQLException {
          setParametersInsert(entity, preparedStatement, paramInfo);
        }
      });

      // Dirty is cleared in transaction
      if (__dbDesc.needsIdSelectPost()) {
        seqSetter.setValues(entity);
      }

      // add to session keystore
      if (session != null) {
        MMObjectKeyStore<Key, Entity> keyStore = session.getOrCreateKeyStore(getEntitySessionUID());
        Entity existingEntity = keyStore.get(entity.getIM3Key());
        if (existingEntity != null) {
          throw new IllegalStateException("Entity " + getEntityFQName() + " (key " + entity.getIM3Key() + ") was already checked out as r/o or r/w, insert no possible");
        }

        keyStore.set(entity.getIM3Key(), entity);
      }

    } catch (DataAccessException dae) {
      // DataAccessException do not report on key and tcn of entity, have to do it manually here.
      dae.addSuppressed(new MMAdditionalInfoException("INSERT() led to an exception due to " + getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
      throw dae;
    }

    if (retValue != 1) {
      throw new IncorrectResultSetColumnCountException("INSERT() " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
    }



  }
  public void __update(final Entity entity, boolean audit, String sql, IM3Session session, Object debugTextOrNull) {

    final StringBuilder paramInfo = new StringBuilder("Parameters:\n");

    if (entity.getReadOnly()) {
      throw new IllegalStateException("Update called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
    }

    // before changing anything in entity, like tcn, audit etc.
    entity.beforeSave();
    // MM3 - can not check on getDirty(). Might not be dirty, but update called: can happen under force audit
    if (audit) {
      doUpdateAuditForEntity(entity, session);
    }

    int retValue = 0;
    try {
      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - key " + entity.getIM3Key() + ", tcn " + entity.getTCN());
      }

      retValue = __jdbcTemplate.update(sql, new PreparedStatementSetter() {
        public void setValues(PreparedStatement preparedStatement) throws SQLException {
          setParametersUpdate(entity, preparedStatement, paramInfo);
        }
      });

    } catch (DataAccessException dae) {
      dae.addSuppressed(new MMAdditionalInfoException("UPDATE() led to an exception due to " + getEntityFQName() + " (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
      throw dae;
    }

    if (retValue != 1) {
      throw new IncorrectResultSetColumnCountException("UPDATE() " + getEntityFQName() + " - key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
    } else {
      entity.setTCN(entity.getTCN() + 1);
    }
  }

  public void __batchInsert(final List<Entity> listOfEntities, final int numOfEntities, String sql, IM3Session session, Object debugTextOrNull) {

    final StringBuilder paramInfo = new StringBuilder("Batch Insert - Can not provide parameters.\n");

    int[] retValue;
    try {
      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - batch insert for " + numOfEntities + " entities.");
      }

      // run insert
      retValue = __jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
        @Override
        public void setValues(PreparedStatement preparedStatement, int num) throws SQLException {
          setParametersInsert(listOfEntities.get(num), preparedStatement, null);
        }
        @Override
        public int getBatchSize() {
          return numOfEntities;
        }
      });

      for (int i = 0; i < retValue.length; i++) {
        if (retValue[i] != 1) {
          throw new IncorrectResultSetColumnCountException("BATCH INSERT() " + getEntityFQName() + " - index pos " + i + ", key[" + i + "] " + listOfEntities.get(i).getIM3Key() + " ,tcn[" + i + "] " + listOfEntities.get(i).getTCN() + " (" + retValue[i] + " rows affected).", 1, retValue[i]);
        }

      }

      // Dirty is cleared in transaction
      // add to session keystore
      if (session != null) {
        MMObjectKeyStore<Key, Entity> keyStore = session.getOrCreateKeyStore(getEntitySessionUID());

        for (Entity newEntity : listOfEntities) {
          Entity existingEntity = keyStore.get(newEntity.getIM3Key());
          if (existingEntity != null) {
            throw new IllegalStateException("Entity " + getEntityFQName() + " (key " + newEntity.getIM3Key() + ") was already checked out as r/o or r/w, insert no possible");
          }

          // else add to session
          keyStore.set(newEntity.getIM3Key(), newEntity);
        }
      }



    } catch (UncategorizedSQLException uncat) {
      uncat.addSuppressed(new MMAdditionalInfoException("BATCH INSERT() led to an UncategorizedSQLException updating " + getEntityFQName() + " (" + listOfEntities.size() + " entities): " + uncat.getMessage() + "\n" + paramInfo.toString()));
      throw uncat;

    } catch (DataAccessException dae) {
      // DataAccessException do not report on key and tcn of entity, have to do it manually here.
      dae.addSuppressed(new MMAdditionalInfoException("BATCH INSERT() led to an exception while inserting " + getEntityFQName() + " (" + listOfEntities.size() + " entities)\n" + paramInfo.toString()));
      throw dae;
    }
  }


  public void __batchUpdate(final List<Entity> listOfEntities, boolean audit, String sql, IM3Session session, Object debugTextOrNull) {

    final int numOfEntities = listOfEntities.size();

    final StringBuilder paramInfo = new StringBuilder("Batch Update - Can not provide parameters.\n");

    for (Entity entity : listOfEntities) {

      if (entity.getReadOnly()) {
        throw new IllegalStateException("Batch update called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
      }

      // MM3 - can not check on getDirty(). Might not be dirty, but update called: can happen under force audit
      // before changing anything in entity, like tcn, audit etc.
      entity.beforeSave();
      if (audit) {
        doUpdateAuditForEntity(entity, session);
      }
    }

    int[] retValue;
    try {
      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - batch insert for " + numOfEntities + " entities.");
      }

      // run insert
      retValue = __jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
        @Override
        public void setValues(PreparedStatement preparedStatement, int num) throws SQLException {
          setParametersUpdate(listOfEntities.get(num), preparedStatement, null);
        }

        @Override
        public int getBatchSize() {
          return numOfEntities;
        }
      });

      if (numOfEntities != retValue.length) {
        throw new IncorrectResultSetColumnCountException("BATCH UPDATE() " + getEntityFQName() + " - update of " + numOfEntities + " entities resulted in " + retValue.length + " batch update return values.", numOfEntities, retValue.length);
      }

      for (int i = 0; i < retValue.length; i++) {
        if (retValue[i] != 1) {
          throw new IncorrectResultSetColumnCountException("BATCH UPDATE() " + getEntityFQName() + " - index pos " + i + ", key[" + i + "] " + listOfEntities.get(i).getIM3Key() + ", tcn[" + i + "] " + listOfEntities.get(i).getTCN() + " (" + retValue[i] + " rows affected).", 1, retValue[i]);
        }
      }

      // Dirty is cleared in transaction
      for (Entity entity : listOfEntities) {
        entity.setTCN(entity.getTCN() + 1);
      }


    } catch (UncategorizedSQLException uncat) {
      uncat.addSuppressed(new MMAdditionalInfoException("BATCH UPDATE() led to an UncategorizedSQLException updating " + getEntityFQName() + " (" + listOfEntities.size() + " entities): " + uncat.getMessage() + "\n" + paramInfo.toString()));
      throw uncat;

    } catch (DataAccessException dae) {
      // DataAccessException do not report on key and tcn of entity, have to do it manually here.
      dae.addSuppressed(new MMAdditionalInfoException("BATCH UPDATE() led to an exception updating " + getEntityFQName() + " (" + listOfEntities.size() + " entities)\n" + paramInfo.toString()));
      throw dae;
    }
  }

  public void __delete(Entity entity, String sql, PreparedStatementSetter setter, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {

    // should not delete readonly entities ..
    if (entity.getReadOnly()) {
      throw new IllegalStateException("Delete called on entity which was marked as readonly. (key " + entity.getIM3Key() + ")");
    }

    try {
      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
      }

      int retValue = __jdbcTemplate.update(sql, setter);

      // check retValue here, double log.
      if (retValue != 1) {
        throw new IncorrectResultSetColumnCountException("DELETE() " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
      }

    } catch (DataAccessException dae) {
      // log ex
      dae.addSuppressed(new MMAdditionalInfoException("DELETE() led to an exception due to " + getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
      throw dae;

    }

    // remove object from session
    if (session != null) {
      MMObjectKeyStore<Key, Entity> keyStore = session.getOrCreateKeyStore(getEntitySessionUID());
      // key ?
      if (keyStore.has(entity.getIM3Key())) {
        // dan, May 2021, changed from keystore.set(entity.getIMKey(), null) to
        keyStore.removeEntity(entity);
      }
    }
  }


  public void __reload(Entity entity, String sql, PreparedStatementSetter setter, RowMapper mapper, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {
    boolean wasReadOnly = entity.getReadOnly();
    try {
      if (wasReadOnly) {
        entity.setReadOnly(false);
      }

      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
      }

      List<Entity> objects = (List<Entity>) __jdbcTemplate.query(sql, setter, mapper);

      // check retValue here, double log.
      if (objects.size() != 1) {
        throw new IncorrectResultSetColumnCountException("RELOAD() " + getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + objects.size() + " object affected).", 1, objects.size());
      }

    } catch (DataAccessException dae) {
      // log details first
      dae.addSuppressed(new MMAdditionalInfoException("RELOAD() led to an exception due to " + getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
      throw dae;

    } finally {
      if (wasReadOnly) {
        entity.setReadOnly(true);
      }

    }
  }

  public Entity __get(Key key, boolean readOnly, String sql, PreparedStatementSetter setter, RowMapper mapper, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {

    MMObjectKeyStore<Key, Entity> keyStore = null;

    // working with session
    if (session != null) {
      keyStore = session.getOrCreateKeyStore(getEntitySessionUID());
      Entity entity = keyStore.get(key);

      if (entity != null) {
        // ok, the object was found ... we are readonly
        // the entity too - that s ok
        if (readOnly && entity.getReadOnly()) {
          return entity;
        }

        // else ... this is a problem
        throw new IllegalStateException("Entity " + getEntityFQName() + " (key " + key + ") was already checked out as r/o or r/w");
      }
    }

    try {
      if (debugTextOrNull != null) {
        ManmapIDEDebug.printDebugMsgToIDE("" + debugTextOrNull + ": " + sql + "\nfor " + getEntityFQName() + " - key " + key);
      }

      // prepared statement for query ...
      List<Entity> retObjects = __jdbcTemplate.query(sql, setter, mapper);


      // check retValue here
      if (retObjects.size() != 1) {
        throw new IncorrectResultSetColumnCountException("GET() " + getEntityFQName() + " - key " + key + " ,tcn (none)" + " (" + retObjects.size() + " objects retrieved).", 1, retObjects.size());
      }


      Entity entity = retObjects.get(0);
      // working with session, we do have a keyStore
      if (keyStore != null) {
        keyStore.set(key, entity);
      }
      entity.clearDirtySetReadonly(readOnly);
      return entity;

    } catch (DataAccessException dae) {
      // log problem in detail
      dae.addSuppressed(new MMAdditionalInfoException("GET() led to an exception due to " + getEntityFQName() + " (key " + key + " ,tcn none)\n" + paramInfo.toString()));
      throw dae;
    }
  }

  protected void paramsIntoPreparedStatement(PreparedStatement statement, List<Object> params, StringBuilder debugSb) throws DataAccessException, SQLException {

    for (int i = 0; i < ListSequence.fromList(params).count(); i++) {
      if (ListSequence.fromList(params).getElement(i) instanceof Integer) {
        __intTypeHandler.setParameter(statement, i + 1, (Integer) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof String) {
        __stringTypeHandler.setParameter(statement, i + 1, (String) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof DateTime) {
        __dateTimeTypeHandler.setParameter(statement, i + 1, (DateTime) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof LocalDate) {
        __localDateTypeHandler.setParameter(statement, i + 1, (LocalDate) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof BigDecimal) {
        __bigDecimalTypeHandler.setParameter(statement, i + 1, (BigDecimal) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof byte[]) {
        __byteArrayTypeHandler.setParameter(statement, i + 1, (byte[]) ListSequence.fromList(params).getElement(i), debugSb);
      } else if (ListSequence.fromList(params).getElement(i) instanceof IM3Status) {
        // not allowed to be null here
        __stringTypeHandler.setParameter(statement, i + 1, ((IM3Status) ListSequence.fromList(params).getElement(i)).getDbValue(), debugSb);
      } else {
        String paramAsString = "" + ListSequence.fromList(params).getElement(i);
        throw new IllegalArgumentException(__mapperFqName + " mapper has no typehandler for " + paramAsString + " (arg number " + i + "). Presumably argument in query was null.");
      }
    }
  }

  public List<Entity> query(final String fullSqlStatement, ResultSetExtractor rs, final List<Object> params) {
    final StringBuilder debugSb = new StringBuilder("Parameters:\n");

    try {
      PreparedStatementCreator psc = new PreparedStatementCreator() {
        public PreparedStatement createPreparedStatement(Connection p0) throws SQLException {
          PreparedStatement statement = p0.prepareCall(fullSqlStatement);
          paramsIntoPreparedStatement(statement, params, debugSb);
          return statement;
        }
      };
      return (List<Entity>) __jdbcTemplate.query(psc, rs);

    } catch (DataAccessException dae) {
      dae.addSuppressed(new MMAdditionalInfoException("QUERY() led to an exception: " + fullSqlStatement + "\n" + debugSb.toString()));
      throw dae;
    }
  }


  public int queryCount(final String fullSqlStatement, final List<Object> params) {
    final StringBuilder debugSb = new StringBuilder("Parameters:\n");

    try {
      PreparedStatementCreator psc = new PreparedStatementCreator() {
        public PreparedStatement createPreparedStatement(Connection p0) throws SQLException {
          PreparedStatement statement = p0.prepareCall(fullSqlStatement);
          paramsIntoPreparedStatement(statement, params, debugSb);
          return statement;
        }
      };

      int result = __jdbcTemplate.query(psc, new ResultSetExtractor<Integer>() {
        public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
          int result = -1;
          while (rs.next()) {
            result = __intTypeHandler.getResult(rs, 1);
          }
          return result;
        }
      });
      if (result == -1) {
        throw new IncorrectResultSetColumnCountException("QUERYCOUNT() " + getEntityFQName() + " count() returned and empty resultset or -1 as count.", -1, -1);
      }
      return result;

    } catch (DataAccessException dae) {
      dae.addSuppressed(new MMAdditionalInfoException("QUERYCOUNT() led to an exception: " + fullSqlStatement + "\n" + debugSb.toString()));
      throw dae;
    }
  }


  public interface SequenceSetter<Ent> {
    void setValues(Ent ent);
  }
}
