package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import org.springframework.beans.factory.annotation.Autowired;
import javax.sql.DataSource;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.SQLException;

public class MMOracleDescription implements IM3DatabaseDescription {
  private static final int ORACLE_MAX_EXP = 999;
  @Autowired
  private DataSource dataSource;

  public boolean needsSequenceSelectPre() {
    return true;
  }
  public boolean needsIdSelectPost() {
    return false;
  }
  public String castAsDate(String orig) {
    // check: http://blog.jooq.org/2014/12/22/are-you-binding-your-oracle-dates-correctly-i-bet-you-arent/
    return " CAST( " + orig + " AS DATE) ";
  }
  public String getTimeStampQuery() {
    return "SELECT SYSTIMESTAMP FROM DUAL";
  }
  public String queryForKey(String sequenceName) {
    return "SELECT " + sequenceName + ".NEXTVAL FROM DUAL";
  }
  public String queryForListOfKey(String sequenceName, int num) {
    return "SELECT " + sequenceName + ".NEXTVAL FROM (SELECT level FROM DUAL CONNECT BY level <= " + num + ")";
  }
  public void handleInOperatorInQuery(String fieldName, List<?> listOfObjects, StringBuilder whereStatement, List<Object> queryParams) {
    int size = ListSequence.fromList(listOfObjects).count();

    if (size > 0 && size < ORACLE_MAX_EXP) {
      whereStatement.append(fieldName + " in (");
      for (int i = 0; i < size; i++) {
        ListSequence.fromList(queryParams).addElement(ListSequence.fromList(listOfObjects).getElement(i));
        whereStatement.append("?");
        if ((i + 1) < size) {
          whereStatement.append(",");
        }
      }
      whereStatement.append(")");

    } else if (size > 0) {
      whereStatement.append("(1, " + fieldName + ") in (");
      for (int i = 0; i < size; i++) {
        ListSequence.fromList(queryParams).addElement(ListSequence.fromList(listOfObjects).getElement(i));
        whereStatement.append("(1, ?)");
        if ((i + 1) < size) {
          whereStatement.append(",");
        }
      }
      whereStatement.append(")");
    } else {
      whereStatement.append("0=1");
    }
  }

  @Override
  public void handleLimitQuery(StringBuilder whereStatement, int count) {
    whereStatement.append(" FETCH NEXT " + count + " ROWS ONLY");
  }

  public void setSessionInfo(String appNameVersionInfo) {

    appNameVersionInfo = appNameVersionInfo.replace(" ", "_");
    String sqlStatement = "BEGIN dbms_application_info.set_client_info('" + appNameVersionInfo + "'); END;";

    boolean initSqlCalled = false;
    try {
      Class cls = dataSource.getClass();
      Method m = cls.getMethod("setInitSQL", String.class);
      m.invoke(dataSource, sqlStatement);
      initSqlCalled = true;

    } catch (NoSuchMethodException e) {
      // method not found. 
    } catch (InvocationTargetException e) {
      // was not able to invoke it...
    } catch (IllegalAccessException e) {
    }

    if (!(initSqlCalled)) {
      try {
        // run it manually
        Connection con = dataSource.getConnection();
        Statement statement = con.createStatement();
        statement.execute(sqlStatement);
        con.close();

      } catch (SQLException e) {
        e.printStackTrace();
      }

    }
  }
}
