package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import org.modellwerkstatt.manmap.behavior.SqlString__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.util.CreateDefaultNoKeyMappingForManMap;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public final class AutoCompleteNoKeyMapping_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public AutoCompleteNoKeyMapping_Intention() {
    super(Kind.NORMAL, true, new SNodePointer("r:034603ed-8e73-486e-af2c-268865f08e38(org.modellwerkstatt.objectflow.intentions)", "2293420379403843218"));
  }

  @Override
  public String getPresentation() {
    return "AutoCompleteNoKeyMapping";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      return "Create DTO and NoKeyMapping for SQL-Query";
    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      String sqlStatement = SqlString__BehaviorDescriptor.getCleanedSql_id6TB1IkoDjkO.invoke(node);

      String voName = CreateDefaultNoKeyMappingForManMap.isoltateViewObjectName(sqlStatement);
      String[] fields = CreateDefaultNoKeyMappingForManMap.isoltateFields(sqlStatement);
      if (voName == null || fields == null) {
        System.err.println("\n\nCAN NOT RUN AUTOCOMPLETE NOKEYMAPPING: sql string not correct, can not isolate DTO's name (" + voName + ") or fields (" + fields + ").\n\n");
      }

      SNode vo = CreateDefaultNoKeyMappingForManMap.createAndAddViewObjectFromSql(SNodeOperations.getModel(node), voName, fields);
      SNode mapper = CreateDefaultNoKeyMappingForManMap.createAndAddViewObjectFromSql(SNodeOperations.getNodeAncestor(node, CONCEPTS.Repository$WM, false, false), vo, fields);

      SNode qfs = SNodeOperations.getNodeAncestor(node, CONCEPTS.QueryFromSql$5R, false, false);
      SNodeFactoryOperations.setNewChild(qfs, LINKS.packaging$_5Ef, CONCEPTS.NoKeyMapperFieldRef$Vu);
      SLinkOperations.setTarget(SNodeOperations.cast(SLinkOperations.getTarget(qfs, LINKS.packaging$_5Ef), CONCEPTS.NoKeyMapperFieldRef$Vu), LINKS.noKeyMapperField$RKjG, mapper);
    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      return true;
    }



    @Override
    public IntentionDescriptor getDescriptor() {
      return AutoCompleteNoKeyMapping_Intention.this;
    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept QueryFromSql$5R = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3ccdd74372e57d95L, "org.modellwerkstatt.manmap.structure.QueryFromSql");
    /*package*/ static final SConcept NoKeyMapperFieldRef$Vu = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad95725532e1d33L, "org.modellwerkstatt.manmap.structure.NoKeyMapperFieldRef");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink packaging$_5Ef = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3ccdd74372e57d95L, 0x40a5d95b5ab1830eL, "packaging");
    /*package*/ static final SReferenceLink noKeyMapperField$RKjG = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad95725532e1d33L, 0xad95725532e1d3dL, "noKeyMapperField");
  }
}
