package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.IAttributeDescriptor;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import org.modellwerkstatt.objectflow.util.OFXUtil;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;

public final class FailAnnotationIntentionStatement_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public FailAnnotationIntentionStatement_Intention() {
    super(Kind.NORMAL, false, new SNodePointer("r:034603ed-8e73-486e-af2c-268865f08e38(org.modellwerkstatt.objectflow.intentions)", "8113764509537699422"));
  }

  @Override
  public String getPresentation() {
    return "FailAnnotationIntentionStatement";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      if ((SNodeOperations.getNodeAncestor(node, CONCEPTS.OFXTestFailInAttribue$T4, true, false) != null)) {
        return "Fail In: Remove 'Exception expected'.";

      } else if ((new IAttributeDescriptor.NodeAttribute(CONCEPTS.OFXTestFailInAttribue$T4).get(node) != null)) {
        return "Fail In: Remove 'Exception expected'.";

      } else {
        return "Fail In: Mark as 'Exception expected'.";

      }

    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      SNode failInAttrib = SNodeOperations.getNodeAncestor(node, CONCEPTS.OFXTestFailInAttribue$T4, true, false);
      if ((failInAttrib != null)) {
        SNodeOperations.deleteNode(failInAttrib);

      } else if ((new IAttributeDescriptor.NodeAttribute(CONCEPTS.OFXTestFailInAttribue$T4).get(node) != null)) {
        SNodeOperations.deleteNode(new IAttributeDescriptor.NodeAttribute(CONCEPTS.OFXTestFailInAttribue$T4).get(node));

      } else {
        SNodeFactoryOperations.setNewAttribute(node, new IAttributeDescriptor.NodeAttribute(CONCEPTS.OFXTestFailInAttribue$T4), CONCEPTS.OFXTestFailInAttribue$T4);

      }

    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      if (!(isApplicableToNode(node, editorContext))) {
        return false;
      }
      return true;
    }

    private boolean isApplicableToNode(final SNode node, final EditorContext editorContext) {
      // allways allow remove operation
      if ((SNodeOperations.getNodeAncestor(node, CONCEPTS.OFXTestFailInAttribue$T4, true, false) != null) || (new IAttributeDescriptor.NodeAttribute(CONCEPTS.OFXTestFailInAttribue$T4).get(node) != null)) {
        return true;
      }

      // okay, probably not a remove but an add?
      if ((SNodeOperations.getNodeAncestor(node, CONCEPTS.OFXTestMethod$cv, false, false) == null)) {
        return false;
      }

      // ok, in test method.
      return OFXUtil.parentDoesNotContainAnyOFXTestFailIn(node);
    }


    @Override
    public IntentionDescriptor getDescriptor() {
      return FailAnnotationIntentionStatement_Intention.this;
    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept OFXTestFailInAttribue$T4 = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7099e1d5362ab542L, "org.modellwerkstatt.objectflow.structure.OFXTestFailInAttribue");
    /*package*/ static final SConcept OFXTestMethod$cv = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x607becf482ad5e9fL, "org.modellwerkstatt.objectflow.structure.OFXTestMethod");
  }
}
