package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionAspectDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Map;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import java.util.Arrays;
import jetbrains.mps.lang.smodel.ConceptSwitchIndex;
import jetbrains.mps.lang.smodel.ConceptSwitchIndexBuilder;
import jetbrains.mps.smodel.adapter.ids.MetaIdFactory;

public final class IntentionsDescriptor extends AbstractIntentionAspectDescriptor {
  private static final IntentionFactory[] EMPTY_ARRAY = new IntentionFactory[0];
  private Map<SAbstractConcept, IntentionFactory[]> myCached = new HashMap<SAbstractConcept, IntentionFactory[]>();

  public IntentionsDescriptor() {
  }

  @Nullable
  public Collection<IntentionFactory> getIntentions(@NotNull SAbstractConcept concept) {
    if (myCached.containsKey(concept)) {
      return Arrays.asList(myCached.get(concept));
    }

    IntentionFactory[] intentions = EMPTY_ARRAY;
    SAbstractConcept cncpt = concept;
    switch (conceptIndex.index(cncpt)) {
      case 0:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new CreateStatementAllProps_Intention();
        }
        break;
      case 1:
        if (true) {
          // concept
          intentions = new IntentionFactory[8];
          intentions[0] = new RemoveCustomProperty_Intention();
          intentions[1] = new CreateCustomProperty_Intention();
          intentions[2] = new AutocompleteBusinessProperty_Intention();
          intentions[3] = new CreateDefaultFormatDateTime_Intention();
          intentions[4] = new AutoCreateStateProc_Intention();
          intentions[5] = new CreateValueObjectForBusinessProperty_Intention();
          intentions[6] = new CreateEntityForBusinessProperty_Intention();
          intentions[7] = new CreateListForBusinessProperty_Intention();
        }
        break;
      case 2:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new CommandUrlParamOption_Intention();
        }
        break;
      case 3:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new ConvertToLocalCmdVariable_Intention();
        }
        break;
      case 4:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new ToggleDateFromServer_Intention();
          intentions[1] = new ConvertToDateTime_Intention();
        }
        break;
      case 5:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new ToggleDateTimeFromServer_Intention();
          intentions[1] = new ConvertToLocalDate_Intention();
        }
        break;
      case 6:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new EmbeddedCreateAllFieldDefault_Intention();
        }
        break;
      case 7:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new MakeAuditable_Intention();
        }
        break;
      case 8:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new CreateAllFieldsDefaultEntity_Intention();
        }
        break;
      case 9:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new GuardTranslateEx_Intention();
        }
        break;
      case 10:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new ToggleReference_Intention();
        }
        break;
      case 11:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new AutocompleteIOFXObject_Intention();
          intentions[1] = new ReAutocompleteIOFXObject_Intention();
        }
        break;
      case 12:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new ConvertLMCToOpCall_Intention();
        }
        break;
      case 13:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new CreatePlatformAwareMultiString_Intention();
          intentions[1] = new CreateTranslatedMultiString_Intention();
        }
        break;
      case 14:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new CreateAllFieldsDefaultNoKey_Intention();
        }
        break;
      case 15:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new OFXTestFailInAttribRemove_Intention();
        }
        break;
      case 16:
        if (true) {
          // concept
          intentions = new IntentionFactory[4];
          intentions[0] = new TestDebugToggle_Intention();
          intentions[1] = new DontExecToggle_Intention();
          intentions[2] = new DontExecForOthers_Intention();
          intentions[3] = new DependentToggel_Intention();
        }
        break;
      case 17:
        if (true) {
          // concept
          intentions = new IntentionFactory[4];
          intentions[0] = new TestDebugAllRemove_Intention();
          intentions[1] = new TestDebugAllAdd_Intention();
          intentions[2] = new DontExecAddAll_Intention();
          intentions[3] = new DontExecRemoveAll_Intention();
        }
        break;
      case 18:
        if (true) {
          // concept
          intentions = new IntentionFactory[3];
          intentions[0] = new OnStatementUseDefaultNoChecks_Intention();
          intentions[1] = new OnStatementCreateDefault_Intention();
          intentions[2] = new OnStatementRemainingCasesToNextCase_Intention();
        }
        break;
      case 19:
        if (true) {
          // concept
          intentions = new IntentionFactory[4];
          intentions[0] = new OperationCallToggleFormat_Intention();
          intentions[1] = new OperationCallRemoveSession_Intention();
          intentions[2] = new AddOpCallSessionOperationAdd_Intention();
          intentions[3] = new ConvertOpCallToLMC_Intention();
        }
        break;
      case 20:
        if (true) {
          // concept
          intentions = new IntentionFactory[3];
          intentions[0] = new TwoLinerForCheck_Intention();
          intentions[1] = new AddOptionToPrecondition_Intention();
          intentions[2] = new AddCmdToSolve_Intention();
        }
        break;
      case 21:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new SelectedObjectChDerived_Intention();
        }
        break;
      case 22:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new AutoCompleteNoKeyMapping_Intention();
          intentions[1] = new AutoCompleteNoKeyMappingTesting_Intention();
        }
        break;
      case 23:
        if (true) {
          // concept
          intentions = new IntentionFactory[3];
          intentions[0] = new FailAnnotationIntentionStatement_Intention();
          intentions[1] = new OperationCallExpandAll_Intention();
          intentions[2] = new OperationCallCollapseAll_Intention();
        }
        break;
      case 24:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new AutoCompleteStatusDeclaration_Intention();
        }
        break;
      case 25:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new AutocompleteStatusElement_Intention();
        }
        break;
      case 26:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new InsertTitleDelimiter_Intention();
        }
        break;
      case 27:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new CreateTranslatedStringLiteral_Intention();
          intentions[1] = new DeletTranslatedStringLiteral_Intention();
        }
        break;
      case 28:
        if (true) {
          // concept
          intentions = new IntentionFactory[2];
          intentions[0] = new AutocompleteMethodsValueObject_Intention();
          intentions[1] = new CreateFullyEqualsValueObject_Intention();
        }
        break;
      default:
    }
    myCached.put(concept, intentions);
    return Arrays.asList(intentions);
  }

  @NotNull
  @Override
  public Collection<IntentionFactory> getAllIntentions() {
    IntentionFactory[] rv = new IntentionFactory[58];
    rv[0] = new CreateStatementAllProps_Intention();
    rv[1] = new MakeAuditable_Intention();
    rv[2] = new ToggleDateTimeFromServer_Intention();
    rv[3] = new ToggleDateFromServer_Intention();
    rv[4] = new AutocompleteMethodsValueObject_Intention();
    rv[5] = new RemoveCustomProperty_Intention();
    rv[6] = new CreateCustomProperty_Intention();
    rv[7] = new ConvertToLocalDate_Intention();
    rv[8] = new ConvertToDateTime_Intention();
    rv[9] = new AutocompleteStatusElement_Intention();
    rv[10] = new AutocompleteBusinessProperty_Intention();
    rv[11] = new ToggleReference_Intention();
    rv[12] = new TestDebugToggle_Intention();
    rv[13] = new DontExecToggle_Intention();
    rv[14] = new TestDebugAllRemove_Intention();
    rv[15] = new TestDebugAllAdd_Intention();
    rv[16] = new DontExecAddAll_Intention();
    rv[17] = new DontExecRemoveAll_Intention();
    rv[18] = new FailAnnotationIntentionStatement_Intention();
    rv[19] = new DontExecForOthers_Intention();
    rv[20] = new OFXTestFailInAttribRemove_Intention();
    rv[21] = new DependentToggel_Intention();
    rv[22] = new SelectedObjectChDerived_Intention();
    rv[23] = new EmbeddedCreateAllFieldDefault_Intention();
    rv[24] = new CreateAllFieldsDefaultEntity_Intention();
    rv[25] = new CreateDefaultFormatDateTime_Intention();
    rv[26] = new CreateAllFieldsDefaultNoKey_Intention();
    rv[27] = new AutoCompleteNoKeyMapping_Intention();
    rv[28] = new AutoCompleteNoKeyMappingTesting_Intention();
    rv[29] = new CreatePlatformAwareMultiString_Intention();
    rv[30] = new CreateTranslatedStringLiteral_Intention();
    rv[31] = new DeletTranslatedStringLiteral_Intention();
    rv[32] = new CreateTranslatedMultiString_Intention();
    rv[33] = new OperationCallToggleFormat_Intention();
    rv[34] = new GuardTranslateEx_Intention();
    rv[35] = new TwoLinerForCheck_Intention();
    rv[36] = new AddOptionToPrecondition_Intention();
    rv[37] = new OperationCallRemoveSession_Intention();
    rv[38] = new OperationCallExpandAll_Intention();
    rv[39] = new OperationCallCollapseAll_Intention();
    rv[40] = new AutoCreateStateProc_Intention();
    rv[41] = new ConvertToLocalCmdVariable_Intention();
    rv[42] = new AddOpCallSessionOperationAdd_Intention();
    rv[43] = new ConvertLMCToOpCall_Intention();
    rv[44] = new ConvertOpCallToLMC_Intention();
    rv[45] = new AutocompleteIOFXObject_Intention();
    rv[46] = new AutoCompleteStatusDeclaration_Intention();
    rv[47] = new CreateFullyEqualsValueObject_Intention();
    rv[48] = new CreateValueObjectForBusinessProperty_Intention();
    rv[49] = new CreateEntityForBusinessProperty_Intention();
    rv[50] = new CreateListForBusinessProperty_Intention();
    rv[51] = new ReAutocompleteIOFXObject_Intention();
    rv[52] = new InsertTitleDelimiter_Intention();
    rv[53] = new OnStatementUseDefaultNoChecks_Intention();
    rv[54] = new OnStatementCreateDefault_Intention();
    rv[55] = new OnStatementRemainingCasesToNextCase_Intention();
    rv[56] = new CommandUrlParamOption_Intention();
    rv[57] = new AddCmdToSolve_Intention();
    return Arrays.asList(rv);
  }
  private static final ConceptSwitchIndex conceptIndex = new ConceptSwitchIndexBuilder().put(MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x47f4bc5a7f048418L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd989eafL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7e6e0be63f72b6fL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7e6e0be63f72b70L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476ab6L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x505557f745172e1bL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6a58e95ae197eeaL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L), MetaIdFactory.conceptId(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x6c6b6a1e379f9404L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x31c16699f45ad44aL), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7099e1d5362ab542L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x607becf482ad5e9fL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7ea9ccdc2f1abad1L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x505557f74600572cL), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7037ca72de981e40L), MetaIdFactory.conceptId(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6e6706e518453b9cL), MetaIdFactory.conceptId(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b215L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x45334e0957030122L), MetaIdFactory.conceptId(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6f25d9824ef9bfaaL)).seal();
}
