package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.annotations.NotNull;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import javax.swing.JOptionPane;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.util.SQLDescTableParser;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;

public class DbDescribeToEntity_Action extends BaseAction {
  private static final Icon ICON = null;

  public DbDescribeToEntity_Action() {
    super("Werkbank - Create Entity / Mapping from DESC", "Entity from SQL desc table", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      SNode p = event.getData(MPSCommonDataKeys.NODE);
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    SNode persistanceDescription = event.getData(MPSCommonDataKeys.NODE);

    if (persistanceDescription == null || !(SNodeOperations.isInstanceOf(persistanceDescription, CONCEPTS.PersistenceDescription$pP))) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Selected a 'persistance description' where EntityMapping should be put in . . .", "Wrong selection in project explorer", JOptionPane.ERROR_MESSAGE);
      return;
    }



    // ok, use dialog and create nodes
    CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste SQL here...");
    dialog.showDialog();

    SModel mod = SNodeOperations.getModel(persistanceDescription);

    if (dialog.isOkay()) {
      String content = dialog.myText.getText().toString();

      SNode createdBusinessObject = SNodeFactoryOperations.createNewRootNode(mod, CONCEPTS.Entity$WP, null);
      ListSequence.fromList(SLinkOperations.getChildren(createdBusinessObject, LINKS.businessProperties$cI4J)).clear();

      SNode entityMapping = SNodeFactoryOperations.addNewChild(SNodeOperations.cast(persistanceDescription, CONCEPTS.PersistenceDescription$pP), LINKS.persistenceMapping$S18_, CONCEPTS.EntityMapping$ux);

      try {
        SQLDescTableParser parser = new SQLDescTableParser(content);
        parser.parse(createdBusinessObject, entityMapping);


      } catch (Exception e) {
        e.printStackTrace();

        SNodeOperations.deleteNode(createdBusinessObject);
        SNodeOperations.deleteNode(entityMapping);
        JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", JOptionPane.ERROR_MESSAGE);

      }

    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept PersistenceDescription$pP = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, "org.modellwerkstatt.manmap.structure.PersistenceDescription");
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, "org.modellwerkstatt.manmap.structure.EntityMapping");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink persistenceMapping$S18_ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, 0xc18788c4e46d0b0L, "persistenceMapping");
  }
}
