package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.sdservices.VField;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SConcept;

public class JsonCreator {
  private SModel mod;
  private IConvFormatOptions formatters;
  private boolean allEncompassing;


  private List<SNode> allCreatedObjects = ListSequence.fromList(new ArrayList<SNode>());

  public JsonCreator(SModel m, IConvFormatOptions form, boolean all) {
    mod = m;
    formatters = form;
    allEncompassing = all;
  }

  private String nameFor(String name, VField.VType t) {
    if (t == VField.VType.NULL) {
      return name + "_NULL";
    }
    if (t == VField.VType.OBJECT) {
      return name + "_OBJECT";
    }
    return name;
  }
  private void createField(SNode currentObj, String name, String value, VField.VType type) {

    name = nameFor(name, type);
    if (type == VField.VType.NULL) {
      ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0c0k(), name));

    } else if (type == VField.VType.INT) {
      ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0a2a01(), name));

    } else if (type == VField.VType.STRING) {
      // check decimal, localdate, datetime, string else... 

      Object obj = JackyInfra.identifyString(formatters, value);

      if (obj instanceof LocalDate) {
        ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0e0b2a01(), name));

      } else if (obj instanceof DateTime) {
        ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0a4a1c0k(), name));

      } else if (obj instanceof BigDecimal) {
        ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0b4a1c0k(), name));

      } else {
        ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0a4a1c0k_0(), name));

      }

    } else if (type == VField.VType.BIGDECIMAL) {
      ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0c2a01(), name));


    } else if (type == VField.VType.BOOLEAN) {
      SNode statusType = ObjHlpr.getTrueFalseStatus(ListSequence.fromList(allCreatedObjects).getElement(0));
      ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, statusType, name));


    } else if (type == VField.VType.OBJECT) {
      ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForField(mod, _quotation_createNode_bnsruq_b0a0a0e2a01(), name));

    } else {
      throw new RuntimeException("Unknown field type " + type);
    }
  }
  private void createBuilderForField(SNode currentObj, SNode currentBuilder, String name, String value, VField.VType cls) {
    final Wrappers._T<String> _name = new Wrappers._T<String>(name);

    _name.value = nameFor(_name.value, cls);
    _name.value = ObjHlpr.ESCAPED_OBJ_NAMES(_name.value);

    SNode prop = ListSequence.fromList(SLinkOperations.getChildren(currentObj, LINKS.businessProperties$cI4J)).findFirst((it) -> SPropertyOperations.getString(it, PROPS.propertyName$DLW4).equals(_name.value));

    if (cls == VField.VType.NULL) {
      ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop));

    } else if (cls == VField.VType.INT) {
      ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, new Integer(value)));

    } else if (cls == VField.VType.STRING) {
      // check decimal, localdate, datetime, string else... 
      VField.VType type = VField.VType.STRING;
      if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL)) {
        type = JackyInfra.cTypeFromFQName(INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr)));
      }

      if (type == VField.VType.LOCALDATE) {
        LocalDate date = formatters.parseLocalDate(value);
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, date));

      } else if (type == VField.VType.DATETIME) {
        DateTime dt = formatters.parseDateTime(value);
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, dt));

      } else if (type == VField.VType.BIGDECIMAL) {
        BigDecimal deci = formatters.parseBigDecimal(value);
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, deci));

      } else {
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, value));
      }

    } else if (cls == VField.VType.BIGDECIMAL) {
      ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, formatters.parseBigDecimal(value)));

    } else if (cls == VField.VType.BOOLEAN) {
      SNode statusType = ObjHlpr.getTrueFalseStatus(ListSequence.fromList(allCreatedObjects).getElement(0));

      if (value.toLowerCase().equals("true")) {
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(statusType, LINKS.status$PoDo), LINKS.element$GLWK)).first()));
      } else {
        ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop, ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(statusType, LINKS.status$PoDo), LINKS.element$GLWK)).last()));
      }

    } else if (cls == VField.VType.OBJECT) {
      ListSequence.fromList(SLinkOperations.getChildren(currentBuilder, LINKS.elements$1zqT)).addElement(BldrHlpr.belem(prop));

    } else {
      throw new RuntimeException("Unknown field type " + cls);
    }
  }





  private SNode createObjectDtoGraph(SNode currentVo, VElement elem) {

    if (elem instanceof VObject) {
      VObject obj = ((VObject) elem);
      SNode newVo = null;

      newVo = ObjHlpr.createVo(mod, obj);
      ListSequence.fromList(allCreatedObjects).addElement(newVo);
      ListSequence.fromList(SLinkOperations.getChildren(currentVo, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForDTO(mod, newVo, obj.name));

      for (VElement it : obj.fields) {
        createObjectDtoGraph(newVo, it);
      }
      return newVo;

    } else if (elem instanceof VList) {
      VList list = ((VList) elem);

      VObject elementPrototype;
      if (list.objects.size() == 0) {
        elementPrototype = new VObject(null, null);
      } else {
        elementPrototype = list.objects.get(0);
      }
      elementPrototype.name = MoVersion.getCapitalizedShortNameFromFQ(list.name);

      SNode proto = createObjectDtoGraph(currentVo, elementPrototype);
      SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(ListSequence.fromList(SLinkOperations.getChildren(currentVo, LINKS.businessProperties$cI4J)).last(), LINKS.type$56v0, CONCEPTS.ListType$LR), LINKS.elementType$ssn, ObjHlpr.ct(proto));

      if (allEncompassing) {
        for (int i = 1; i < list.objects.size(); i++) {
          VObject otherProto = list.objects.get(i);
          otherProto.name = elementPrototype.name;

          checkAndAdd(currentVo, otherProto);
        }
      }



    } else {
      VField fld = ((VField) elem);
      createField(currentVo, fld.name, fld.value, fld.type);

    }

    return null;
  }

  private SNode checkAndAdd(SNode currentVo, VElement elem) {

    if (elem instanceof VObject) {
      VObject obj = ((VObject) elem);
      final String name = MoVersion.getCapitalizedShortNameFromFQ(ObjHlpr.ESCAPED_OBJ_NAMES(obj.name));
      SNode newVo = ListSequence.fromList(allCreatedObjects).findFirst((it) -> SPropertyOperations.getString(it, PROPS.name$MnvL).equals(name));

      String propName = MoVersion.getLowerShortNameFromFQ(obj.name);
      if (!(ObjHlpr.PROP_EXISTS(currentVo, propName))) {
        ListSequence.fromList(SLinkOperations.getChildren(currentVo, LINKS.businessProperties$cI4J)).addElement(ObjHlpr.propForDTO(mod, newVo, obj.name));

      }

      for (VElement it : obj.fields) {
        checkAndAdd(newVo, it);
      }
      return newVo;

    } else if (elem instanceof VList) {
      VList list = ((VList) elem);

      if (list.objects.size() > 0) {
        VObject elementPrototype = list.objects.get(0);
        elementPrototype.name = MoVersion.getCapitalizedShortNameFromFQ(list.name);

        checkAndAdd(currentVo, elementPrototype);

        for (int i = 1; i < list.objects.size(); i++) {
          VObject otherProto = list.objects.get(i);
          otherProto.name = elementPrototype.name;
          checkAndAdd(currentVo, otherProto);
        }
      }

    } else {
      VField fld = ((VField) elem);

      String propName = nameFor(fld.name, fld.type);
      if (!(ObjHlpr.PROP_EXISTS(currentVo, propName))) {
        createField(currentVo, fld.name, fld.value, fld.type);
      }


    }

    return null;
  }



  private void createBuilder(SNode currentVo, SNode currentBldr, VElement elem, int listElementNum) {

    if (elem instanceof VObject) {
      VObject obj = ((VObject) elem);

      final String voName = MoVersion.getCapitalizedShortNameFromFQ(ObjHlpr.ESCAPED_OBJ_NAMES(obj.name));
      SNode theVo = ListSequence.fromList(allCreatedObjects).findFirst((it) -> SPropertyOperations.getString(it, PROPS.name$MnvL).equals(voName));
      if (theVo == null) {
        throw new RuntimeException("This can not happen. Looking for obj.name '" + voName + "' but did not find anything.");
      }


      final String propertyName = ObjHlpr.ESCAPED_OBJ_NAMES(MoVersion.getLowerShortNameFromFQ(obj.name));
      SNode prop = ListSequence.fromList(SLinkOperations.getChildren(currentVo, LINKS.businessProperties$cI4J)).findFirst((it) -> SPropertyOperations.getString(it, PROPS.propertyName$DLW4).equals(propertyName));
      if (prop == null) {
        throw new RuntimeException("This can not happen. Looking for prop '" + propertyName + "' but did not find the property in " + SPropertyOperations.getString(currentVo, PROPS.name$MnvL));
      }


      if (listElementNum == -1) {
        // not in list at all
        SNode sbe = SNodeFactoryOperations.addNewChild(currentBldr, LINKS.elements$1zqT, CONCEPTS.SimpleBuilderElement$6W);
        SLinkOperations.setTarget(sbe, LINKS.property$b3UB, prop);
        SNode newBuilder = SNodeFactoryOperations.setNewChild(sbe, LINKS.expression$aYxg, CONCEPTS.BuilderExpression$5Y);
        SLinkOperations.setTarget(newBuilder, LINKS.type$ovXx, ObjHlpr.ct(theVo));

        for (VElement it : obj.fields) {
          createBuilder(theVo, newBuilder, it, -1);
        }


      } else if (listElementNum >= 0) {
        SNode lbe = SNodeFactoryOperations.addNewChild(currentBldr, LINKS.elements$1zqT, CONCEPTS.ListBuilderElement$fh);
        SLinkOperations.setTarget(lbe, LINKS.property$b3UB, prop);
        SNode newListBuilder = SNodeFactoryOperations.setNewChild(lbe, LINKS.expression$aYxg, CONCEPTS.BuilderExpression$5Y);
        SLinkOperations.setTarget(newListBuilder, LINKS.type$ovXx, ObjHlpr.ct(theVo));

        for (VElement it : obj.fields) {
          createBuilder(theVo, newListBuilder, it, -1);
        }

      }


    } else if (elem instanceof VList) {
      VList list = ((VList) elem);

      for (int i = 0; i < list.objects.size(); i++) {
        list.objects.get(i).name = MoVersion.getCapitalizedShortNameFromFQ(list.name);
        createBuilder(currentVo, currentBldr, list.objects.get(i), i);
      }


    } else {
      VField fld = ((VField) elem);
      createBuilderForField(currentVo, currentBldr, fld.name, fld.value, fld.type);

    }
  }


  public void create(VObject elem) {

    JackyInfra.printDebugObject("", elem);

    SNode root = ObjHlpr.createVo(mod, elem);
    ListSequence.fromList(allCreatedObjects).addElement(root);

    for (VElement it : elem.fields) {
      createObjectDtoGraph(root, it);
    }


    SNode factory;
    SNode simd;
    factory = SNodeFactoryOperations.createNewRootNode(mod, CONCEPTS.Service$HK, null);
    SPropertyOperations.assign(factory, PROPS.name$MnvL, "JsonRootFactory");

    simd = SNodeFactoryOperations.addNewChild(factory, LINKS.member$L_2d, CONCEPTS.ServiceInstanceMethodDeclaration$ww);
    ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE)).clear();
    SPropertyOperations.assign(simd, PROPS.name$MnvL, "create");

    SNode rootBuilder = BldrHlpr.configSimd(simd, root);

    for (VElement it : elem.fields) {
      createBuilder(root, rootBuilder, it, -1);
    }

  }



  private static SNode _quotation_createNode_bnsruq_b0a0a0a2a01() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0xf940d22479L, "IntegerType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0c0k() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x11d47da71ecL, "StringType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0e0b2a01() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~LocalDate");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0a4a1c0k() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~DateTime");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0b4a1c0k() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0a4a1c0k_0() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x11d47da71ecL, "StringType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0c2a01() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_bnsruq_b0a0a0e2a01() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x11d47da71ecL, "StringType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink elements$1zqT = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L, 0x55266b8679f4de75L, "elements");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SReferenceLink status$PoDo = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8397033dL, 0x5b98aafabfcedbd3L, "status");
    /*package*/ static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, 0x3ee8b55a8395b858L, "element");
    /*package*/ static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, 0x10c25fe95c5L, "elementType");
    /*package*/ static final SReferenceLink property$b3UB = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3591b3fa7e02ac8bL, 0x3591b3fa7e356b16L, "property");
    /*package*/ static final SContainmentLink expression$aYxg = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3591b3fa7e02ac8bL, 0x3591b3fa7e356b14L, "expression");
    /*package*/ static final SContainmentLink type$ovXx = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L, 0x717214f13066ffe8L, "type");
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
    /*package*/ static final SContainmentLink body$5xQk = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1ffL, "body");
    /*package*/ static final SContainmentLink statement$53DE = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b200L, 0xf8cc6bf961L, "statement");
  }

  private static final class PROPS {
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SConcept ListType$LR = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, "jetbrains.mps.baseLanguage.collections.structure.ListType");
    /*package*/ static final SConcept SimpleBuilderElement$6W = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de76L, "org.modellwerkstatt.objectflow.structure.SimpleBuilderElement");
    /*package*/ static final SConcept BuilderExpression$5Y = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L, "org.modellwerkstatt.objectflow.structure.BuilderExpression");
    /*package*/ static final SConcept ListBuilderElement$fh = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3591b3fa7db2be6eL, "org.modellwerkstatt.objectflow.structure.ListBuilderElement");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept ServiceInstanceMethodDeclaration$ww = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6de6af0ef2406677L, "org.modellwerkstatt.objectflow.structure.ServiceInstanceMethodDeclaration");
  }
}
