package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.annotations.NotNull;
import javax.swing.JOptionPane;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.sdservices.JackyParsed;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SProperty;

public class JsonToDTO_Action extends BaseAction {
  private static final Icon ICON = null;

  public JsonToDTO_Action() {
    super("Werkbank - Create DTOs from JSON", "JSON data to DTO hierarchy", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      SModel p = event.getData(MPSCommonDataKeys.MODEL);
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    SModel targetMod = event.getData(MPSCommonDataKeys.MODEL);

    if (targetMod == null) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Selected a model where DTOs should be put in . . . [" + event.getData(MPSCommonDataKeys.MODEL) + "]", "Wrong selection in project explorer", JOptionPane.ERROR_MESSAGE);
      return;
    }

    if (ListSequence.fromList(SModelOperations.roots(targetMod, CONCEPTS.DTO$UE)).any((it) -> "ROOT".equals(SPropertyOperations.getString(it, PROPS.name$MnvL)))) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Model contains already a DTO named as ROOT. Rename that one first.", "There is already a ROOT present in the model.", JOptionPane.ERROR_MESSAGE);
      return;
    }


    // ok, use dialog and create nodes
    JSONImportDialog dialog = new JSONImportDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste JSON here...");
    dialog.showDialog();




    if (dialog.isOkay()) {
      String jSonContent = dialog.myText.getText().toString();
      ConvFormatOptions options = new ConvFormatOptions(dialog.dateTimeFormat.getText(), dialog.localDateFormat.getText(), dialog.bigDeciFormat.getText(), "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

      try {

        JackyParsed parser = new JackyParsed();
        JackyInfra hlp = new JackyInfra();

        JsonCreator creator = new JsonCreator(event.getData(MPSCommonDataKeys.MODEL), new ConvStdFormatters(options), dialog.allEncompassing.isSelected());

        VParent elem = parser.parse(hlp.createParser(jSonContent));
        VObject rootObject = null;

        if (elem.isList()) {
          rootObject = ((VList) elem).objects.get(0);
          rootObject.name = "ROOT";

        } else {
          rootObject = ((VObject) elem);
        }
        creator.create(rootObject);

      } catch (Exception e) {
        e.printStackTrace();

        JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", JOptionPane.ERROR_MESSAGE);

      }

    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }
}
