package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import org.jetbrains.mps.openapi.model.SNode;
import org.springframework.util.StringUtils;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;

public class MoMdlAccess {
  public static final String P = ".";
  public List<SModel> models;
  public List<String> modelNames;


  public MoMdlAccess(MPSProject prj) {
    models = relevantModels(prj, true);
    modelNames = ListSequence.fromList(new ArrayList<String>());

    for (SModel mod : models) {
      ListSequence.fromList(modelNames).addElement(getNameForModel(SModelOperations.getModelName(mod)));
    }
  }


  public SModel getModel(String name) {
    if (name == null) {
      return null;
    }
    int index = ListSequence.fromList(modelNames).indexOf(name);
    if (index < 0) {
      throw new RuntimeException("This can not happen, index for " + name + " is " + index);
    }
    return ListSequence.fromList(models).getElement(index);
  }

  public SNode searchStaticRessources() {
    SNode sr = null;

    for (SModel m : models) {
      sr = ListSequence.fromList(SModelOperations.roots(m, CONCEPTS.StaticRessources$xz)).first();
      if (sr != null) {
        break;
      }
    }

    if (sr == null) {
      throw new RuntimeException("You have not defined a StaticRessource concept in your project yet.");
    }
    return sr;
  }

  public List<String> getAllModelNames() {
    return modelNames;
  }

  public String getNameForModel(String st) {
    String fqName = st;
    int hierarchyCount = StringUtils.countOccurrencesOf(fqName, P);

    if (hierarchyCount == 0) {
      return fqName;

    } else if (hierarchyCount == 1) {
      int pos = fqName.indexOf(P);
      return fqName.substring(pos + 1);

    } else {
      // use last two.. thats enough
      int lastPos = fqName.lastIndexOf(P);
      int semiLastPos = fqName.substring(0, lastPos - 1).lastIndexOf(P);
      return fqName.substring(semiLastPos + 1);
    }
  }


  public static List<SModel> relevantModels(MPSProject prj, boolean withTests) {
    String STUB_IDENTIFIER = "JavaClassStubModelDescriptor";
    String TEST_IDENTIFIER = "test";

    List<SModel> allRelevantModels = ListSequence.fromList(new ArrayList<SModel>());
    for (SModel mod : prj.getProjectModels()) {
      String desc = "" + mod;
      if (withTests && !(desc.contains(STUB_IDENTIFIER))) {
        ListSequence.fromList(allRelevantModels).addElement(mod);
      } else if (!(desc.contains(STUB_IDENTIFIER)) && !(desc.toLowerCase().contains(TEST_IDENTIFIER))) {
        ListSequence.fromList(allRelevantModels).addElement(mod);
      }
    }
    return allRelevantModels;
  }





  public static List<SModel> getImportedModels(SModel m) {
    List<SModel> imp = ListSequence.fromList(new ArrayList<SModel>());
    for (SModel a : jetbrains.mps.smodel.SModelOperations.allImportedModels(m)) {
      ListSequence.fromList(imp).addElement(a);
    }
    return imp;
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept StaticRessources$xz = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x13fe307201aa671aL, "org.modellwerkstatt.objectflow.structure.StaticRessources");
  }
}
