package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.util.List;
import org.jetbrains.mps.openapi.module.SModule;
import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.annotations.NotNull;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import javax.swing.JOptionPane;
import org.modellwerkstatt.manmap.conventions.SqlTableDescriber;
import org.modellwerkstatt.manmap.conventions.OracleVendor;
import org.modellwerkstatt.manmap.conventions.MySqlVendor;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;

public class MoWareSchemaExport_Action extends BaseAction {
  private static final Icon ICON = null;

  public MoWareSchemaExport_Action() {
    super("Werkbank - Schema export", "Generate schema info", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      List<SModule> p = event.getData(MPSCommonDataKeys.MODULES);
    }
    {
      SNode p = event.getData(MPSCommonDataKeys.NODE);
    }
    {
      SModel model = event.getData(MPSCommonDataKeys.CONTEXT_MODEL);
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {


    try {
      List<SNode> persDescriptions = ListSequence.fromList(new ArrayList<SNode>());
      final Wrappers._T<String> sourceDescription = new Wrappers._T<String>("");

      if (event.getData(MPSCommonDataKeys.NODE) != null && event.getData(MPSCommonDataKeys.NODE).isInstanceOfConcept(CONCEPTS.PersistenceDescription$pP)) {
        ListSequence.fromList(persDescriptions).addElement(SNodeOperations.cast(event.getData(MPSCommonDataKeys.NODE), CONCEPTS.PersistenceDescription$pP));
        sourceDescription.value = INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SNodeOperations.cast(event.getData(MPSCommonDataKeys.NODE), CONCEPTS.PersistenceDescription$pP));

      } else if (event.getData(MPSCommonDataKeys.CONTEXT_MODEL) != null) {
        List<SNode> pds = SModelOperations.roots(event.getData(MPSCommonDataKeys.CONTEXT_MODEL), CONCEPTS.PersistenceDescription$pP);
        if (ListSequence.fromList(pds).count() > 0) {
          ListSequence.fromList(persDescriptions).addSequence(ListSequence.fromList(pds));
          ListSequence.fromList(pds).visitAll((it) -> sourceDescription.value += INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it) + "\n");
        }

      } else if (event.getData(MPSCommonDataKeys.MODULES) != null && event.getData(MPSCommonDataKeys.MODULES).size() > 0) {
        for (SModule singleModule : event.getData(MPSCommonDataKeys.MODULES)) {
          for (SModel mod : singleModule.getModels()) {
            List<SNode> pds = SModelOperations.roots(mod, CONCEPTS.PersistenceDescription$pP);
            if (ListSequence.fromList(pds).count() > 0) {
              ListSequence.fromList(persDescriptions).addSequence(ListSequence.fromList(pds));
              ListSequence.fromList(pds).visitAll((it) -> sourceDescription.value += INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it) + "\n");
            }
          }
        }
      }

      if (ListSequence.fromList(persDescriptions).count() == 0) {
        JOptionPane.showMessageDialog(null, "No PersistanceDescriptions found, select a single one or one+ solutions.", "Serious problem", JOptionPane.ERROR_MESSAGE);

      } else {
        SchemaExportDialog dlg = new SchemaExportDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Schema/Alters Export", "persistence descriptions");
        dlg.setDescriptionsText(persDescriptions);
        dlg.showDialog();

        if (dlg.isOkay()) {
          final Wrappers._T<String> resultSt = new Wrappers._T<String>("");
          if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.ORACLE_SCHEMA)) {
            final SqlTableDescriber desc = new SqlTableDescriber(new OracleVendor());
            ListSequence.fromList(persDescriptions).visitAll((it) -> resultSt.value += desc.getSchemaForPersistenceDesc(it) + "\n\n");

          } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.MYSQL_SCHEMA)) {
            final SqlTableDescriber desc = new SqlTableDescriber(new MySqlVendor());
            ListSequence.fromList(persDescriptions).visitAll((it) -> resultSt.value += desc.getSchemaForPersistenceDesc(it) + "\n\n");

          } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.ORACLE_ALTER)) {
            final SqlTableDescriber desc = new SqlTableDescriber(new OracleVendor());
            ListSequence.fromList(persDescriptions).visitAll((it) -> resultSt.value += desc.getAlterForPersistenceDesc(it) + "\n\n");

          } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.MYSQL_ALTER)) {
            final SqlTableDescriber desc = new SqlTableDescriber(new MySqlVendor());
            ListSequence.fromList(persDescriptions).visitAll((it) -> resultSt.value += desc.getAlterForPersistenceDesc(it) + "\n\n");

          } else {
            throw new RuntimeException("This can not happen.");
          }

          // do Schema Stuff
          CopyPasteDialog resultDlg = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated result", resultSt.value);
          resultDlg.showDialog();
        }




      }

    } catch (Exception e) {
      System.err.println("\n\n\n ------ SERIOUS Problem while generating schema -----------------------------------------\n");
      e.printStackTrace();

      JOptionPane.showMessageDialog(null, "A problem occurred while trying to generate sql schema!\n\n" + e.getMessage() + "\n\n\n", "Serious problem", JOptionPane.ERROR_MESSAGE);
    }
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept PersistenceDescription$pP = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, "org.modellwerkstatt.manmap.structure.PersistenceDescription");
  }
}
